<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Common Function Class   TAYGOD通用功能类
 *
 * @package		CodeIgniter
 * @subpackage	Libraries
 * @category	Common
 * @author		ExpressionEngine Dev Team
 * @link		http://taygod.com
 */
class Common {
	
	var $ci;
	
	function __construct(){
		
		$this->ci = &get_instance();
		
	}
	
	
	//获取程序版本
	function _get_version(){
		
		//$this->ci->load->library('encrypt');
		//$msg = 'W4Snw3mD6okk+IuD4KuX0TeLXkTlaoC1rMfz9zrMuP2U6SOcXn6ceRMr9HQuzb+2h1QNz44P1EFfPgImaj4+vA==';
		//$this->ci->S['version'] = $this->ci->encrypt->decode($msg, str_replace('encrypt', '', setting('key')));
		$this->ci->S['version'] = TAYCMS_NAME.' '. TAYCMS_VERSION .' build '.TAYCMS_BUILDTIME;
		$this->ci->S['softname'] = 'TayCMS 免费企业建站系统 PHP版';
		$this->ci->S['updatetime'] = TAYCMS_BUILDTIME;
		
	}
	
	
	/**
	 * 
	 * 新闻数据读取函数
	 * @param string $classid	  分类ID  多分类可以用逗号隔开  如1,2
	 * @param int $num			  读取的新闻数量
	 * @param int $isgood		  推荐等级  数字1-9
	 * @param bool $titlepic		是否只显示标题图片
	 * @param string $order		排序语句
	 */
	function _news($classid = NULL, $num = 10 , $isgood = 0 ,$titlepic = 0,$order = NULL){
		
		$this->ci->load->_model('Model_news','news');
	
		$where = '';
		if($classid){
			$where .= " classid in ($classid) and ";
		}
		
		if($isgood){
			$where .= " isgood = $isgood  and ";
		}
		
		
		if($titlepic){
			$where .= " showpic <> '' and    ";
		}
		 
		$where .= ' 1=1 ';
		$result = $this->ci->news->get_all_news_rows($where,'*', $order ,  0,  $num);
		
		return $result;
		
		
	}
	
	/**
	 * 
	 * 产品数据读取函数
	 * @param string $classid	  分类ID  多分类可以用逗号隔开  如1,2
	 * @param string $brandid	  品牌ID  多品牌可以用逗号隔开  如1,2
	 * @param int $num			  读取的产品数量
	 * @param int $isgood		  推荐等级  数字1-9
	 * @param bool $titlepic		是否只显示标题图片
	 * @param string $order		排序语句
	 */
	function _products($classid = NULL, $num = 10 , $isgood = 0 ,$titlepic = 0,$order = NULL){
		
		$this->ci->load->_model('Model_product','product');
	
		if($classid){
			$where = " classid in ($classid) and ";
		}
	
		if($isgood){
			$where = " isgood = '$isgood'  and ";
		}
		
		if($titlepic){
			$where .= " showpic <> '' and    ";
		}
		 
		$where .= ' 1=1 ';
		
		
		$result = $this->ci->product->get_all_rows($where,'*',$order,0, $num);
		
		
		return $result;
		
	}
	
	/**
	 * 读取碎片代码
	 * @param string $name   //碎片名称
	 */
	function _chips($name){
		$this->ci->load->_model('Model_chips','chips');
			$where = " `chipname` = '$name' "; 
		$result = $this->ci->chips->field($where, 'content', NULL ,  0,   1);
		
		return $result;
	}
	
 	/**
 	 * 读留言信息代码
 	 * @param unknown_type $num             调用条数
 	 * @param unknown_type $isshow          1：调用审核后留言 0：调用全部留言
 	 * @param unknown_type $reply			1：调用已回复留言 0：调用全部留言
 	 * @param unknown_type $order			排序  字符串如： id desc   默认 id desc
 	 */
	function _message($num = 10,$isshow = 1 ,$reply = 1,$order='id desc'){
		$this->ci->load->_model('Model_message','message');
			$where = '';
			if($isshow)
			{
				$where = " `isshow` = $isshow and  ";
			}
			
			if($reply)
			{
				$where .= " `reply` <>'' ";
			}
			
		$result = $this->ci->message->find_all($where, '*', $order ,  0,   $num);
		
		return $result;
	}
	
	
	/**
	 * 读广告信息代码
	 * @param unknown_type $classid          分类id
	 * @param unknown_type $isshow          1：显示的广告   0：调用全部广告
	 * @param unknown_type $order			排序  字符串如： id desc   默认 id desc
	 */
	function _ad_list($classid ,$num=5,$status = 1 ,$order='order  asc,id desc'){
		$this->ci->load->_model('Model_ad','ad');
		$where = '';
	
		$where  = "`classid` = '$classid' and ";
		if($status)
		{
			$where .= " `status` = $status   ";
		}
			
		$result = $this->ci->ad->find_all($where, '*', $order ,  0,   $num);
	
		return $result;
	}
	
	/**
	 * 根据id读广告信息代码
	 * @param unknown_type $id          广告id 逗号分开 ,
  	 */
	function _ad($id,$num=10,$order = 'order asc'){
		$this->ci->load->_model('Model_ad','ad');
		$where = '';
		
		$where = " `status` = 1 and   ";
		
		if(!is_numeric($id))
		{
			$where .= " `id` in ($id)   ";
			$result = $this->ci->ad->find_all($where, '*', $order ,  0,   $num);
		}
		else
		{
			$result = $this->ci->ad->find($where . 'id  = ' . $id);
		}
			
		
	
		return $result;
	}
	
	/**
	 * 
	 * 产品分类读取函数
	 * @param string $fid	  父分类ID  多分类可以用逗号隔开  如1,2
	 * @param int $num			  读取的新闻数量
  	 * @param string $order		排序语句
	 */
	function _productclass($fid = NULL, $num = 10, $order = NULL){
		
		$this->ci->load->_model('Model_tclass','class');
		$where = " tbname='product'  ";
		if($fid){
			$where .= " and bclassid in ($fid)  ";
		}
 
		$result = $this->ci->class->find_all($where,'*', $order ,  0,  $num);
		
		return $result;
		
		
	}


    /**
     * 获取分类
     */

    function _get_tclass($tbname){

        $where = "(sonclass ='' or sonclass='|') and tbname='$tbname'";
        $this->ci->db->where($where);
        $query = $this->ci->db->get("tclass");
        $result = $query->result_array();  //结果集

        if(isset($result)){
            return $result;    //返回数组
        }else{
            return 0;
        }

    }


    /**
     *
     * 获取单条分类数据
     * @param int $classid
     */
    public function _get_class_row($classid,$tbname=null){

        $this->ci->db->where('classid',$classid);
        if($tbname)
        {
            $this->ci->db->where('tbname',$tbname);
        }
        $query = $this->ci->db->get("tclass");
        $result = $query->row_array();  //结果集
        if(isset($result)){
            return $result;    //返回数组
        }else{
            return 0;
        }

    }


    /**
     * 获取导航
     */

    function _get_nav($type=1){

        $this->ci->load->_model('Model_nav','nav');
        $where = " type='$type'  ";

        $result = $this->ci->nav->find_all($where,'*', '');

        foreach ($result as $key => $value) {

            if(strstr($result[$key]['url'],"http://") || $result[$key]['url'] == '/'  ) //是网址
            {

            }
            else
            {
                $result[$key]['url'] = site_url($result[$key]['url']);
            }


        }

        return $result;

    }


    /**
     * 获取导航
     */

    function _get_flink($typeid=0){

        $this->ci->load->_model('Model_flink','flink');
        $where = " typeid='$typeid'  ";

        $result = $this->ci->flink->find_all($where,'*', '');

        foreach ($result as $key => $value) {



        }

        return $result;

    }

    /**
     *
     * 获取所有子类数据
     * @param int $classid
     */
    public function _get_son_class($bclassid,$tbname=null){

        $this->ci->db->where('bclassid',$bclassid);
        if($tbname)
        {
            $this->ci->db->where('tbname',$tbname);
        }
        $query = $this->ci->db->get("tclass");
        $result = $query->result_array(); //结果集
        if(isset($result)){
            return $result;    //返回数组
        }else{
            return 0;
        }

    }
	
	
}



//----------------------自定义函数-------------------------//


/**
 * 获取友情链接数组
 * $type 数据类型
 */
function flink($typeid=0){
    $com = &get_common();
    return $com->_get_flink($typeid);
}

/**
 * 获取导航数组
 * $type 数据类型
 */
function nav($type=1){
    $com = &get_common();
    return $com->_get_nav($type);
}


/**
 * 获取分类数组
 * $tbname 数据类型
 */
function get_tclass($tbname){
    $com = &get_common();
    return $com->_get_tclass($tbname);
}


/**
 * 获取单条分类数据
 * $classid 分类id
 */
function get_class_row($classid,$tbname=null){
    $com = &get_common();
    return $com->_get_class_row($classid,$tbname);
}


/**
 * 生成通用类对象
 */
function get_common(){
	return new Common();
}

function version($f = FALSE){
	$com = &get_common();
	$com->_get_version();
	if($f)
	{
		echo $com->ci->S['version'];
	}
	else
	{
		echo '<a href="http://www.taygod.com" target=_blank >'.$com->ci->S['version'].'</a>';
	}
}


 
function news($classid = NULL, $num = 10 , $isgood = 0 ,$titlepic = 0,$order = '`id` desc'){
	$com = &get_common();
	return $com->_news($classid, $num , $isgood ,$titlepic,$order );
		
}

function products($classid = 0, $num = 10 , $isgood = 0 ,$titlepic = 0,$order = '`id` desc'){
	$com = &get_common();
	return $com->_products($classid, $num , $isgood ,$titlepic,$order);
}

function chips($name){
	$com = &get_common();
	return $com->_chips($name);
}


function message($num=10,$isshow=1 ,$reply=1,$order='id desc'){
	$com = &get_common();
	return $com->_message($num,$isshow,$reply,$order);
}
function ad_list($typeid,$num=10,$status=1 ,$order='id desc'){
	$com = &get_common();
	return $com->_ad_list($typeid,$num,$status,$order);
}

function ad($id){
	$com = &get_common();
	return $com->_ad($id);
}


function productclass($fid = NULL, $num = 10 ,$order='`order` asc'){
	$com = &get_common();
	return $com->_productclass($fid,$num,$order);
}


/**
 * 获取单条分类数据
 * $classid 分类id
 */
function get_son_class($bclassid,$tbname=null){
    $com = &get_common();
    return $com->_get_son_class($bclassid,$tbname);
}

/*载入编辑器*/


function load_editor($content = '',$id = 'content',$width = '700px',$height='300px',$more=0){

        return '
                                <label>
                                    <textarea id="'.$id.'" name="'.$id.'" style="width:'.$width.';height:'.$height.';">'.$content.'</textarea>
                                </label>
                                    <script charset="utf-8" src="'.base_url().'static/plugins/editor/kindeditor.js"></script>
                                    <script charset="utf-8" src="'.base_url().'static/plugins/editor/lang/zh_CN.js"></script>
                                    <script>
                                        var editor;
                                        KindEditor.ready(function(K) {
                                            editor'.($more?$id:'').' = K.create(\'#'.$id.'\');
                                        });

                                    </script>'
        ;


}

/*载入图片上传按钮*/
function load_imagebtn($inputid = 'image_src',$btnid = 'image'){
    return ' <link rel="stylesheet" href="'.base_url().'static/plugins/editor/themes/default/default.css" />
                                    <script charset="utf-8" src="'.base_url().'static/plugins/editor/kindeditor.js"></script>
                                    <script charset="utf-8" src="'.base_url().'static/plugins/editor/lang/zh_CN.js"></script>
                                    <script charset="utf-8" src="'.base_url().'static/plugins/editor/plugins/code/prettify.js"></script>
                                    <script>
                                        KindEditor.ready(function(K) {
                                            var editorpic = K.editor({
                                                allowFileManager : true
                                            });
                                            K("#'.$btnid.'").click(function() {
                                                editorpic.loadPlugin("image", function() {
                                                    editorpic.plugin.imageDialog({
                                                        imageUrl : K("#'.$inputid.'").val(),
                                                        clickFn : function(url, title, width, height, border, align) {
                                                        K("#'.$inputid.'").val(url);
                                                        editorpic.hideDialog();
                                                    }
                                                    });
                                                });
                                            });
    });
    </script>';
}

/* 
Utf-8、gb2312都支持的汉字截取函数 
cut_str(字符串, 截取长度, 开始长度, 编码); 
编码默认为 utf-8 
开始长度默认为 0 
*/ 

function cut_str($string, $sublen, $start = 0, $code = 'UTF-8') 
{ 
   if($code == 'UTF-8') 
   { 
   $pa = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/"; 
   preg_match_all($pa, $string, $t_string); 

   if(count($t_string[0]) - $start > $sublen) return join('', array_slice($t_string[0], $start, $sublen))."..."; 
   return join('', array_slice($t_string[0], $start, $sublen)); 
   } 
   else 
   { 
   $start = $start*2; 
   $sublen = $sublen*2; 
   $strlen = strlen($string); 
   $tmpstr = ''; 

   for($i=0; $i< $strlen; $i++) 
   { 
   if($i>=$start && $i< ($start+$sublen)) 
   { 
   if(ord(substr($string, $i, 1))>129) 
   { 
   $tmpstr.= substr($string, $i, 2); 
   } 
   else 
   { 
   $tmpstr.= substr($string, $i, 1); 
   } 
   } 
   if(ord(substr($string, $i, 1))>129) $i++; 
   } 
   if(strlen($tmpstr)< $strlen ) $tmpstr.= "..."; 
   return $tmpstr; 
   }

}







/* End of file Common.php */
/* Location: ./app/libraries/Common.php */