<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
 * TAYGOD Company Manage System
 *
 * 基于Codeigniter的企业网站管理系统
 * 
 * TAYGOD is an open source multi-privilege Company Manage System built on the 
 * well-known PHP framework Codeigniter.
 *
 * @package		TAYGOD
 * @author		T.l <madma@163.com>
 * @copyright	Copyright (c) 2012 , taygod.com.
 * @license		GNU General Public License 2.0
 * @link		http://taygod.com/
 * @version		1.0.0
 */
 
// ------------------------------------------------------------------------

/**
 * TAYGOD Category Class
 *
 *  广告操作Model
 *
 * @package		TAYGOD
 * @subpackage	Models
 * @category	Models
 * @author		T.l <madma@163.com>
 * @link		http://taygod.com/
 */

class Model_ad extends Lin_Model {
	
	function __construct(){
		parent::__construct();
		// Load the associated table
        $this->load_table('ad');
        $this->table = 'ad' ;
	}
	 
	
	
	/**
	 *
	 * 获取全部信息内容列表
	 * @return Array  返回信息分类的数组 无结果返回0
	 */
	function get_all_info_list($num = 0,$offset =0 ,$where = array(),$order = 'id desc'){
	
		$this->db->select('a.id, title,typeid,classname,url,a.order,addtime');
		$this->db->where($where);
		$this->db->from($this->table.' as a');
		$this->db->join($this->table."_class as b", 'a.typeid = b.id');
		if($order)$this->db->order_by($order);
		if($num!=0&&$offset!=0){
			$this->db->limit($num, $offset);
		}else{
			$this->db->limit($num);
		}
		$query = $this->db->get();
	
	
		$result = $query->result_array();  //结果集
		if(isset($result)){
			return $result;    //返回信息分类数组
		}else{
			return 0;
		}
	}
	/**
	 *
	 * 获取全部信息分类
	 * @return Array  返回信息分类的数组 无结果返回0
	 */
	function get_all_info_class(){
		$this->db->order_by('`order` asc');
		$query = $this->db->get('ad_class');
		$result = $query->result_array();  //结果集
	
		if(isset($result)){
			return $result;    //返回信息分类数组
		}else{
			return 0;
		}
	}
	
	
/**
	 * 
	 * 获取信息分类数据
	 * @param int $classid
	 */
	public function get_info_class($classid){
		
		$this->db->where('id',$classid);
		$query = $this->db->get($this->table."_class");
		$result = $query->row_array();  //结果集
		if(isset($result)){
			    return $result;    //返回数组
		}else{
				return 0;
		}
		
	}
	
	

	
	
	
	
	

}  //end class




/* End of file model_ad.php */
/* Location: ./core/app/models/model_ad.php */
