<?php
class Model_message extends Lin_Model {
	
	var $table;
	
	function __construct(){
		parent::__construct();
		$this->table = 'message' ;
		$this->load_table('message');
	}
	 
 
 
	/**
	 * 
	 * 获取全部信息内容列表
	 * @return Array  返回信息分类的数组 无结果返回0
	 */
	function get_all_info_list($num = 0,$offset =0 ,$where = array(),$order = 'id desc'){
		
		$this->db->select('a.id, title,content,classid,classname,url,`order`,addtime,updatetime');
		$this->db->where($where);
		$this->db->from($this->table.' as a');
		$this->db->join($this->table."_class as b", 'a.classid = b.id');
		if($order)$this->db->order_by($order);
		if($num!=0&&$offset!=0){
			$this->db->limit($num, $offset);
		}else{
			$this->db->limit($num);
		}
		$query = $this->db->get();
		
		
		$result = $query->result_array();  //结果集
		if(isset($result)){
			    return $result;    //返回信息分类数组
		}else{
				return 0;
		}
	}
	
	/**
	 * 
	 * 获取单条信息内容
	 * @param int $id
	 */
	public function get_info_items($id){
		
		$query = $this->db->get_where($this->table,array('id'=>$id));
		$result = $query->row_array();  //结果集
		if(isset($result)){
				$result['classname'] = $this->get_info_class($result['classid']);
				$result['classname'] = $result['classname']['classname'];
			    return $result;    //返回信息分类数组
		}else{
				return 0;
		}
		
	}
	/**
	 * 
	 * 获取信息分类数据
	 * @param int $classid
	 */
	public function get_info_class($classid){
		
		$this->db->where('id',$classid);
		$query = $this->db->get($this->table."_class");
		$result = $query->row_array();  //结果集
		if(isset($result)){
			    return $result;    //返回数组
		}else{
				return 0;
		}
		
	}
	
	/**
	 * 
	 * 添加信息
	 * @param array $items   需要添加的选项
	 */
	public function save_info(Array $items){
		return $this->db->insert($this->table,$items);
	}
	
	/**
	 * 
	 * 更新信息
	 * @param array $items   需要添加的选项
	 */
	public function update_info($id,Array $items){
		$this->db->where('id', $id);
		return $this->db->update($this->table,$items);
	}
	
	public function del_info($id){
		return $this->db->delete($this->table, array('id' => $id)); 
	}
	
	
	
	
	
	
	
	

}  //end class





