<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
 * TAYGOD Company Manage System
 *
 * 基于Codeigniter的企业网站管理系统
 * 
 * TAYGOD is an open source multi-privilege Company Manage System built on the 
 * well-known PHP framework Codeigniter.
 *
 * @package		TAYGOD
 * @author		T.l <madma@163.com>
 * @copyright	Copyright (c) 2012 , taygod.com.
 * @license		GNU General Public License 2.0
 * @link		http://taygod.com/
 * @version		1.0.0
 */
 
// ------------------------------------------------------------------------

/**
 * TAYGOD Category Class
 *
 * 新闻操作Model
 *
 * @package		TAYGOD
 * @subpackage	Models
 * @category	Models
 * @author		T.l <madma@163.com>
 * @link		http://taygod.com/
 */

class Model_news extends Lin_Model {
	
	function __construct(){
		parent::__construct();
		// Load the associated table
        $this->load_table('news');
	}
	 
	
	
	/**
	 * 获取全部新闻分类
	 */
	function get_all_news_class(){
		
		$this->load_table('news_class');
		$result = $this->find_all('','','`order` asc');
		
		if(isset($result)){
			    return $result;    //返回信息分类数组
		}else{
				return 0;
		}
	}

	
	
	
	function get_all_news_rows($conditions = NULL, $fields = '*', $order = NULL, $start = 0, $limit = NULL){
		
		$result =  $this->find_all($conditions,$fields,$order,$start,$limit);
		if(isset($result)){
			foreach ($result as $key => $value) {
				$result[$key]['classname'] = $this->get_info_class($value['classid']);
				//生成图片地址
				$result[$key]['pic'] = setting('upload_path').$value['showpic'];
			}
			$this->load_table('news');
			return $result;    //返回信息分类数组
		}else{
				return;
		}
		
		//重新设置数据表
		
	}
	
	
	/**
	 * 获取单条信息
	 */
	function get_info_items($id){
		
		$result = $this->get_all_news_rows("`id`=$id",'*',NULL,0,1);
		
		if(isset($result))
		{
			$result = $result[0];
			$result['classname'] = $this->get_info_class($result['classid']);
			return $result;
		}
		else
		{
			return ;
		}
		
	}
	
	/**
	 * 
	 * 获取分类数据
	 * @param int $classid
	 */
	public function get_info_class($classid){
		
		$this->load_table('tclass');
		$result = $this->field("classid = '$classid' and tbname='news' ",'classname');
		$this->load_table('news');
		if(isset($result)){
			    return $result;    //返回数组
		}else{
				return 0;
		}
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

}  //end class




/* End of file model_news.php */
/* Location: ./core/app/models/model_news.php */
