<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
 * TAYGOD Company Manage System
 *
 * 基于Codeigniter的企业网站管理系统
 * 
 * TAYGOD is an open source multi-privilege Company Manage System built on the 
 * well-known PHP framework Codeigniter.
 *
 * @package		TAYGOD
 * @author		T.l <madma@163.com>
 * @copyright	Copyright (c) 2012 , taygod.com.
 * @license		GNU General Public License 2.0
 * @link		http://taygod.com/
 * @version		1.2.0
 */
 
// ------------------------------------------------------------------------

/**
 * TAYGOD Category Class
 *
 *  分类操作类
 *
 * @package		TAYGOD
 * @subpackage	Models
 * @category	Models
 * @author		T.l <madma@163.com>
 * @link		http://taygod.com/
 */

class Model_tclass extends Lin_Model {
	
	function __construct(){
		parent::__construct();
		// Load the associated table
        $this->load_table('tclass');
        $this->table = 'tclass' ;
        $this->primaryKey = 'classid';
	}


    //获取所有分类
    function get_all_class($tbname = ''){
        if($tbname)
        {
            return $this->find_all("tbname = '$tbname'");
        }
        else
        {
            return $this->find_all();
        }

    }

    //获取根分类
    function get_root_class($tbname = ''){
        if($tbname)
        {
            return $this->find_all("bclassid = 0 and tbname = '$tbname'");
        }
        else
        {
            return $this->find_all('bclassid = 0');
        }

    }

    //更新父栏目的sonclass列
    function update_sonclass($classid){
        //更新sonclass
        $sonclassid = $this->get_insert_ID().'|';
        $sql ="UPDATE ".$this->db->dbprefix($this->_table)." SET sonclass = concat(sonclass,'$sonclassid') WHERE classid = $classid";
        $this->query($sql);

    }

    /*
     * 获取子分类
     * 返回数组
     * $sonclass 子类字符串
     */
    function get_son_class($sonclass,$tbname=''){

        $son_id = str_replace('|',',',$sonclass);
        $where = "classid in (".substr($son_id,1,strlen($son_id)-2).")";
        if ($tbname)
        {
            $where .= " and tbname = '".$tbname."' ";
        }

        $son_arr = $this->find_all($where);

        return $son_arr;

    }





    /**
     * 删除分类后处理父分类sonclass
     */
    function del_sonclass($id){
        $row = $this->read($id);
        if($row['bclassid'] == 0 && $row['sonclass'] != "|" )
        {
            return -1;  //有子分类
        }
        elseif($row['bclassid'] == 0 && $row['sonclass'] == "|" )
        {
            return 1; //可以删除
        }
        elseif($row['bclassid'] > 0)
        {
            //更新父分类sonclass
            $sql ="UPDATE ".$this->db->dbprefix($this->_table)." SET sonclass = replace(sonclass,'$id|','') WHERE classid = ".$row['bclassid']."";
            $this->query($sql);
            return 1; //可以删除
        }

    }


    /**
     * 判断是否有二级分类
     */
    function check_sonclass($classid){



    }































	 
	

	

}  //end class




/* End of file model_tclass.php */
/* Location: ./source/app/models/model_tclass.php */
