<?php
class AdminPrivilege {
	private $rbac = NULL;	
	private $table_u = '';
	private $table_g = '';
	private $table_gd = '';
	private $table_r = '';
	private $table_rd = '';
	private $table_p = '';	
	public function __construct() {	
		$rbac_user = $rbac_group = $rbac_group_desc = $rbac_role = $rbac_role_desc = $rbac_privilege = '';
		extract(_getTableConf(), EXTR_OVERWRITE);
		$this->table_u = $rbac_user;		
		$this->table_g = $rbac_group;
		$this->table_gd = $rbac_group_desc;
		$this->table_r = $rbac_role;
		$this->table_rd = $rbac_role_desc;
		$this->table_p = $rbac_privilege;
		$this->rbac = new Rbac($this->table_u,$this->table_g,$this->table_gd,$this->table_r,$this->table_rd,$this->table_p,'',_getDbConf());
	}
	/**
	 * 添加权限项
	 * @param string $name
	 * @param string $resource
	 */
	public function addPrivilege($name,$resource,$sys=0) {
		return $this->rbac->addPrivilege($name, $resource, $sys);
	}	
	/**
	 * 添加角色
	 * @param string $name
	 */
	public function addRole($name,$sys=0) {
		return $this->rbac->addRole($name, $sys);
	}	
	/**
	 * 添加用户组
	 * @param string $name
	 */
	public function addGroup($name,$sys=0) {
		return $this->rbac->addGroup($name, $sys);
	}	
	/**
	 * 为用户组增加用户
	 * @param int $user
	 * @param int $group
	 */
	public function addUser($user,$group) {
		return $this->rbac->addUser($user,$group);
	}	
	/**
	 * 返回用户组列表
	 */
	public function getGroups() {
		return $this->rbac->getGroups();
	}	
	/**
	 * 返回用户对应的用户组列表
	 * @param int $user
	 */
	public function getGroupsByUser($user) {
		return $this->rbac->getGroupsByUser($user);
	}	
	/**
	 * 返回权限项列表
	 */
	public function getPrivilege() {
		return $this->rbac->getPrivilege();
	}	
	/**
	 * 返回角色列表
	 */
	public function getRoles() {
		return $this->rbac->getRoles();
	}	
	/**
	 * 返回用户组对应的角色列表
	 * @param mixed $group
	 */
	public function getRolesByGroup($group) {
		return $this->rbac->getRolesByGroup($group);
	}	
	/**
	 * 为用户组添加角色
	 * @param int $group
	 * @param int $role
	 */
	public function addGroupRole($group,$role) {
		return $this->rbac->addGroupRole($group,$role);
	}	
	/**
	 * 检查某用户是否在某用户组
	 * @param int $user
	 * @param int $group
	 */
	public function checkUserInGroup($user,$group) {
		return $this->rbac->checkUserInGroup($user,$group);
	}	
	/**
	 * 检查用户组是否属于某角色
	 * @param int $group
	 * @param int $role
	 */
	public function checkGroupInRole($group,$role) {
		return $this->rbac->checkGroupInRole($group,$role);
	}	
	/**
	 * 返回角色的权限列表
	 * @param unknownint_type $role
	 */
	public function getPrivilegeByRole($role) {
		return $this->rbac->getPrivilegeByRole($role);
	}
	/**
	 * 检查某角色是否拥有某权限
	 * @param int $role
	 * @param int $privilege
	 */
	public function checkRoleInPrivilege($role,$privilege) {
		return $this->rbac->checkRoleInPrivilege($role,$privilege);
	}	
	/**
	 * 为某角色添加权限
	 * @param int $role
	 * @param int $privilege
	 */
	public function addPermission($role,$privilege) {
		return $this->rbac->addPermission($role,$privilege);
	}	
	/**
	 * 删除权限项
	 * @param int $privilege
	 */
	public function removePrivilege($privilege) {
		return $this->rbac->removePrivilege($privilege);
	}	
	/**
	 * 删除用户组
	 * @param int $group
	 */
	public function removeGroup($group) {
		return $this->rbac->removeGroup($group);
	}	
	/**
	 * 删除角色
	 * @param int $role
	 */
	public function removeRole($role) {
		return $this->rbac->removeRole($role);
	}	
	/**
	 * 删除角色拥有的权限
	 * @param int $role
	 * @param int $privilege
	 */
	public function removePrivilegeForRole($role,$privilege=0) {
		return $this->rbac->removePrivilegeForRole($role,$privilege);
	}	
	/**
	 * 删除用户组属于某角色的身份
	 * @param int $group
	 * @param int $role
	 */
	public function removeRoleForGroup($group,$role=0) {
		return $this->rbac->removeRoleForGroup($group,$role);
	}	
	/**
	 * 从用户组中删除用户
	 * @param int $user
	 * @param int $group
	 */
	public function removeUserFromGroup($user,$group) {
		return $this->rbac->removeUserFromGroup($user,$group);
	}	
	/**
	 * 修改用户组
	 * @param string $name
	 * @param int $group
	 */
	public function editGroup($name,$group) {
		return $this->rbac->editGroup($name,$group);
	}	
	/**
	 * 修改权限项
	 * @param string $name
	 * @param string $resource
	 * @param int $privilege
	 */
	public function editPrivilege($name,$resource,$privilege) {
		return $this->rbac->editPrivilege($name,$resource,$privilege);
	}	
	/**
	 * 修改角色
	 * @param string $name
	 * @param int $role
	 */
	public function editRole($name,$role) {
		return $this->rbac->editRole($name,$role);
	}	
	/**
	 * 获取用户组的所有用户
	 * @param mixed $group
	 */
	public function getUsersByGroup($user) {	
		return $this->rbac->getUsersByGroup($user);
	}
	
	
	
	
	
	
	
	
	
	/**
	 * 检查用户的权限
	 * @param string $resource
	 */
	public function hasPermission($user_id,$resource='') {
		if (empty($user_id)) {
			return FALSE;
		}
		$this->rbac->User = $user_id;		
		return $this->rbac->hasPermission($resource);
	}
	/**
	 * 返回用户(管理员)列表
	 */
	public function getUsers() {
		global $GEEORM;
		$where = $table = $id_field = $name_field = '';
		$user_table = _getTableConf();
		extract($user_table['rbac_admin'], EXTR_OVERWRITE);
		if($where=="") {
			$where = 1;
		}
		$users = $GEEORM->from($table)->fields(array($id_field,$name_field))->where($where)->getMeta();
		return $users;		
	}	
	/**
	 * 获取所有系统权限关联
	 */
	public function getSysPrivilege() {
		global $GEEORM;
		$orm = $GEEORM;
		$c1 = "resource LIKE '%-nav' AND sys=1";
		$items = $orm->from($this->table_p)->where($c1)->getMeta();
		if($items){			
			 foreach ($items as $k=>$v) {
			 	$flag = substr($v['resource'], 0, strlen($v['resource'])-4);
			 	$c2 = "resource LIKE '".$flag."%' AND privilege_id<>".$v['privilege_id'];
			 	$rs2 = $orm->where($c2)->getMeta();
			 	$items[$k]['subitem'] = $rs2;
			}			
		}
		$orm = NULL;
		return $items;		
	}	
	/**
	 * 根据权限id串获取相关用户组的id数组
	 * @param string $ids 权限id串,id之间用逗号分割
	 * @return array
	 */
	public function getSysGroupsIdByPriIds($ids) {
		if(empty($ids)) return FALSE;
		global $GEEORM;
		$_from   = $this->table_p.' AS p,'.$this->table_r.' AS r,'.$this->table_g.' AS g';
		$_fields = 'DISTINCT g.group_id';
		$_where  = 'p.privilege_id=r.privilege_id AND r.role_id=g.role_id AND p.privilege_id IN('.Geeleaf_func_m_escape($ids).')';
		$_data   = $GEEORM->from($_from)->fields($_fields)->where($_where)->getMeta(MYSQL_NUM);
		foreach ($_data as $k => $v) {
			$_data[$k] = $v[0];
		}
		return $_data;
	}
	/**
	 * 获取所有系统权限id数组
	 */
	public function getSysPirIds() {
		global $GEEORM;
		$_data = $GEEORM->from( $this->table_p)->fields('privilege_id')->where('sys=1')->getMeta(MYSQL_NUM);
		foreach ($_data as $k => $v) {
			$_data[$k] = $v[0];
		}
		return $_data;
	}	
	/**
	 * 根据管理员id清空用户-用户组关系表
	 * @param int $id 管理员id
	 * @return boolean
	 */
	public function clearPriByAdminId($id) {
		global $GEEORM;
		$_ok = FALSE;
		$groupids = $this->getSysGroupsIdByPriIds(@implode(',', $this->getSysPirIds()));
		$groupids = @implode(',', $groupids);
		if(!empty($groupids)) {
			$c = $this->table_u.'.group_id IN('.$groupids.') AND '.$this->table_u.'.user_id='.Geeleaf_func_m_escape($id);
			$_ok = (bool)$GEEORM->from($this->table_u)->where($c)->delete();
		}
		return $_ok;
	}
	/**
	 * 批量添加用户-用户表关系数据
	 * @param int $userid 管理员id
	 * @param array $groupsidarr 用户组id数组
	 * @return boolean
	 */
	public function batchAddUserGroups($userid, $groupsidarr=array()) {
		if (empty($userid) || empty($groupsidarr)) {
			return FALSE;
		}
		global $GEEORM;
		$values = '';
		foreach ($groupsidarr as $v) {
			$values .= '('.$userid.','.$v.'),';
		}
		$values = substr($values, 0, strlen($values)-1);
		$sql = 'INSERT INTO '.$this->table_u.' VALUES '.$values;
		return (bool)$GEEORM->exec($sql);		
	}
	/**
	 * 改变管理员的系统权限
	 * @param int $adminid 管理员id
	 * @param array $priids 权限id数组
	 * @return boolean
	 */
	public function changeSysPriForAdmin($adminid,$priids=array()) {
		if (empty($adminid)) {
			return FALSE;
		}
		//首先清空指定管理员的所有权限
		$this->clearPriByAdminId($adminid);
		//根据权限id获取对应的用户组
		$groups = $this->getSysGroupsIdByPriIds(@implode(',', $priids));
		//批量添加用户-用户表关系数据
		$this->batchAddUserGroups($adminid, $groups);
		return TRUE;
	}
	
}