<?php

error_reporting(0);

require dirname(dirname(dirname(__FILE__))).'/system/configs/System.Constant.php';
require GEELEAF_LIB . 'GeeLeaf.class.php';
spl_autoload_register(array('GeeLeaf','loadLib'));
is_file(GEELEAF_LIB.'Geeleaf.function.php') && require GEELEAF_LIB.'Geeleaf.function.php';
require dirname(dirname(dirname(__FILE__))).'/global/functions.php';
_gotoInstall();
require dirname(dirname(dirname(__FILE__))).'/global/variables.php';
_setTimeZone();

if (get_magic_quotes_gpc() || get_magic_quotes_runtime()) {	
	@set_magic_quotes_runtime(0);
}
@extract(Client::getInstance()->post(),EXTR_OVERWRITE);
@extract(Client::getInstance()->get(),EXTR_OVERWRITE);

function _printModuleView($tfile,$vars=array()){
	$temPlate = new TemplateOne();
	$temPlate->setTemplate('tpl/'.$tfile.'.php');
	if(is_array($vars) && count($vars)>0) {
		$temPlate->assign($vars);
	}
	$temPlate->render();
}

function _login($name,$pw,$vcode) {
	if (Session::getInstance()->get('AdminId')) {
		return TRUE;
	}
	global $GEEORM;
	$c1 = _checkAdmin($name,$pw);	
	$c2 = $vcode==Session::getInstance()->get('Vcode');
	if ((bool)$c1 && $c2) {		
		$admintable = _getTableConf();
		_opDb($GEEORM, array(
			'_table' => $admintable['admin'],
			'_where' => 'id='.$c1['id'],
			'lasttime' => time(),
			'lastip' => Geeleaf_func_ip(),		
		), 'update');	
		Session::getInstance()->set('AdminId',$c1['id']);
		Session::getInstance()->set('AdminName',$c1['name']);
		Session::getInstance()->set('LastLoginIp',$c1['lastip']);
		Session::getInstance()->set('LastLoginTime',$c1['lasttime']);
		Session::getInstance()->set('IsSuper',$c1['super']);
		Session::getInstance()->delete('LoginFailedInfo');
		return TRUE;
	}else{
		$lfinfo = array();
		$hasempty = false;
		if (trim($name)=='') {
			$lfinfo['n'] = '还没有填写管理帐号';
			$hasempty = true;
		}
		if (trim($pw)=='') {
			$lfinfo['p'] = '还没有填写管理密码';
			$hasempty = true;
		}
		if (trim($vcode)=='' && $hasempty==false) {
			$lfinfo['v'] = '还没有填写验证码';
			$hasempty = true;
		}
		if(!$c1 && !$hasempty){			
			$lfinfo['np'] = '管理帐号和密码不匹配';
		}
		if (!$c2 && !$hasempty) {
			$lfinfo['wv'] = '验证码错误';
		}
		Session::getInstance()->set('LoginFailedInfo', $lfinfo);	
		return FALSE;
	}	
}

function _loginTo($name,$pw,$vcode,$successpage='',$failepage='') {
	if (_login($name,$pw,$vcode)) {
		if (!empty($successpage)) {
			Geeleaf_func_redirect($successpage);
		}		
	}else{	
		if (empty($failepage)) {
			if($_SERVER['HTTP_REFERER']){
				$failepage = $_SERVER['HTTP_REFERER'];
				
			}
		}	
		Geeleaf_func_redirect($failepage);
		return FALSE;
	}
}

function _logout() {
	Session::getInstance()->delete('AdminId');
	Session::getInstance()->delete('AdminName');
	Session::getInstance()->delete('IsSuper');
	goLoginIndex();
}

//跳转到登录页面
function goLoginIndex() {
	if(!Session::getInstance()->get('AdminName')) {
		Geeleaf_func_redirect('../');
	}
}

function _checkAdmin($name,$pw) {
	global $GEEORM;
	$name	= Geeleaf_func_m_escape($name);
	$pw		= Geeleaf_func_crypt($pw, _getSalt(), true);
	$admintable = _getTableConf();
	$_admin = $GEEORM->from($admintable['admin'])->where("name='".Geeleaf_func_m_escape($name)."' AND password='".Geeleaf_func_m_escape($pw)."'")->getMetaOne();
	$arr = array();
	$arr['super'] = FALSE;
	if (isset($_admin['super'])) {
		$arr['id']    = $_admin['id'];
		$arr['name']    = $_admin['name'];
		$arr['lasttime'] = !empty($_admin['lasttime']) ? $_admin['lasttime'] : time();
		$arr['lastip'] =  !empty($_admin['lastip']) ? $_admin['lastip'] : Geeleaf_func_ip();
		$arr['super'] = (bool)$_admin['super'];
		return $arr;
	}else{
		return FALSE;
	}
}

function _isSuperAdmin() {
	return Session::getInstance()->get('IsSuper');
}

function _checkPrivilege($userId,$resource) {
	require_once '../_base/adminprivilege.class.php';
	$has_p = false;
	$p = new AdminPrivilege();
	if (_isSuperAdmin()) { 
		$has_p = true;
	}else{
		$has_p = $p->hasPermission($userId,$resource);
	}
	return $has_p;
}

function _checkWebPermission($index='') {
	if (isset($_SERVER['SCRIPT_NAME'])) {
		$p     = basename(dirname($_SERVER['SCRIPT_NAME']));
		$index = basename($_SERVER['SCRIPT_NAME'],'.php');		
	}else{
		$p = basename(getcwd());
	}
	$id = Session::getInstance()->get('AdminId');
	$pri = 'GEELEAFSYSTEM-'.$p.'-'.$index;	
	if (!_checkPrivilege($id, $pri)) {
		exit('You have no permission');
	}
}

function _changeAdminPw($name,$oldPw,$newPw) {
	global $GEEORM;
	$oldPw = Geeleaf_func_crypt($oldPw, _getSalt(), true);
	$newPw = Geeleaf_func_crypt($newPw, _getSalt(), true);
	$admintable = _getTableConf();
	$GEEORM->from($admintable['admin']);
	$c = "name='".Geeleaf_func_m_escape($name)."' AND password='".$oldPw."'";
	if($GEEORM->where($c)->count()==0) {
		return false;
	}
	$GEEORM->password = $newPw;
	$GEEORM->where($c)->update();
	return true;
}

function _getLocalModules() {
	$dir = dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR;	
	$dirs = scandir($dir);
	$_modules = array();
	foreach ($dirs as $k => $v) {
		$tmp = $dir.$v;
		if(is_dir($tmp) && $v!='.' && $v!='..' && $v!='_base') {
			$tconfdir = $tmp.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR;
			$tinfo = $tconfdir.'info.php';
			$tsql = $tconfdir.'sql.sql';
			$tpri = $tconfdir.'privilege.php';
			$tablef = $tconfdir.'table.php';
			
			//管理模块文件夹必须包含config/privilege.php文件
			if (is_readable($tpri)) {
				$temp = require $tpri;
				if (isset($temp['ITEM_TITLE']) && is_array($temp['ITEM_TITLE']) && !empty($temp['ITEM_TITLE'])) {
					$_modules[$v]['privilege'] = $temp;
					//读取SQL文件(如果有的话)
					if (is_readable($tsql)) {
						$_modules[$v]['sql'] = file($tsql);
					}
					//模块所关联的数据表
					if (is_readable($tablef)) {
						$tarr = include $tablef;
						if(is_array($tarr)) {
							foreach ($tarr as $tk => $tv) {
								$tarr[$tk] = _getTablePrefix().$tv;
							}
							$_modules[$v]['tables'] = $tarr;
						}
					}
					//模块信息
					if(is_readable($tinfo)){
						$_modules[$v]['info'] = @include $tinfo;
						if (!isset($_modules[$v]['info']['name'])) {
							$_modules[$v]['info'] = array(
								'name' => $v,
								'author' => 'unknown',
								'version' => 'unknown',
								'date' => 'unknown',
								'description' => 'unknown'
							);
						}
					}else{
						$_modules[$v]['info'] = array(
							'name' => $v,
							'author' => 'unknown',
							'version' => 'unknown',
							'date' => 'unknown',
							'description' => 'unknown'
						);
					}
				}				
			}
		}
	}
	return $_modules;
}
//获取已安装的管理模块(后台管理菜单)
function _getInstalledModules() {
	global $GEEORM;
	$mctable = _getTableConf();
	$menulist = array();
	$rs = $GEEORM->from($mctable['menuconf'])->getMetaOne(MYSQL_ASSOC, FALSE);
	if(isset($rs['menu'])){
		$m = unserialize($rs['menu']);
		if(is_array($m)){
			$menulist = $m;
		}		
	}
	return $menulist;
}
//获取尚未安装的管理模块
function _getUninstalledModules() {
	return array_diff_key(_getLocalModules(), _getInstalledModules());
}

//安装管理模块权限
function __installPrivilege($flag, $priarr=array(), $orm=NULL) {
	if(!is_array($priarr) || empty($priarr)) {
		return FALSE;
	}
	//设权限数 N，则角色数 N，用户组数 N
	$_ok    = FALSE;
	$rs     = $priarr;
	$tables = _getTableConf();	
	$t_p    = $tables['rbac_privilege'];  //权限表
	$t_r    = $tables['rbac_role_desc'];  //角色表
	$t_g    = $tables['rbac_group_desc']; //用户组表
	$t_rp   = $tables['rbac_role'];       //角色-权限表
	$t_gr   = $tables['rbac_group'];      //用户组-角色表
	$p_insertIds = array();
	$r_insertIds = array();
	$g_insertIds = array();	
	foreach ($rs as $k=>$v) {		
		
		//添加权限项数据
		$_ok = _opDb($orm, array(
			'_table'   => $t_p,
			'name'     => $v['name'],
			'resource' => sprintf($rs[$k]['resource'],$flag),
			'sys'      => 1
		));
		if(!$_ok) break;
		$p_insertIds[] = $orm->getInsertId();
		//添加用户组数组		
		$_ok = _opDb($orm, array(
			'_table'   => $t_g,
			'name'     => $v['name']."(group)",
			'sys'      => 1
		));
		if(!$_ok) break;
		$g_insertIds[] = $orm->getInsertId();		
		//添加角色数据
		$_ok = _opDb($orm, array(
			'_table'   => $t_r,
			'name'     => $v['name']."(role)",
			'sys'      => 1
		));
		if(!$_ok) break;
		$r_insertIds[] = $orm->getInsertId();
	}
	if(!$_ok) return FALSE;
	//角色-权限和用户组-角色的对应关系
	$role_pri_arr = $group_role_arr = array();
	for ($i = 0; $i < count($p_insertIds); $i++) {
		$role_pri_arr[]   = array($r_insertIds[$i], $p_insertIds[$i]);
		$group_role_arr[] = array($g_insertIds[$i], $r_insertIds[$i]);
	}
	//添加角色-权限的对应关系
	foreach($role_pri_arr as $v) {
		$_ok = _opDb($orm, array(
			'_table'       => $t_rp,
			'role_id'      => $v[0],
			'privilege_id' => $v[1]
		));
		if(!$_ok) break;
	}
	if(!$_ok) return FALSE;
	//添加用户组-角色的对应关系
	foreach($group_role_arr as $v) {
		$_ok = _opDb($orm, array(
			'_table'   => $t_gr,
			'group_id' => $v[0],
			'role_id'  => $v[1]
		));
		if(!$_ok) break;
	}
	return $_ok;
}
//卸载管理模块权限
function __uninstallPrivilege($flag) {
	global $GEEORM;
	$_kw = 'GEELEAFSYSTEM-'.$flag.'-';
	$tables = _getTableConf();	
	$t_p    = $tables['rbac_privilege'];  //权限表
	$t_r    = $tables['rbac_role_desc'];  //角色表
	$t_g    = $tables['rbac_group_desc']; //用户组表
	$t_rp   = $tables['rbac_role'];       //角色-权限表
	$t_gr   = $tables['rbac_group'];      //用户组-角色表
	$t_u	= $tables['rbac_user']; 	  //用户-用户组表
		
	$orm = $GEEORM;	
	//获取权限项id
	$c = "resource LIKE 'GEELEAFSYSTEM-".$flag."-%' AND sys=1";
	$priids  = $orm->from($t_p)->fields('privilege_id')->where($c)->getMeta();
	foreach ($priids as $k => $v) {
		$priids[$k] = $v['privilege_id'];
	}
	$priids = implode(',', $priids);
	//获取角色id
	if(!empty($priids)) {
		$c = 'privilege_id IN ('.$priids.')';
		$roleids = $orm->from($t_rp)->fields('distinct role_id')->where($c)->getMeta();
		foreach ($roleids as $k => $v) {
			$roleids[$k] = $v['role_id'];
		}
		$roleids = implode(',', $roleids);
	}else{
		return FALSE;
	}	
	//获取用户组id
	if(!empty($roleids)) {
		$c = 'role_id IN ('.$roleids.')';
		$groupids = $orm->from($t_gr)->fields('distinct group_id')->where($c)->getMeta();
		foreach ($groupids as $k => $v) {
			$groupids[$k] = $v['group_id'];
		}
		$groupids = implode(',', $groupids);
	}else{
		return FALSE;
	}

	if(empty($groupids)) return FALSE;
	
	$c = 'role_id IN ('.$roleids.')';
	$orm->from($t_rp)->where($c)->delete();
	$c = 'group_id IN ('.$groupids.')';
	$orm->from($t_gr)->where($c)->delete();
	$c = 'group_id IN ('.$groupids.')';
	$orm->from($t_u)->where($c)->delete();
	$c = 'privilege_id IN ('.$priids.')';
	$orm->from($t_p)->where($c)->delete();
	$c = 'role_id IN ('.$roleids.')';
	$orm->from($t_r)->where($c)->delete();
	$c = 'group_id IN ('.$groupids.')';
	$orm->from($t_g)->where($c)->delete();
	
	return TRUE;
}


/**
 * 安装管理模块
 * @param string $flag 模块标识(文件夹名)
 * @return boolean
 */
function _installModule($flag) {
	global $GEEORM;
	$_uninstalled = _getUninstalledModules();
	$_installed = array();
	$_tmp = array();
	$_ok = FALSE;
	$_orm = NULL;
	$_configarr = array();
	foreach ($_uninstalled as $k => $v) {
		if($k == $flag) {
			$_tmp = $v;
			break;
		}
	}	
	if(!empty($_tmp)) {		
		$_configarr = _getDbConf();
		$_orm = $GEEORM;
		if(isset($_tmp['sql']) && $_tmp['sql']) {			
			$tprefix = _getTablePrefix();
			$datas = $_tmp['sql'];
			if(is_array($datas)) {
				$a = array(
					'CREATE TABLE IF NOT EXISTS `',
					'INSERT INTO `',
					'UPDATE `',
					'DELETE FROM `',
					'DROP TABLE IF EXISTS `'
				);
				$b = array(
					'CREATE TABLE IF NOT EXISTS `'.$tprefix,
					'INSERT INTO `'.$tprefix,
					'UPDATE `'.$tprefix,
					'DELETE FROM `'.$tprefix,
					'DROP TABLE IF EXISTS `'.$tprefix
				);
				foreach ($datas as $_i => $v) {
					$datas[$_i] = str_replace($a, $b, $v);
				}
			}
			$dbackup = new DataBackup($_orm);
			$_ok = $dbackup->__insert($datas);
			unset($_tmp['sql']);
		}else{
			$_ok = TRUE;
		}
		if(isset($_tmp['privilege']) && is_array($_tmp['privilege']) && !empty($_tmp['privilege'])) {
			$_ok = __installPrivilege($flag, $_tmp['privilege'], $_orm);
		}else{
			$_ok = TRUE;
		}	
		$_ok = true;
		if($_ok) {
			foreach ($_tmp['privilege'] as $k => $v) {				
				$_tmp['privilege'][$k]['resource'] = sprintf($v['resource'],$flag);
				if(isset($v['link'])) {
					$_tmp['privilege'][$k]['link'] = sprintf($v['link'],$flag);
				}
			}			
			$_installed = _getInstalledModules();
			$_installed[$flag] = $_tmp;
			$mctable = _getTableConf();			
			$_count = $_orm->from($mctable['menuconf'])->count();
			if($_count==0) {
				$_ok = _opDb($_orm, array(
					'_table' => $mctable['menuconf'],
					'menu' => serialize($_installed)
				), 'insert');
			}else{
				$_ok = _opDb($_orm, array(
					'_table' => $mctable['menuconf'],
					'menu' => serialize($_installed)
				), 'update');
			}
		}
	}
	$_uninstalled = $_installed = $_tmp = $_orm = $_configarr = NULL;
	return (bool)$_ok;
}

/**
 * 卸载管理模块
 * @param array $flagarr 模块标识数组[array('news','product')]
 * @return boolean
 */
function _uninstallModule($flagarr=array(),$droptables=false) {
	global $GEEORM;
	if(!is_array($flagarr) || empty($flagarr)) {
		return FALSE;
	}
	$_installed = _getInstalledModules();
	$_orm = $GEEORM;
	$mctable = _getTableConf();
	$datao = new DataBackup($GEEORM);
	foreach ($flagarr as $k => $v) {
		if(__uninstallPrivilege($v)){
			//删除主题相关数据表
			if(!@empty($_installed[$v]['tables']) && $droptables) {
				foreach ($_installed[$v]['tables'] as $_t) {
					$droptarr[] = 'DROP TABLE IF EXISTS `'.$_t.'`';					
				}
				$datao->__insert($droptarr);
			}
			unset($_installed[$v]);
		}
	}
	$_ok = _opDb($_orm, array(
				'_table' => $mctable['menuconf'],
				'menu' => serialize($_installed)
			), 'update');
	$_installed = $_orm = $mctable = NULL;
	return (bool)$_ok;
}

function _uninstallExceptModules() {
	$flags = array_keys(array_diff_key(_getInstalledModules(), _getLocalModules()));
	return _uninstallModule($flags);
}

function _makePriFlag($index='nav',$type='resource') {	
	$s = '';
	if ($type=='resource') {
		$s = 'GEELEAFSYSTEM-%s-'.$index;
	}else{
		$s = '../%s/'.$index.'.php';
	}
	return $s;
}

/**
 * 添加多语言数据
 * @param GeeleafORM $orm
 * @param string $t1 主表名
 * @param string $t2 附表名
 * @param array $arr 主表的数据数组
 * @param array $arr2 附表的数据数组
 * @param string $idfield 附表id字段名
 */
function _opDbInsRelate($orm,$t1,$t2,$arr,$arr2,$idfield) {
		$arr['_table'] = $t1;
		$insertid = _opDb($orm,$arr,'insert',true);
		$keys = array_keys($arr2);
		if(!(bool)$insertid || empty($keys)) {
			return FALSE;
		}
		$arr2['_table'] = array_fill(0, count($arr2[$keys[0]]), $t2);			
		$arr2[$idfield] = array_fill(0, count($arr2[$keys[0]]), $insertid); 
		$changed = array();
		foreach($arr2[$keys[0]] as $k => $v) {
			$t = array();
			foreach($arr2 as $i => $j) {
				$t[$i] = @$arr2[$i][$k];
			}
			$changed[] = $t;
		}
		foreach ($changed as $v) {
			if(!_opDb($orm, $v, 'insert')) {
				return FALSE;
			}
		}
		return $insertid;
}

/**
 * 修改多语言数据
 * @param GeeleafORM $orm
 * @param int $id 主表id值
 * @param string $t1 主表名
 * @param string $t2 附表名
 * @param array $arr1 主表的数据数组
 * @param array $arr2 附表的数据数组
 * @param string $t2idfield 附表id字段名
 * @param int $pid 父id
 * @param array $ids
 */
function _opDbUpdateRelate($orm,$id,$t1,$t2,$arr1,$arr2,$t2idfield,$pid='',$ids=array(),$t1idfield='') {
	if($pid!=='') {
		if ($id==$pid) {
			return FALSE;
		}
		if (is_array($ids)) {
			if(array_search($pid, $ids)!==FALSE) {
				return FALSE;
			}
		}		
	}	
	$arr1['_table'] = $t1;
	$t1idfield = !empty($t1idfield) ? $t1idfield : 'id';
	$arr1['_where'] = $t1idfield.'='.Geeleaf_func_m_escape($id);
	_opDb($orm, $arr1, 'update');	
	$keys = array_keys($arr2);
	for ($i = 1; $i <=count($arr2[$keys[0]]); $i++) {
		$arr2['_table'][] = $t2;
		$arr2['_where'][] = $t2idfield.'='.$id.' AND lang='.$i;			
	}	
	$changed = array();
	foreach($arr2[$keys[0]] as $k => $v) {
		$t = array();
		foreach($arr2 as $i => $j) {
			$t[$i] = @$arr2[$i][$k];
		}
		$changed[] = $t;
	}		
	foreach ($changed as $v) {
		_opDb($orm, $v, 'update');
	}
	return TRUE;
}

/**
 * 删除多语言数据
 * @param GeeleafORM $orm
 * @param int $id 主表id值
 * @param string $t1 主表名
 * @param string $t2 附表名
 * @param unknown_type $t2idfield 附表id字段名
 */
function _opDbDelRelate($orm,$id,$t1,$t2,$t2idfield) {
	$id = Geeleaf_func_m_escape($id);
	if($orm->from($t1)->where('id='.$id)->delete()) {
		return (bool)$orm->from($t2)->where($t2idfield.'='.$id)->delete();
	}
	return FALSE;
}

//列出树状栏目
function _listChannels($selid=0,$multiple=false,$root='') {
	global $GEEORM;
	$prefix = _getTablePrefix();
	$t1 = $prefix.'geechannels';
	$t2 = $prefix.'geechannels2';	
	$c = $t1.'.id='.$t2.'.channel_id AND '.$t2.'.lang=1';	
	$t = new InfinityTree($GEEORM->fields($t1.'.id,'.$t1.'.pid,'.$t2.'.name')->from($t1)->join($t2)->where($c)->getMeta());
	$cflag = !$multiple ? 'channel_id' : 'channel_id[]';
	return $t->select($cflag, $selid, $root, $multiple);
}

function _chkIfChannelRelated($channel_id,$resource_id) {
	global $GEEORM;
	$table = _getTablePrefix().'geechannelsrelate';
	if((bool)$GEEORM->from($table)->where('channel_id='.Geeleaf_func_m_escape($channel_id).' AND resource_id='.Geeleaf_func_m_escape($resource_id))->count()){
		return TRUE;
	}
	return FALSE;
}

function _addChannelRelate($channel_id,$resource_id) {
	global $GEEORM;
	return (bool)_opDb($GEEORM, array(
		'_table' => _getTablePrefix().'geechannelsrelate',
		'channel_id' => $channel_id,
		'resource_id' => $resource_id
	), 'insert');
}

function _delChannelRelate($channel_id,$resource_id) {
	global $GEEORM;
	return (bool)$GEEORM->from(_getTablePrefix().'geechannelsrelate')->where('channel_id='.Geeleaf_func_m_escape($channel_id).' AND resource_id='.Geeleaf_func_m_escape($resource_id))->delete();
}

function _recurTemplates($dir=GEECMS_THEMES) {
	if (!is_readable($dir)) {
		return array();
	}
	$d = dir($dir);
	static $arr = array();
	$arr2 = array();
	while (false !== ($entry=$d->read())) {
	   $t = $dir.$entry;
	   if(is_readable($t) && is_dir($t) && $entry!='.' && $entry!='..' && $entry!='_nocache' && $entry!='_logic' && $entry!='_api') {
	   		_recurTemplates($t.'/');	
	   }
	   $phpfile = pathinfo($t);
	   if(is_readable($t) && @$phpfile['extension']=='php') {
	   		//$arr[] = str_replace(GEECMS_THEMES._getTheme(), '', $t);
	   		$arr[] = str_replace($dir, '/', $t); 
	   }
	}
	$d->close();
	$arr2 = $arr;
	unset($arr);
	return $arr2;
}

function _listThemes($dir=GEECMS_THEMES) {
	$_themes = array();
	$_installedM = _getInstalledModules();
	foreach ($_installedM as $k => $v) {
		if(strpos($k, 'theme_')===0) {
			$_themes[] = substr($k,6);
		}
	}	
	$d = dir($dir);
	$arr = array();
	while (false !== ($entry=$d->read())) {
	   $t = $dir.$entry;
	   if(is_readable($t) && is_dir($t) && $entry!='.' && $entry!='..' && in_array($entry,$_themes)) {
	   		$arr[] = $entry;	
	   }
	}
	return $arr;
}

function _pageBg($sql, $page=1, $records=10, $appendparams='') {
	global $GEEORM;
	$rs = array();
	$pm = new PaginationMysqlExt($GEEORM);
	$pm->Page = $page;
	$pm->Records = $records;
	$pm->query($sql);
	$ps = new PaginationStyle();
	$ps->Page = $page;
	$ps->PageCount = $pm->getPageCount();
	$ps->RecordCount = $pm->getRecordCount();
	$ps->setLink('?page=%s'.$appendparams);
	$_pagebar = $ps->getTwo(10,true);
	if($ps->RecordCount <= $records) {
		$_pagebar = '';
	}
	$rs['data'] = $pm->get();
	$rs['pagebar'] = $_pagebar;
	$rs['pagecount'] = $ps->PageCount;
	$rs['recordcount'] = $ps->RecordCount;
	$rs['page'] = $page;
	return $rs;
}
