(function($){
	
	var nav = null; //<div id='navigate'>
	var _this = this; //方便其他函数内部引用当前函数对象
	var _tmpH = _timeout = _timeout2 = _timeout3 = 0;

	/*
	 * 获取元素style
	 */
	var _compS = function(obj,ie_style,ff_style) {
		var rs = obj.currentStyle ? obj.currentStyle[ie_style] : document.defaultView.getComputedStyle(obj,null).getPropertyValue(ff_style);
		rs = parseInt(rs);
		if(isNaN(rs)){
			rs = 0;
		};
		return rs;
	};
	
	/**
	 * 展开
	 * @param integer index 当前栏目在导航中的索引位置
	 * @param integer tmpHeight 变动(计算)的高度(一般为0)
	 * @param integer height 当前栏目的高度
	 * @return void
	 */
	_this.spread = function (index,tmpHeight,height,fn,subitem_index) {		
		tmpHeight += 3;
		if(tmpHeight < height){
			$('.item_list:first',$('dt',nav).get(index).parentNode).css({'height' : tmpHeight+'px'});
			_timeout = setTimeout('this.spread('+index+','+tmpHeight+','+height+','+fn+','+subitem_index+')',0);
		}else{
			clearTimeout(_timeout);			
			if(typeof fn=='function'){
				fn.call(null,subitem_index,_this.spreadCrumb); //$('dl',$('dt',nav).get(index).parentNode).get(0)
				fn = null;
			};
		};
	};

	/**
	 * 收缩
	 * @param integer index 当前栏目在导航中的索引位置
	 * @param integer height 变动(计算)的高度(一般为当前栏目的高度)
	 * @param integer offset 用来计算的偏移量
	 * @param integer speed 执行速度
	 * @param function fn (可选)完成后执行的函数
	 * @return void
	 */
	_this.striction = function (index,height,offset,speed,fn,subitem_index) {
		height -= offset;
		if(height > 0){
			$('.item_list:first',$('dt',nav).get(index).parentNode).css({'height' : height+'px'});
			_timeout2 = setTimeout('this.striction('+index+','+height+','+offset+','+speed+','+fn+','+subitem_index+')',speed);
		}else{
			$('.item_list:first',$('dt',nav).get(index).parentNode).css({'height' :'0px'});
			clearTimeout(_timeout2);
			if(typeof fn=='function'){				
				var offset = ($.browser().Name=='firefox') ? 8 : 5;
				fn.apply(_this.up.call(null,index,subitem_index,offset));
				fn = null;
			};			
		};
	};
	
	/**
	 * 向上移动
	 * @param integer index 当前栏目在导航中的索引位置
	 * @return void
	 */
	_this.up = function(index,subitem_index,offset){			
		$('.items').get(index).style.top = (_compS($('.items').get(index),'top','top')-offset)+'px';
		_timeout3 = setTimeout('this.up('+index+','+subitem_index+','+offset+')',0);
		/* 
		 * 判断是否上移到顶部位置
		 * 如果栏目上移到顶部位置,则
		 * 1.将栏目的top设为0(避免溢出左侧导航栏范围)
		 * 2.将栏目添加到第一个兄弟节点的前面
		 * 3.重置栏目内容高度(在收缩动作过程中会改变栏目内容原高度)
		 */
		if($('.items').get(index).offsetTop <= 39) {
			clearTimeout(_timeout3);
			var n = $('.items').get(index);
			n.style.top = "0";
			$('#navigate').get(0).insertBefore(n,$('#navigate').get(0).firstChild);
			_d1($('dt',n).get(0),_setArrowTop,subitem_index);
			n = null;
		};
	};

	/**
	 * 展开
	 * @param object t 当前栏目对象
	 * @return void
	 */
	var _d1 = function(t,fn,subitem_index){		
		$('.item_list:first',t.parentNode).css({'display':'block'});
		_tmpH = $('.item_list',t.parentNode).get(0).offsetHeight;
		if($(t.parentNode).data('items_height')==null) {
			$(t.parentNode).data('items_height',_tmpH);
		};
		_tmpH = $(t.parentNode).data('items_height');		
		$(t).css({'background':'url(media/dt_bg2.jpg)','color':'#000'});
		$('.item_list:first',t.parentNode).css({'height' : 0+'px'});
		for(var i=0; i<$('dt',nav).Elements.length; i++) {
			if($('dt',nav).get(i)==t) {	
				_this.spread(i,0,_tmpH,fn,subitem_index);
				break;
			};
		};
	};

	/**
	 * 收缩
	 * @param object t 当前栏目对象
	 * @param integer offset 用来计算的偏移量
	 * @param integer speed 执行速度
	 * @param function fn (可选)完成后执行的函数
	 * @return void
	 */
	var _d2 = function(t,offset,speed,fn,subitem_index){
		$(t).css({'background':'url(media/dt_bg.jpg)','color':'#fff'});
		for(var i=0; i<$('dt',nav).Elements.length; i++) {
			if($('dt',nav).get(i)==t) {
				var _h = $(t.parentNode).data('items_height');
				_this.striction(i,_h,offset,speed,fn,subitem_index);
				break;
			};
		};
	};

	/**
	 * 设置箭头的top
	 * @param integer subitem_index 当前栏目子项目对象索引
	 * @return void
	 */
	var _setArrowTop = function(subitem_index,spreadCrumbFn){
		var _dd = $('dd',$('.item_list',$('.items').get(0)).get(0)).get(subitem_index);
		$('#left_arrow').css({'visibility' : 'hidden'});
		//打开指定页面
		$('#iframe').get(0).src = $('a:first',_dd).get(0).href;
		//加载页面
		$('img:first',_dd).css({'visibility':'visible'});

		$.addEvent($('#iframe').get(0),'load',function(){
			var _top = 23 * subitem_index + 32;
			$('#left_arrow').css({'top' : _top+'px'});
			//非IE6则显示箭头
			if($.browser().Name!='msie' || ($.browser().Name=='msie' && parseInt($.browser().Version)>6)){
				$('#left_arrow').css({'visibility' : 'visible'});
			};
			//隐藏loading图标
			$('img:first',_dd).css({'visibility':'hidden'});
			//生成面包屑导航		
			var a = $('dt',_dd.parentNode.parentNode.parentNode).get(0).innerHTML;
			var b = $('a',_dd).get(0).innerHTML;
			var c = a + " > " + b;
			$('#crumbs').get(0).innerHTML = c;
			//arguments.callee 表示当前匿名函数对象
			$.removeEvent($('#iframe').get(0),'load',arguments.callee);
		});	
		//spreadCrumbFn(0,$('#crumbs').get(0).offsetWidth);
	};
	
	/*
	 * 动态面包屑导航
	 */
	/*
	_this.spreadCrumb = function(tmpW,width){		
		tmpW += 5;
		$('#crumbs').get(0).style.width = tmpW + "px";
		var t = setTimeout('this.spreadCrumb('+tmpW+','+width+')',0);
		if(tmpW >= width){
			clearTimeout(t);
		};	
	};
	*/
	/*
	 * 淡出菜单
	 */
	var _popMenu = function(x,y){
		x += 25;
		$('#popmenu:first').css({'left' : x+'px', 'top' : y+'px', 'display' : 'block'});
		var a = 0,b = 0.2,ie=false;
		if($.browser().Name=='msie'){
			b = 0.5;
			ie = true;
		};

		_this.fadePopMenu(function(){return $('#popmenu:first').get(0);},a,b,ie,true);
	};
	/*
	// 淡出
	_this.fadePopMenu(function(){return $('#popmenu:first').get(0);},0,0.5,$.browser().Name=='msie',true,function(){
		alert(this);
	});	
	// IE 淡入
	_this.fadePopMenu(function(){return $('#popmenu:first').get(0);},100,10,true,false);
	// 非IE 淡入
	_this.fadePopMenu(function(){return $('#popmenu:first').get(0);},1,0.01,false,false);
	*/
	_this.fadePopMenu = function(obj,value,offset,ie,out,callback){
		var num = 100;
		var p = 0;
		if(!out){
			value -= offset;
		}else{
			value += offset;
		};
		p = value;
		if(ie) {
			if(out) p = value * 10;
			obj().style.filter = 'alpha(opacity=' + p + ')';
		}else{
			if(out) p = value / 10;
			obj().style.opacity = p;
		};
		var t = setTimeout('this.fadePopMenu('+obj+','+value+','+offset+','+ie+','+out+','+callback+')',0);
		if(ie){
			num = 100;
		}else{
			num = 1;
		};
		if((out && p >= num) || (!out && value<=0)){
			clearTimeout(t);
			if(typeof callback=='function') {
				callback.call(obj());
				obj = null;
			};
			obj = null;
		};		
	};


	var _hidePopMenu = function() {
		var a = 1,b = 0.02,ie=false;
			if($.browser().Name=='msie'){
				a = 100;
				b = 3;
				ie = true;
			};
			_this.fadePopMenu(function(){return $('#popmenu:first').get(0);},a,b,ie,false,function(){
				$(this).css({'display' : 'none'});
			});
	};

	/*
	 * 动态左侧导航
	 */
	$.DynamicNav = function(){
		if($.browser().Name=='msie' && parseInt($.browser().Version)<=6) {
			$('#iframe').get(0).style.width = "794px";
		};
		//初始化隐藏导向的箭头
		$('#left_arrow').css({'visibility' : 'hidden'});
		nav = $('#navigate').get(0);
		
		$('dt',nav).toggle(
			function(){
				_d1(this);				
			},
			function(){
				//如果是第一栏收起则隐藏箭头
				for(var i=0; i<$('.items',this.parentNode.parentNode).Elements.length; i++) {
					if($('.items',this.parentNode.parentNode).get(i)==this.parentNode && i==0){
						$('#left_arrow').css({'visibility' : 'hidden'});
						$('#iframe').get(0).src = "information.php";
						$('#crumbs').get(0).innerHTML = "";
						break;
					};
				};
				var offset = ($.browser().Name=='firefox') ? 5 : 5;
				var speed = ($.browser().Name=='firefox') ? 1 : 5;  
				_d2(this,offset,speed);			
			}
		);

		$('.subitem').on('click',function(){
			//隐藏所有loading图标
			$('img',nav).css({'visibility':'hidden'});
			$('#crumbs').get(0).innerHTML = "";	
			var subitem_index = 0;
			for(var i=0; i<$('dd',this.parentNode.parentNode).Elements.length; i++) {
				if($('dd',this.parentNode.parentNode).get(i)==this) {
					subitem_index = i;
					break;
				};
			};
			var dt = this.parentNode.parentNode.previousSibling;
			//判断当前栏目是否在顶部位置(如果非顶部则上移到顶部位置)			
			if($('.items').get(0)!=this.parentNode.parentNode.parentNode) {
				$('#left_arrow').css({'visibility' : 'hidden'});
				while( dt.nodeType != 1 ){
					dt = dt.previousSibling;
				};				
				_d2(dt,5,1,function(){},subitem_index);
			}else{
				_setArrowTop(subitem_index,_this.spreadCrumb);
			};			
		});	

		$('#man:first').toggle(function(){
			var xy = $.getPosition(this);	
			_popMenu(xy.x,xy.y);			
		},function(){			
			_hidePopMenu();
		});
		
		//修改密码
		$('#change_pw_a').on('click',function(){	
			$('#left_arrow').css({'visibility' : 'hidden'});		
			$('#crumbs').get(0).innerHTML = '修改密码';
			$('#iframe').get(0).src = "change_pw.php";
			_hidePopMenu();
			$('#man:first').resetToggle();
		});
		
		//安装新管理模块
		$('#install_module').on('click',function(){	
			$('#left_arrow').css({'visibility' : 'hidden'});		
			$('#crumbs').get(0).innerHTML = '安装模块';
			$('#iframe').get(0).src = "install_module.php";
			this.parentNode.innerHTML = "";
		});
	};
})(GeeJs);