<?php
/**
 * Channel 类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2012-2-12
 * @package      
 */

class Channel {
	private $orm = NULL;
	private $c = '';
	private $c2 = '';
	private $theme = '';
	private $info = '';
	
	public function __construct(){
		global $GEEORM;
		$this->orm = $GEEORM;
		$arr = include './config/table.php';
		if($arr){
			$tprefix  = _getTablePrefix();
			$this->c  = $tprefix.$arr['channel'];
			$this->c2  = $tprefix.$arr['channel2'];
			$this->theme = $tprefix.$arr['themes'];
			$this->info =  $tprefix.'geeinfo';
		}
	}

	//添加栏目
	public function addChannel($arr1,$arr2) {
		return _opDbInsRelate($this->orm,$this->c,$this->c2,$arr1,$arr2,'channel_id');
	}
	
	//修改栏目
	public function editChannel($id,$arr1,$arr2,$pid='',$ids=array()) {
		$id = intval($id);
		$ok = TRUE;
		$ok =  _opDbUpdateRelate($this->orm,$id,$this->c,$this->c2,$arr1,$arr2,'channel_id',$pid,$ids);
		if($ok) {
			$uf = !empty($arr1['urlfield']) ? $arr1['urlfield'] : $id;
			_opDb($this->orm, array(
				'_table' => $this->info,
				'_where' => 'ori_channel_id='.$id,
				'uf' => $uf
			), 'update');
		}
		return $ok;
	}
	
	//获取栏目
	public function getChannels($id=0,$lang=1) {
		$id = intval($id);
		$lang = intval($lang);
		$c = $this->c.'.id='.$this->c2.'.channel_id';
		if (!empty($id)) {
			$c .= ' AND '.$this->c.'.id='.$id;
		}
		return $this->orm->from($this->c)->join($this->c2)->where($c)->getMeta();
	}
	
	//设置网站主题
	public function setTheme($theme='default') {
		global $GEEORM;
		if($GEEORM->from($this->theme)->count() > 0) {
			_opDb($GEEORM, array(
				'_table' => $this->theme,
				'themes' => $theme
			), 'update');			
		}else{
			_opDb($GEEORM, array(
				'_table' => $this->theme,
				'themes' => $theme
			), 'insert');
		}
		@file_put_contents(GEELEAF_ROOT.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'theme.php', "<?php return '{$theme}'; ?>");
		return TRUE;
	}
	
	//设置服务器是否支持URL Rewrite
	public function setRewrite($num=1) {
		global $GEEORM;
		if($GEEORM->from($this->theme)->count() > 0) {
			_opDb($GEEORM, array(
				'_table' => $this->theme,
				'rewritable' => $num
			), 'update');			
		}else{
			_opDb($GEEORM, array(
				'_table' => $this->theme,
				'rewritable' => $num
			), 'insert');
		}
		@file_put_contents(GEELEAF_ROOT.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'rewritable.php', "<?php return {$num}; ?>");
		return TRUE;
	}
	
	public function checkUrlField($urlfield,$channel_id='') {
		$urlfield = Geeleaf_func_m_escape($urlfield);
		$channel_id = intval(Geeleaf_func_m_escape($channel_id));
		$c = "(urlfield='".$urlfield."' AND urlfield<>'')";
		if(!empty($channel_id)) {
			$c .= " AND id<>".$channel_id;
		}
		$_count = $this->orm->from($this->c)->where($c)->count();
		if ($_count > 0) {
			return TRUE;
		}else{
			return FALSE;
		}
	}
	
	public function delChannel($id) {		
		$id = intval($id);	
		$arr = $this->_getAllSubId($id);
		array_unshift($arr, $id);
		$ids = implode(',', $arr);
		$d1 = $this->orm->from(_getThemeTplTable())->where('channel_id IN ('.$ids.')')->delete();
		$d2 = $this->orm->from(_getTablePrefix().'geeinchel')->where('channel_id IN ('.$ids.')')->delete();
		$d3 = (bool)$this->orm->from($this->c)->where('id IN ('.$ids.')')->delete();
		if($d3) {
			return (bool)$this->orm->from($this->c2)->where('channel_id IN ('.$ids.')')->delete();
		}
		return FALSE;
	}
	
	private function _getAllSubId($id) {	
		$ids = $this->orm->from($this->c)->fields('id')->where('pid='.$id)->getMeta();
		static $arr = array();
		foreach ($ids as $k=>$v) {
			if ($v['id']) {
				$arr[] = $v['id'];
				$this->_getAllSubId($v['id']);
			}			
		}		
		return $arr;
	}
}