<?php

class GeeWeb_Comment {
	private $orm = NULL;
	private $m = ""; 
	private $mc = "";
	public function __construct(){
		global $GEEORM;
		$this->orm = $GEEORM;
		$arr = include './config/table.php';
		if($arr){
			$tprefix = _getTablePrefix();
			$this->m = $tprefix.$arr['comment'];
			$this->mc = $tprefix.$arr['commentctrl'];
		}
		if($this->orm->from($this->mc)->count()==0) {
			_opDb($this->orm, array(
				'_table' => $this->mc,
				'only_user' => 0,
				'need_verify' => 0,
				'need_vcode' => 0,
				'intermission' => 0,
				'ilegal_replace' => '',
				'ilegal' => '',
			), 'insert');
		}
	}
	
	private function _makeUpdate($key,$value) {
		_opDb($this->orm, array(
			'_table' => $this->mc,
			$key => $value
		), 'update');
	}	
	private function _getField($key) {
		$value = $this->orm->from($this->mc)->fields($key)->getMetaOne(MYSQL_NUM);
		return $value[0];
	}
	
	//是否只允许会员评论
	public function onlyUser($bool=false) {
		$flag = 1;
		if(!$bool) {
			$flag = 0;
		}
		$this->_makeUpdate('only_user', $flag);
	}
	//是否需要审核留言
	public function needVerify($bool=false) {
		$flag = 1;
		if(!$bool) {
			$flag = 0;
		}
		$this->_makeUpdate('need_verify', $flag);	
	}
	//是否需要验证码
	public function needVcode($bool=false) {
		$flag = 1;
		if(!$bool) {
			$flag = 0;
		}
		$this->_makeUpdate('need_vcode', $flag);	
	}
	//设置留言时间间隔
	public function setInterval($seconds=0) {
		$seconds = intval($seconds);
		$this->_makeUpdate('intermission', $seconds);		
	}
	//设置非法词语替换
	public function setIlegalReplace($words='') {
		$this->_makeUpdate('ilegal_replace', $words);	
	}
	//设置非法词语过滤
	public function setIlegal($words='') {
		$this->_makeUpdate('ilegal', $words);	
	}
	
	public function getAllowAll() {
		return $this->_getField('only_user');
	}	
	public function getNeedVerify() {
		return $this->_getField('need_verify');
	}
	public function getNeedVcode() {
		return $this->_getField('need_vcode');
	}
	public function getInterval() {
		return $this->_getField('intermission');
	}
	public function getIlegalReplace() {
		return $this->_getField('ilegal_replace');
	}
	public function getIlegal() {
		return $this->_getField('ilegal');
	}
	/***************************************************/
	
	
	
	
	
	
	
	
	//获取评论列表
	public function getComments($page=1,$records=12,$appendcondi, $aparams='') {
		$sql = "SELECT * FROM {$this->m} WHERE {$appendcondi} ORDER BY time DESC";
		return _pageBg($sql,$page,$records,$aparams);
	}
	
	//获取评论
	public function getComment($id) {
		$c = "comment_id=".intval($id);
		return $this->orm->from($this->m)->where($c)->getMetaOne();
	}

	//修改评论
	public function editComment($id,$arr=array()) {
		if(!is_array($arr) || count($arr)<=0) {
			return false;
		}
		$arr['_table'] = $this->m;
		$arr['_where'] = "comment_id=".intval($id);
		_opDb($this->orm, $arr, 'update');
		return true;
	}
	
	//删除评论
	public function delComment($id) {
		$c = "comment_id=".intval($id);
		return $this->orm->from($this->m)->where($c)->delete();
	}
	
	
	
}