<?php

class GeeWeb_Information {
	private $orm = NULL;
	private $tpl_table = '';
	private $im = '';
	private $imf = '';
	private $info = '';
	private $ic = '';
	private $ch = '';
	private $imr = '';
	private $ir = '';
	private $iblock = '';
	private $ib = '';
	
	public function __construct(){
		global $GEEORM;
		$this->orm = $GEEORM;
		$tprefix  = _getTablePrefix();
		$arr = include './config/table.php';
		if($arr){
			$this->tpl_table = $tprefix.'geechannels';
			$this->im = $tprefix.'geeinfomodel';
			$this->imf = $tprefix.'geeimfields';
			$this->info = $tprefix.$arr['info'];
			$this->ic = $tprefix.$arr['infochannel'];
			$this->imr = $tprefix.$arr['imr'];
			$this->ir = $tprefix.$arr['ir'];
			$this->ch = $tprefix.'geechannels2';
			$this->iblock = $tprefix.$arr['iblock'];
			$this->ib = $tprefix.$arr['ib'];
		}
	}
	
	/**
	 * 读取模型
	 */
	public function getModels($id=0) {
		$id = intval($id);
		$c1 = $c2 = 1;
		$tmp = '';
		if(!empty($id)) {
			$tmp = array();
			$c1 = 'id='.$id;
			$c2 = 'im_id='.$id;
		}
		$_models = $this->orm->from($this->im)->where($c1)->getMeta();
		$_fields = $this->orm->from($this->imf)->where($c2)->order('sort ASC')->getMeta();
		if($_models) {
			foreach ($_models as $k1 => $v1) {				
				foreach ($_fields as $k2 => $v2) {
					if($v2['im_id']==$v1['id']) {
						if(!empty($id)) {
							$tmp[] = $v2;
						}else{
							$tmp .= $v2['flag'].'&nbsp;&nbsp;';
						}
					}
				}
				$_models[$k1]['fields'] = $tmp;
				$tmp = null;
			}
		}
		return $_models;
	}

	/**
	 * 根据栏目id获取模型表名
	 * @param array $ids
	 */
	public function getModelsByChnel($ids=array()) {
		$c = 1;
		if(is_array($ids) && !empty($ids)) {
			$id = implode(',', $ids);
			$c = "id IN ($id)";
		}
		return $this->orm->fields('table_name')->from($this->tpl_table)->where($c)->getMeta();		
	}
	
	/**
	 * 获取模型所有字段信息
	 * @param array $tns 模型数据表名数组
	 * @return array
	 */
	public function getModelsFields($tns=array()) {
		$c = 1;
		if(is_array($tns) && !empty($tns)) {
			$tn = array();
			foreach ($tns as $v) {
				$tn[] = "'".$v."'";
			}
			$tn = implode(',', $tn);
			$c = "table_name IN ($tn)";
		}
		$imids = $this->orm->from($this->im)->where($c)->getMeta();
		$fields = array();
		foreach ($imids as $v) {
			$fields[$v['name'].'|-|'.$v['table_name']] = $this->orm->fields('field_name,flag')->from($this->imf)->where('im_id='.$v['id'])->order('sort ASC')->getMeta();
		}	
		return $fields;
	}
	
	/**
	 * 获取模型所有字段信息和字段值
	 * @param array $tns 模型数据表名数组
	 * @param int $info_id 信息id
	 */
	public function getModelsFieldsValues($tns=array(),$info_id) {
		$info_id = intval($info_id);
		$c = 1;
		if(is_array($tns) && !empty($tns)) {
			$tn = array();
			foreach ($tns as $v) {
				$tn[] = "'".$v."'";
			}
			$tn = implode(',', $tn);
			$c = "table_name IN ($tn)";
		}
		$imids = $this->orm->from($this->im)->where($c)->getMeta();
		$fields = array();
		$tprefix = _getTablePrefix();
		foreach ($imids as $v) {
			$tmp = $this->orm->fields('field_name,flag')->from($this->imf)->where('im_id='.$v['id'])->order('sort ASC')->getMeta();
			foreach ($tmp as $k2=>$v2) {
				$fv = $this->orm->from($tprefix.$v['table_name'])->fields($v2['field_name'])->where('info_id='.$info_id)->getMetaOne(MYSQL_NUM);
				if(@isset($fv[0])) {
					$tmp[$k2]['field_value'] = $fv[0];
				}else{
					$tmp[$k2]['field_value'] = '';
				}
			}
			$fields[$v['name'].'|-|'.$v['table_name']] = $tmp;
		}	
		return $fields;
	}
	
	/**
	 * 添加信息
	 * @param array $base_arr 基本数据数组
	 * @param array $ext_arr post数组
	 * @param array $chel_ids 栏目id数组
	 */
	public function addInfo($base_arr,$ext_arr,$chel_ids) {
		$ok = false;
		$mids = array();
		$mods = array();
		foreach ($ext_arr as $k=>$v) {
			if(strpos($k, 'geemodel_')===0) {
				$tf = explode('-|-', $k);
				$mods[$tf[0]][$tf[1]] = $v;
			}
		}		
		$mNames = array_keys($mods);
		foreach ($mNames as $k => $v) {
			$mNames[$k] = "'{$v}'";
		}
		$mNames = implode(',', $mNames);
		if($mNames){
			$mids = $this->orm->fields('id')->from($this->im)->where("table_name IN ({$mNames})")->getMeta();
			foreach ($mids as $k => $v) {
				$mids[$k] = $v['id'];
			}			
		}
		$base_arr['_table'] = $this->info;
		//添加信息元数据
		$infoId = _opDb($this->orm, $base_arr, 'insert', true);
		if($infoId) {
			//添加信息与栏目的关联
			foreach ($chel_ids as $v) {
				_opDb($this->orm, array(
					'_table' => $this->ic,
					'info_id' => $infoId,
					'channel_id' => $v,
				), 'insert');
			}
			//添加信息扩展数据
			$tArr = array();
			foreach ($mods as $k => $v) {
				$tArr = $v;				
				$tArr['_table'] = _getTablePrefix().$k;
				$tArr['info_id'] = $infoId;
				_opDb($this->orm, $tArr, 'insert');
			}
			//添加信息与模型的关联
			foreach ($mids as $v) {
				_opDb($this->orm, array(
					'_table' => $this->imr,
					'info_id' => $infoId,
					'im_id' => $v,
				), 'insert');
			}
			$ok = true;
		}
		return $ok;		
	}
	
	/**
	 * 修改信息
	 * @param int $info_id 信息id
	 * @param array $base_arr 基本数据数组
	 * @param array $ext_arr post数组
	 * @param array $chel_ids 栏目id数组
	 */
	public function editInfo($info_id,$base_arr,$ext_arr,$chel_ids) {

		$info_id = intval($info_id);
		$mids = array();
		$mods = array();
		foreach ($ext_arr as $k=>$v) {
			if(strpos($k, 'geemodel_')===0) {
				$tf = explode('-|-', $k);
				$mods[$tf[0]][$tf[1]] = $v;
			}
		}		
		$mNames = array_keys($mods);
		foreach ($mNames as $k => $v) {
			$mNames[$k] = "'{$v}'";
		}
		$mNames = implode(',', $mNames);
		if($mNames){
			$mids = $this->orm->fields('id')->from($this->im)->where("table_name IN ({$mNames})")->getMeta();
			foreach ($mids as $k => $v) {
				$mids[$k] = $v['id'];
			}			
		}
		$base_arr['_table'] = $this->info;
		$base_arr['_where'] = 'info_id='.$info_id;
		
		$this->clearInfoExtData($info_id);
		
		//修改信息元数据
		_opDb($this->orm, $base_arr, 'update');
		
		//添加信息与栏目的关联
		foreach ($chel_ids as $v) {
			_opDb($this->orm, array(
				'_table' => $this->ic,
				'info_id' => $info_id,
				'channel_id' => $v,
			), 'insert');
		}
		//添加信息扩展数据
		$tArr = array();
		
		foreach ($mods as $k => $v) {
			$tArr = $v;				
			$tArr['_table'] = _getTablePrefix().$k;
			$tArr['info_id'] = $info_id;
			_opDb($this->orm, $tArr, 'insert');
		}
		//添加信息与模型的关联
		foreach ($mids as $v) {
			_opDb($this->orm, array(
				'_table' => $this->imr,
				'info_id' => $info_id,
				'im_id' => $v,
			), 'insert');
		}
		return true;	
	}
	
	/**
	 * 删除信息扩展数据
	 * @param int $info_id 信息id
	 */
	public function clearInfoExtData($info_id) {
		$info_id = intval($info_id);
		$mods = $this->orm->fields('table_name')->from($this->imr)->join($this->im)->where($this->imr.'.im_id='.$this->im.'.id AND '.$this->imr.'.info_id='.$info_id)->getMeta();
		$tprefix = _getTablePrefix();
		foreach ($mods as $v) {
			$this->orm->from($tprefix.$v['table_name'])->where('info_id='.$info_id)->delete();
		}
		$this->orm->from($this->ic)->where('info_id='.$info_id)->delete();
		$this->orm->from($this->imr)->where('info_id='.$info_id)->delete();
	}
	
	/**
	 * 分页读取信息
	 * @param int $page
	 * @param string $aprames
	 */
	public function getInfos($page=1,$acond,$aparams='',$records=11) {
		$sql1 = "SELECT a.*,b.channel_id FROM {$this->info} AS a,{$this->ic} AS b WHERE a.info_id=b.info_id{$acond} GROUP BY a.info_id";
		$sql2 = "SELECT d.*,c.name AS channel_name FROM ({$sql1}) AS d LEFT JOIN {$this->ch} AS c ON d.channel_id=c.channel_id AND c.lang=1 ORDER BY d.time_add DESC";
		return _pageBg($sql2,$page,$records,$aparams);
	}
	
	/**
	 * 读取信息关联的栏目id
	 * @param int $id
	 */
	public function getChelByInfo($id) {
		$id = intval($id);
		$cids = $this->orm->fields('channel_id')->from($this->ic)->where('info_id='.$id)->getMeta();
		$rs = array();
		foreach ($cids as $v) {
			$rs[] = $v['channel_id'];
		}
		return $rs;
	}
	
	/**
	 * 读取信息关联的模型id
	 * @param int $id
	 */
	public function getModelByInfo($id) {
		$id = intval($id);
		$cids = $this->orm->fields('im_id')->from($this->imr)->where('info_id='.$id)->getMeta();
		$rs = array();
		foreach ($cids as $v) {
			$rs[] = $v['im_id'];
		}
		return $rs;
	}
	
	/**
	 * 读取信息详细数据
	 * @param int $id 信息id
	 */
	public function getInfo($id) {
		$id = intval($id);
		return $this->orm->fields('*')->from($this->info)->where('info_id='.$id)->getMetaOne();
	}
	
	/**
	 * 删除信息
	 * @param int $id 信息id
	 */
	public function delInfo($id) {
		$id = intval($id);
		$this->orm->from($this->info)->where('info_id='.$id)->delete();
		$this->clearInfoExtData($id);
		$this->delInfoRs($id);
		$this->orm->from($this->ib)->where('info_id='.$id)->delete();		
	}
	
	/**
	 * 递归获取指定栏目的所有父栏目
	 * @param int $channel_id 栏目id
	 */
	public function getParentChels($channel_id) {
		static $ids = array();
		static $i = 0;
		if($i==0) {
			$ids[] = $channel_id; //加入初始栏目id
		}
		$pid = $this->orm->from($this->tpl_table)->fields('id,pid')->where('id='.$channel_id)->getMetaOne();
		if($pid['pid']!=0) {	
			$i++;
			$ids[] = $pid['pid'];		
			$this->getParentChels($pid['pid']);			
		}
		return $ids;
	}
	
	/**
	 * 获取指定栏目的URL字段
	 * @param int $channel_id 栏目id
	 */
	public function getURLField($channel_id) {
		$urlf = $channel_id;
		$uf = $this->orm->from($this->tpl_table)->fields('urlfield')->where('id='.$channel_id)->getMetaOne();
		if(!empty($uf['urlfield'])) {
			$urlf = $uf['urlfield'];
		}
		return $urlf;
	}
	
	/**
	 * 删除信息阅读统计
	 * @param int $info_id 信息id
	 */
	private function delInfoRs($info_id) {
		$flag = "({$info_id}:";
		$sql = "UPDATE {$this->ir} SET read_count=REPLACE(read_count,SUBSTRING(read_count,LOCATE('{$flag}',read_count),LOCATE(')',read_count,LOCATE('{$flag}',read_count))-LOCATE('{$flag}',read_count)+1),'')";
		$this->orm->exec($sql);
	}
	
	/**
	 * 添加信息区块
	 * @param string $name 信息区块名称
	 */
	public function addInfoBlock($name) {
		return _opDb($this->orm, array(
			'_table' => $this->iblock,
			'ib_name' => $name
		), 'insert');		
	}
	
	/**
	 * 读取信息区块列表
	 */
	public function getInfoBlockList() {
		return $this->orm->from($this->iblock)->getMeta();
	}
	
	/**
	 * 删除信息区块
	 */
	public function delInfoBlock($id) {
		$id = intval($id);
		$this->orm->from($this->iblock)->where('ib_id='.$id)->delete();
		$this->orm->from($this->ib)->where('ib_id='.$id)->delete();
	}
	
	/**
	 * 修改信息区块
	 * @param int $id
	 * @param string $name
	 */
	public function editInfoBlock($id,$name) {
		$id = intval($id);
		_opDb($this->orm, array(
			'_table' => $this->iblock,
			'_where' => 'ib_id='.$id,
			'ib_name' => $name
		), 'update');
		return true;
	}
	
	/**
	 * 将信息和信息区块关联
	 * @param int $ib_id
	 * @param int $info_id
	 */
	public function relateInfoBlock($ib_id,$info_id) {
		$ib_id = intval($ib_id);
		$info_id = intval($info_id);
		_opDb($this->orm, array(
			'_table' => $this->ib,
			'ib_id' => $ib_id,
			'info_id' => $info_id
		), 'insert');
	}
	
	/**
	 * 检查信息与信息区块是否已关联
	 * @param int $ib_id
	 * @param int $info_id
	 */
	public function hasRelateIb($ib_id,$info_id) {
		$ib_id = intval($ib_id);
		$info_id = intval($info_id);
		return (bool)$this->orm->from($this->ib)->where("ib_id={$ib_id} AND info_id={$info_id}")->count();
	}
	
	/**
	 * 分页读取信息区块关联的信息
	 * @param int $ib_id
	 * @param int $page
	 * @param string $aparams
	 */
	public function getRelatedInfos($ib_id,$page=1,$aparams='') {
		$ib_id = intval($ib_id);
		$sql1 = "SELECT a.*,b.channel_id FROM {$this->info} AS a,{$this->ic} AS b,{$this->ib} AS r WHERE a.info_id=b.info_id AND a.info_id=r.info_id AND r.ib_id={$ib_id} GROUP BY a.info_id";
		$sql2 = "SELECT d.*,c.name AS channel_name FROM ({$sql1}) AS d LEFT JOIN {$this->ch} AS c ON d.channel_id=c.channel_id AND c.lang=1 ORDER BY d.time_add DESC";
		return _pageBg($sql2,$page,15,$aparams);
	}
	
	/**
	 * 删除信息区块关联
	 * @param int $ib_id
	 * @param int $info_id
	 */
	public function delInfoRelate($ib_id,$info_id) {
		$ib_id = intval($ib_id);
		$info_id = intval($info_id);
		return (bool)$this->orm->from($this->ib)->where("ib_id={$ib_id} AND info_id={$info_id}")->delete();
	}
}