<?php

$op = $dowhat = '';

$situation = $from = $fenjuan = $fenjuankb = $selectedtables = $selectedfiles = $selecteddel = $del_index = '';

$sms = $success = '';

$BFiles = '';

require '../_base/init.php';

if(empty($page)) {
	$page = 1;
}

$datadir = dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'_base'.DIRECTORY_SEPARATOR.'databackup';
$canBackup = is_writable($datadir);


$DataBackup = new DataBackup($GEEORM);
$db = _getDbConf();
$DataBackup->Db = $db['Database'];


$BFiles = _listBackupFiles($datadir.DIRECTORY_SEPARATOR);

if($dowhat=='backup') {
	$ok = false;
	//数据备份	
	$DataBackup->Tables = $selectedtables;	
	if (is_array($selectedtables)) {
		if ($situation==1) {
			//备份到服务器					
			if ($fenjuan==1) {
				$DataBackup->LimitKb = floatval($fenjuankb);
			}	
			$ok = $DataBackup->server($datadir);			
		}else{
			//备份到本地
			$DataBackup->local();
			exit;
		}
	}
	$success = $ok;
	if($success) {
		$sms = "数据备份成功";
	}else{
		$sms = "数据备份失败";
	}	
}else if($dowhat=='restore') {
	$ok = array();
	//数据恢复
	if ($from==1) {
		//从服务器上的备份文件恢复
		if (is_array($selectedfiles)) {
			foreach ($selectedfiles as $v) {
				$ok[] = $DataBackup->restoreFromServer($datadir.DIRECTORY_SEPARATOR.$BFiles[$v]['name']);
			}
		}
	}else{
		//从本地上传的备份文件恢复
		$ok[] = $DataBackup->restorFromLocal(GEELEAF_ROOT.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR);
	}
	$success = in_array(true, $ok);
	if($success) {
		$sms = "数据恢复成功";
	}else{
		$sms = "数据恢复失败";
	}
}else if($dowhat=='delfiles'){	
	if(is_array($selecteddel)) {
		foreach ($selecteddel as $v) {
			@unlink($datadir.DIRECTORY_SEPARATOR.$v);
		}
	}
	$page = 1;
}else{
	if($del_index!='') {
		@unlink($datadir.DIRECTORY_SEPARATOR.$del_index);
	}
}

function _listTables() {
	global $GEEORM;
	$db = _getDbConf();
	$db = $db['Database'];	
	$alltables = $GEEORM->query("SHOW TABLES FROM {$db}", MYSQL_NUM);
	$prefix = _getTablePrefix().'gee';
	$tables = array();
	foreach ($alltables as $v) {
		if(strpos($v[0], $prefix)===0) {
			$tables[] = $v[0];
		}
	}
	return $tables;
}

function _listBackupFiles($d) {
	$arr = array();
	if(($handle = @opendir($d))==true){
		$i = 0;
		while (false !== ($file = readdir($handle))) {
			$_ext = pathinfo($file);
	        if ($_ext['extension']=='sql'){ 	        	
	        	$arr[$i]['name'] = $file;
	        	$arr[$i]['size'] = filesize($d.$file);
	        	$arr[$i++]['time'] = date('Y-m-d H:i:s',filemtime($d.$file));
	        }
	    }	
	}
	return $arr;
}


function _pagiBfiles($arr, $page, $records=13) {
	$rs = array('Data'=>'','PageBar'=>'');
	$p = PaginationArray::factory($arr);
	$p->Page = $page; 
	$p->Records = $records;
	$rs['Data'] = $p->get();
	$ps = PaginationStyle::factory($p->Page, $p->getPageCount());
	$ps->RecordCount = $p->getRecordCount();
	$ps->setLink('?op=getfiles&page=%s');	
	if($ps->RecordCount > $p->Records) {
		$rs['PageBar'] = $ps->getTwo();
	}
	return $rs;
}

$BFiles = _listBackupFiles($datadir.DIRECTORY_SEPARATOR);

$pBFiles = _pagiBfiles($BFiles, $page, 13);

_printModuleView('4', array(
	'Op' => $op,
	'DoWhat' => $dowhat,
	'Success' => $success,
	'Sms' => $sms,
	'Tables' => _listTables(),
	'BFiles' => $BFiles,
	'PBFiles' => $pBFiles['Data'],
	'PageBar' => $pBFiles['PageBar'],
	'CanBackup' => $canBackup,
	'BackupDir' => '不能备份到服务器。'.$datadir.'目录不存在或对其没有写权限'
));