<?php
/**
 * SuperAdmin 类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2012-3-15
 * @package      
 */

class SuperAdmin {
	private $orm = NULL;
	private $admintable = '';
	public function __construct(){
		global $GEEORM;
		$admin_table = _getTableConf();	
		$this->orm = $GEEORM;
		$this->admintable = $admin_table['rbac_admin']['table'];
	}

	//添加管理员
	public function addAdmin($name, $pw, $issuper=0) {
		if(empty($name) || empty($pw)) {
			return false;
		}
		$issuper = intval($issuper);
		return _opDb($this->orm, array(
			'_table' => $this->admintable,
			'name' => $name,
			'password' => Geeleaf_func_crypt($pw, _getSalt(), true),
			'super' => $issuper
		),'insert');
	}
	
	//更改管理属性
	public function editAdmin($id,$issuper) {
		$issuper = (int)(bool)intval($issuper);
		$id = intval($id);
		_opDb($this->orm, array(
			'_table' => $this->admintable,
			'_where' => 'id='.$id,
			'super' => $issuper
		),'update');
		return true;
	}
	
	//删除管理员
	public function delAdmin($id) {
		$id = intval($id);
		return (bool)$this->orm->from($this->admintable)->where('id='.$id)->delete();
	}
	
	//分页获取管理员(不获取当前登录的超级管理员)
	public function getAdmins($page=1,$records=15) {
		$table = $this->admintable;		
		$id = intval(Session::getInstance()->get('AdminId'));	
		return _pagination($table,$page,$records,'id<>'.$id);
	}
}