<?php

class Theme_Blue {
	private $orm = NULL;
	private $tpl_table = '';
	private $im = '';
	private $imf = '';
	private $info = '';
	private $ic = '';
	
	public function __construct(){
		global $GEEORM;
		$this->orm = $GEEORM;
		$tprefix  = _getTablePrefix();
		$arr = include './config/table.php';
		if($arr){
			$this->tpl_table = $tprefix.$arr['tpl_table'];
			$this->im = $tprefix.$arr['infomodel'];
			$this->imf = $tprefix.$arr['imfields'];
			$this->info = $tprefix.$arr['info'];
			$this->ic = $tprefix.$arr['infochannel'];
		}
	}
	
	/**
	 * 添加模型
	 * @param array $m_arr 模型基本信息
	 * @param array $f1_arr 字段名称数组
	 * @param array $f2_arr 字段类型数组
	 * @param array $f3_arr 字段标识数组
	 * @return bool
	 */
	public function addModel($m_arr,$f1_arr,$f2_arr,$f3_arr,$f4_arr) {
		$ok = false;
		$tf = $m_arr['table_name'];
		$m_arr['_table'] = $this->im;
		$m_id = _opDb($this->orm,$m_arr,'insert',true);
		if($m_id) {
			if(is_array($f1_arr) && !empty($f1_arr)) {
				$_count = count($f1_arr);
				$fields = array();
				for ($i = 0; $i < $_count; $i++) {					
					$fields[] = "`{$f1_arr[$i]}` {$f2_arr[$i]}";					
					$ok = (bool)_opDb($this->orm, array(
						'_table' => $this->imf,
						'im_id' => $m_id,
						'field_name' => $f1_arr[$i],
						'field_type' => $f2_arr[$i],
						'flag' => $f3_arr[$i],
						'sort' => intval($f4_arr[$i]),
					),'insert');
				}
				if($ok) {
					$sf = "info_id INT(11) NOT NULL,".implode(',', $fields);
					$sql = "CREATE TABLE IF NOT EXISTS `"._getTablePrefix().$tf."` ($sf) ENGINE=MyISAM DEFAULT CHARSET=utf8";
					$ok = (bool)$this->orm->exec($sql);
				}
			}
		}		
		return $ok;		
	}
	
	/**
	 * 读取模型
	 */
	public function getModels($id=0) {
		$id = intval($id);
		$c1 = $c2 = 1;
		$tmp = '';
		if(!empty($id)) {
			$tmp = array();
			$c1 = 'id='.$id;
			$c2 = 'im_id='.$id;
		}
		$_models = $this->orm->from($this->im)->where($c1)->getMeta();
		$_fields = $this->orm->from($this->imf)->where($c2)->order('sort ASC')->getMeta();
		if($_models) {
			foreach ($_models as $k1 => $v1) {				
				foreach ($_fields as $k2 => $v2) {
					if($v2['im_id']==$v1['id']) {
						if(!empty($id)) {
							$tmp[] = $v2;
						}else{
							$tmp .= $v2['flag'].'&nbsp;&nbsp;';
						}
					}
				}
				$_models[$k1]['fields'] = $tmp;
				$tmp = null;
			}
		}
		return $_models;
	}
	
	/**
	 * 删除模型
	 * @param int $id
	 */
	public function delModel($id) {
		$ok = false;
		$id = intval($id);
		$_imf = $this->orm->fields('table_name')->from($this->im)->where('id='.$id)->getMetaOne();
		$_imf = _getTablePrefix().$_imf['table_name'];
		$d1 = (bool)$this->orm->from($this->im)->where('id='.$id)->delete();
		$d2 = (bool)$this->orm->from($this->imf)->where('im_id='.$id)->delete();
		if($d1 && $d2) {
			$sql = "DROP TABLE IF EXISTS `$_imf`";
			$ok = (bool)$this->orm->exec($sql);
		}
		return $ok;
	}
	
	/**
	 * 修改模型
	 * @param int $id 模型id
	 * @param array $arr 模型基本信息数组
	 * @param array $farr 字段名称、字段类型、字段标识数组
	 */
	public function editModel($id,$arr,$farr=array()) {
		$ok = true;
		$id = intval($id);
		$arr['_table'] = $this->im;
		$arr['_where'] = 'id='.$id;
		_opDb($this->orm, $arr, 'update');		
		if(is_array($farr) && count($farr)>=3) {
			$tf = $this->orm->from($this->im)->fields('table_name')->where('id='.$id)->getMetaOne();
			$tf = _getTablePrefix().$tf['table_name'];
			$fields = array();
			$nameArr = $farr[0];
			$typeArr = $farr[1];
			$flagArr = $farr[2];
			$sortArr = $farr[3];
			$_count = count($nameArr);
			for ($i = 0; $i < $_count; $i++) {
				$fields[] = "ADD COLUMN `{$nameArr[$i]}` {$typeArr[$i]}";
				$ok = (bool)_opDb($this->orm, array(
					'_table' => $this->imf,
					'im_id' => $id,
					'field_name' => $nameArr[$i],
					'field_type' => $typeArr[$i],
					'flag' => $flagArr[$i],
					'sort' => intval($sortArr[$i]),
				),'insert');
			}
			if($ok) {
				$sf = implode(',',$fields);
				$sql = "ALTER TABLE `$tf` $sf";
				$ok = (bool)$this->orm->exec($sql);
			}
		}
		return $ok;
	}
	
	/**
	 * 删除模型字段
	 * @param int $id 字段id
	 * @param int $mid 模型id
	 */
	public function dropModelField($id,$mid) {
		$ok = false;
		$id = intval($id);
		$mid = intval($mid);
		$tf = $this->orm->from($this->im)->fields('table_name')->where('id='.$mid)->getMetaOne();
		$tf = _getTablePrefix().$tf['table_name'];
		$fn = $this->orm->from($this->imf)->where('id='.$id)->getMetaOne();
		$fn = $fn['field_name'];		
		$d1 = (bool)$this->orm->from($this->imf)->where('id='.$id)->delete();
		if($d1) {
			$sql = "ALTER TABLE `$tf` DROP COLUMN `$fn`";
			$ok = (bool)$this->orm->exec($sql);
		}
		return $ok;
	}
	
	/**
	 * 根据栏目id获取模型表名
	 * @param array $ids
	 */
	public function getModelsByChnel($ids=array()) {
		$c = 1;
		if(is_array($ids) && !empty($ids)) {
			$id = implode(',', $ids);
			$c = "channel_id IN ($id)";
		}
		return $this->orm->fields('table_name')->from($this->tpl_table)->where($c)->getMeta();		
	}
	
	/**
	 * 获取模型所有字段信息
	 * @param array $tns 模型数据表名数组
	 * @return array
	 */
	public function getModelsFields($tns=array()) {
		$c = 1;
		if(is_array($tns) && !empty($tns)) {
			$tn = array();
			foreach ($tns as $v) {
				$tn[] = "'".$v."'";
			}
			$tn = implode(',', $tn);
			$c = "table_name IN ($tn)";
		}
		$imids = $this->orm->from($this->im)->where($c)->getMeta();
		$fields = array();
		foreach ($imids as $v) {
			$fields[$v['name'].'|-|'.$v['table_name']] = $this->orm->fields('field_name,flag')->from($this->imf)->where('im_id='.$v['id'])->order('sort ASC')->getMeta();
		}	
		return $fields;
	}
	
	/**
	 * 修改模型表字段
	 * @param int $id
	 * @param array $arr
	 */
	public function changeField($id,$oldfn,$table_name,$arr) {
		$ok = false;
		$id = intval($id);
		if(empty($id) || empty($oldfn) || empty($table_name) || empty($arr)) {
			return false;
		}		
		$fn = $arr['field_name'];
		$ft = $arr['field_type'];
		
		$sql = "ALTER TABLE `$table_name` CHANGE `$oldfn` `$fn` $ft";
		$ok = $this->orm->exec($sql);
		if($ok){
			$arr['_table'] = $this->imf;
			$arr['_where'] = 'id='.$id;
			_opDb($this->orm, $arr, 'update');
			$ok = true;
		}	
		return $ok;
	}
	
	/**
	 * 添加信息
	 * @param array $base_arr 基本数据数组
	 * @param array $ext_arr post数组
	 * @param array $chel_ids 栏目id数组
	 */
	public function addInfo($base_arr,$ext_arr,$chel_ids) {
		$mods = array();
		foreach ($ext_arr as $k=>$v) {
			if(strpos($k, 'geebluemodel_')===0) {
				$tf = explode('-|-', $k);
				$mods[$tf[0]][$tf[1]] = $v;
			}
		}
		var_dump($base_arr);
		var_dump($mods);
		var_dump($chel_ids);
		
	}
}