<?php
/**
 * User 类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2012-3-7
 * @package      
 */

class User {
	private $orm = NULL;
	private $u = "user"; 
	private $uc = "user_control";
	public function __construct(){
		global $GEEORM;
		$this->orm = $GEEORM;
		$arr = include './config/table.php';
		if($arr){
			$tprefix = _getTablePrefix();
			$this->u = $tprefix.$arr['user'];
			$this->uc = $tprefix.$arr['user_control'];
		}
	}

	public function setVerify($num=0) {
		$num = Geeleaf_func_m_escape(intval($num));
		if ($this->orm->from($this->uc)->count() > 0) {
			_opDb($this->orm, array('_table' => $this->uc,'need_verify' => $num), 'update');			
		}else{
			_opDb($this->orm, array('_table' => $this->uc,'need_verify' => $num), 'insert');
		}
		return TRUE;	
	}
	
	public function setCaptcha($num=0) {
		$num = Geeleaf_func_m_escape(intval($num));
		if ($this->orm->from($this->uc)->count() > 0) {
			_opDb($this->orm, array('_table' => $this->uc,'need_captcha' => $num), 'update');			
		}else{
			_opDb($this->orm, array('_table' => $this->uc,'need_captcha' => $num), 'insert');
		}
		return TRUE;	
	}
	
	public function setCaptchaLogin($num=0) {
		$num = Geeleaf_func_m_escape(intval($num));
		if ($this->orm->from($this->uc)->count() > 0) {
			_opDb($this->orm, array('_table' => $this->uc,'need_captcha_login' => $num), 'update');			
		}else{
			_opDb($this->orm, array('_table' => $this->uc,'need_captcha_login' => $num), 'insert');
		}
		return TRUE;	
	}
	
	public function getVerify() {
		$rs = $this->orm->from($this->uc)->getMetaOne();
		return isset($rs['need_verify']) ? $rs['need_verify'] : 0;
	}
	
	public function getCaptcha() {
		$rs = $this->orm->from($this->uc)->getMetaOne();
		return isset($rs['need_captcha']) ? $rs['need_captcha'] : 0;
	}
	
	public function getCaptchaLogin() {
		$rs = $this->orm->from($this->uc)->getMetaOne();
		return isset($rs['need_captcha_login']) ? $rs['need_captcha_login'] : 0;
	}
	
	public function addUser($arr=array()) {
		$name = Geeleaf_func_m_escape($arr['name']);
		if ($this->orm->from($this->u)->where("name='".$name."'")->count() > 0) {
			return FALSE;
		}else{
			$arr['_table'] = $this->u;
			_opDb($this->orm, $arr, 'insert');	
			return TRUE;		
		}		
	}
	
	public function getUsersForPage($page=1,$records=10,$where='',$append='') {
		return _pagination($this->u,$page,$records,$where,'',$append);
	}
	
	public function getUser($id) {
		$id = intval($id);
		$udata = $this->orm->from($this->u)->where('id='.$id)->getMetaOne();
		return $udata;
	}
	
	public function editUser($id, $arr=array()) {
		$id = intval($id);
		$name = Geeleaf_func_m_escape($arr['name']);
		if ($this->orm->from($this->u)->where("name='".$name."' AND id<>".$id)->count() > 0) {
			return FALSE;
		}else{
			$arr['_table'] = $this->u;
			$arr['_where'] = 'id='.$id;
			_opDb($this->orm, $arr, 'update');			
		}
		return TRUE;	
	}
	
	public function delUser($id) {
		$id = intval($id);
		return (bool)$this->orm->from($this->u)->where('id='.$id)->delete();
	}
}