<?php

class Core_Channel {
	private $c = 'geechannels';
	private $c2 = 'geechannels2';
	private $tc = '';
	private $im = '';
	private $orm = null;
	private static $ins = null;
	
	public function __construct() {
		global $GEEORM;
		$t = _getTablePrefix();
		$this->orm = $GEEORM;
		$this->c   = $t.'geechannels';
		$this->c2  = $t.'geechannels2';
		$this->tc  = _getThemeTplTable();	
		$this->im  = $t.'geeinfomodel';	
	}
	
	public static function getInstance() {
		if(!(self::$ins instanceof self)){			
			self::$ins = new self();
		}	
		return self::$ins;
	}
	
	/**
	 * 读取(子)栏目
	 * @param int $pid 父栏目id(默认0)
	 * @param int $lang 语言版本(默认1)
	 * @param array $notin 忽略的栏目id数组
	 * @param int $limit 数量限制(默认0)
	 * @return array
	 */
	public function getChannels($pid=0,$notin=array(),$limit=0) {
		$t1 = $this->c;
		$t2 = $this->c2;
		$tc = $this->tc;
		
		$pid = intval($pid);
		$limit = intval($limit);
		$_limit = '';
		$_notin = empty($notin) ? '' : " AND {$t1}.id NOT IN (".join(',',$notin).")";
		if(!empty($limit)) {
			$_limit = "LIMIT {$limit}";
		}
		$c = "{$t1}.id={$t2}.channel_id AND {$t1}.id={$tc}.channel_id AND {$tc}.status=1 AND {$t1}.pid={$pid} AND {$t2}.lang=1{$_notin} ORDER BY {$tc}.sort ASC {$_limit}";
		$sql = "SELECT * FROM {$t1},{$t2},{$tc} WHERE {$c}";
		$rs = $this->orm->query($sql);
		if(is_array($rs) && !empty($rs)) {
			foreach($rs as $k => $v) {
				if (empty($v['urlfield'])) {
					$rs[$k]['urlfield'] = $v['channel_id'];
				}
				$rs[$k]['url'] = _urlRoot().$rs[$k]['urlfield'];
			}
		}
		return is_array($rs) ? $rs : array();
	}
	
	
	
	
	/**
	 * 根据子栏目id获取父栏目
	 * @param int $subid 子栏目id
	 * @param int $lang 语言版本(默认1)
	 * @return array
	 */
	public function getParentChannel($subid) {
		$t1 = $this->c;
		$t2 = $this->c2;
		$tc = $this->tc;
		
		$subid = intval($subid);
		$c = "{$t1}.id={$t2}.channel_id AND {$t1}.id={$tc}.channel_id AND {$tc}.status=1 AND {$t2}.lang=1 AND {$t1}.id = ( SELECT {$t1}.pid FROM {$t1} WHERE {$tc}.status=1 AND {$t1}.id={$subid} )";
		$sql = "SELECT * FROM {$t1},{$t2},{$tc} WHERE {$c}";
		$rs = $this->orm->query($sql);
		if(is_array($rs) && !empty($rs)) {
			foreach($rs as $k => $v) {
				if (empty($v['urlfield'])) {
					$rs[$k]['urlfield'] = $v['channel_id'];
				}
			}
		}		
		return is_array($rs) ? @$rs[0] : array();
	}
	
	/**
	 * 根据栏目id读取栏目信息
	 * @param int $id 栏目id
	 * @param int $lang 语言版本(默认1)
	 * @return array
	 */
	public function getChannelDetail($id=0) {
		$t1 = $this->c;
		$t2 = $this->c2;
		$tc = $this->tc;
		
		$id = intval($id);
		$c = "{$t1}.id={$t2}.channel_id AND {$t1}.id={$tc}.channel_id AND {$tc}.status=1 AND {$t1}.id={$id} AND {$t2}.lang=1";
		$sql = "SELECT * FROM {$t1},{$t2},{$tc} WHERE {$c}";
		$rs = $this->orm->query($sql);
		if(is_array($rs) && !empty($rs)) {
			foreach($rs as $k => $v) {
				if (empty($v['urlfield'])) {
					$rs[$k]['urlfield'] = $v['channel_id'];
				}
				$rs[$k]['url'] = _urlRoot().$rs[$k]['urlfield'];
			}
		}
		return is_array($rs) ? @$rs[0] : array();
	}
	
	/**
	 * 根据栏目id获取栏目面包屑导航
	 * @param int $subid 栏目id
	 * @param int $lang 语言版本(默认1)
	 */
	public function getChannelCrumb($subid) {
		static $arr = array();
		$arr2 = array();
		static $i = 0;
		$t1 = $this->c;
		$t2 = $this->c2;
		$tc = $this->tc;
		
		$subid = intval($subid);
		$c = "{$t1}.id={$t2}.channel_id AND {$t1}.id={$tc}.channel_id AND {$tc}.status=1 AND {$t2}.lang=1 AND {$t1}.id={$subid}";	
		$sql = "SELECT {$t1}.id,{$t1}.pid,{$t1}.urlfield,{$t1}.table_name,{$t2}.name FROM {$t1},{$t2},{$tc} WHERE {$c}";
		$rs = $this->orm->query($sql);
		if (isset($rs[0]['pid'])) {		
			$arr[++$i]['id'] = $rs[0]['id'];
			$arr[$i]['name'] = $rs[0]['name'];
			$arr[$i]['model'] = $rs[0]['table_name'];
			if (empty($rs[0]['urlfield'])) {
				$arr[$i]['urlfield'] = $rs[0]['id'];
			}else{
				$arr[$i]['urlfield'] = $rs[0]['urlfield'];
			}		
			$arr[$i]['url'] = _urlRoot().$rs[0]['urlfield'];		
			$this->getChannelCrumb($rs[0]['pid']);		
		}		
		$arr2 = array_reverse($arr);
		unset($arr,$i);
		return $arr2;
	}
	
	/**
	 * 根据子栏目id获取最高层的父id
	 * @param int $subid 子栏目
	 * @return mixed
	 */
	public function getTopParentChannelId($subid) {
		static $pid = array();
		$t = $this->c;
		$tc = $this->tc;
		
		$subid = intval($subid);
		$c = "SELECT id,pid FROM {$t},{$tc} WHERE {$t}.id={$tc}.channel_id AND {$t}.id={$subid} AND {$tc}.status=1";
		$rs = $this->orm->queryOne($c);
		if($rs) {
			if($rs['pid']!=0) {
				$this->getTopParentChannelId($rs['pid']);	
				$pid[] = $rs['pid'];			
			}
			return isset($pid[0]) ? (int)$pid[0] : 0;
		}else{
			return '';
		}
	}
	
	
	public function getModelIdByChnel($channel_id) {
		$channel_id = intval($channel_id);
		$c = "{$this->c}.table_name={$this->im}.table_name AND {$this->c}.id={$channel_id}";
		$rs = $this->orm->from($this->c)->join($this->im)->fields($this->im.'.id')->where($c)->getMetaOne();
		return @$rs['id'];
	}
}


/**
 * 读取(子)栏目
 * @param int $pid 父栏目id
 * @param array $notin 忽略读取的id数组
 * @param int $limit 限制个数
 */
function gt_chs($pid=0,$notin=array(),$limit=0) {	
	return Core_Channel::getInstance()->getChannels($pid,$notin,$limit);
}

/**
 * 根据子栏目id获取父栏目
 * @param int $subid 子栏目id
 */
function gt_pch($subid) {
	return Core_Channel::getInstance()->getParentChannel($subid);
}

/**
 * 根据栏目id读取栏目
 * @param int $id 栏目id
 */
function gt_ch($id=0) {	
	return Core_Channel::getInstance()->getChannelDetail($id);
}

/**
 * 根据栏目id获取栏目面包屑导航
 * @param int $subid 栏目id
 */
function gt_crumb($subid) {
	return Core_Channel::getInstance()->getChannelCrumb($subid);
}

/**
 * 读取最高层父栏目id
 * @param int $subid 子栏目id
 */
function gt_tchid($subid) {
	return Core_Channel::getInstance()->getTopParentChannelId($subid);
}

/**
 * 获取与指定栏目关联的信息模型id
 * @param int $channel_id 栏目id
 */
function gt_imid($channel_id) {
	return Core_Channel::getInstance()->getModelIdByChnel($channel_id);
}