<?php
class Core_Comment {
	private $m = 'geecomment';
	private $mc = 'geecommentctrl';
	private $tlimit = 0;
	private $orm = null;
	private static $ins = null;
	public function __construct() {
		global $GEEORM;		
		$this->orm = $GEEORM;
		$t = _getTablePrefix();
		$this->m = $t.$this->m;
		$this->mc = $t.$this->mc;
	}	
	public static function getInstance() {
		if(!(self::$ins instanceof self)){			
			self::$ins = new self();
		}	
		return self::$ins;
	}
	
	public function write($info_id,$user,$content,$vcode='') {
		$d = $this->_messagelimit();
		if(!$d['CanComment']){
			return -1; //不允许游客留言
		}
		if($d['need_vcode']==1 && strtolower($vcode)!=_sessionVar('Captcha')) {
			return -2; //验证码错误
		}
		if(!Cookie::getInstance()->get('NoCommentTimeLimit')) {
			if(Cookie::getInstance()->get('CommentLimitTime')!='') {
				return -3; //在留言间隔时间限制内不能留言
			}
		}
		$status = ($d['need_verify']==1) ? 0 : 1;		
		_opDb($this->orm, array(
			'_table' => $this->m,			
			'pid' => 0,
			'info_id' => $info_id,
			'name' => $user,
			'content' => $content,
			'time' => time(),
			'ip' => Geeleaf_func_ip(),
			'status' => $status,
		), 'insert');
		Cookie::getInstance()->set('CommentLimitTime',$this->tlimit,$this->tlimit);
		return 1;
	}
	
	public function read($info_id,$page=1,$records=10) {
		$info_id = intval($info_id);
		$sql = "SELECT * FROM {$this->m} WHERE status=1 AND info_id={$info_id} ORDER BY time DESC";
		$rs = _pageFr($sql,'',$page,$records,'',true);
		$ilegal = $this->orm->fields('ilegal_replace,ilegal')->from($this->mc)->getMetaOne();
		$ilegalArr = explode('|', $ilegal['ilegal']);
		$ilegalArr = array_filter($ilegalArr);
		$replaceArr  = array();
		foreach ($ilegalArr as $k=>$v) {
			$replaceArr[$k] = $ilegal['ilegal_replace'];
		}
		foreach ($rs['data'] as $k => $v) {
			$rs['data'][$k]['content'] = str_replace($ilegalArr, $replaceArr, $v['content']);
		}
		return $rs;
	}
	
	public function needVcode() {
		$_t = $this->orm->fields('need_vcode')->from($this->mc)->getMetaOne();
		return @$_t['need_vcode']==1 ? true : false;
	}
	
	private function _messagelimit() {
		$_t = $this->orm->fields('*')->from($this->mc)->getMetaOne();
		$tlimit = $_t['intermission'];
		$this->tlimit = $tlimit;
		$onlyUser = $_t['only_user'];
		if($tlimit==0) {
			Cookie::getInstance()->set('NoCommentTimeLimit',true,0);
		}else{
			Cookie::getInstance()->set('NoCommentTimeLimit',false,0);
			Cookie::getInstance()->set('CommentLimitTime',$tlimit,$tlimit);
		}
		if($onlyUser==1){
			if(Session::getInstance()->get('LoginUser')!='') {
				$_t['CanComment'] = true;
			}else{
				$_t['CanComment'] = false;
			}
		}else{
			$_t['CanComment'] = true;
		}		
		return $_t;
	}
}

/**
 * 是否使用评论验证码
 */
function gt_cvcode() {
	return Core_Comment::getInstance()->needVcode();
}

/**
 * 写评论
 * @param int $info_id 信息id
 * @param string $user 评论人
 * @param string $content 评论内容
 * @param string $vcode 验证码
 */
function gt_wcomment($info_id,$user,$content,$vcode='') {
	return Core_Comment::getInstance()->write($info_id,$user,$content,$vcode);
}


function gt_comments($info_id,$page=1,$records=10) {
	return Core_Comment::getInstance()->read($info_id,$page,$records);
}