<?php

class Core_Information {
	private $info = '';
	private $ic = '';
	private $ir = '';
	private $ib = '';
	private $iblock = '';
	private $im = '';
	private $imf = '';
	private $tprefix = '';
	private $orm = null;
	private static $ins = null;
	
	public function __construct() {
		global $GEEORM;
		$t = _getTablePrefix();
		$this->orm = $GEEORM;
		$this->info   = $t.'geeinfo';
		$this->ic   = $t.'geeinchel';
		$this->ir   = $t.'geeinforeads';
		$this->ib	= $t.'geeinbl';
		$this->iblock	= $t.'geeinfoblock';
		$this->im	= $t.'geeinfomodel';
		$this->imf	= $t.'geeimfields';
		$this->tprefix = $t;
	}
	
	public static function getInstance() {
		if(!(self::$ins instanceof self)){			
			self::$ins = new self();
		}	
		return self::$ins;
	}
	
	public function getInfoByChel($chids, $urlfield, $page=1, $records=10, $title='',$usesort=true,$aparam='') {
		if(!is_array($chids)){
			$chids = intval($chids);
		}else{
			foreach ($chids as $k => $v) {
				$chids[$k] = intval($v);
			}
			$chids = implode(',', $chids);
		}
		if(!empty($chids)) {
			$ac = " AND b.channel_id IN ({$chids})";
		}else{
			$ac = "";
		}
		$bysort = $usesort ? 'a.sort ASC,' : '';
		$sql = "SELECT a.* FROM {$this->info} AS a,{$this->ic} AS b WHERE a.info_id=b.info_id AND a.status=1 AND a.title LIKE '%{$title}%'{$ac} GROUP BY a.info_id ORDER BY {$bysort}a.time_add DESC";
		//$aparam = !empty($title) ? '?kw='.$title.$aparam : $aparam;
		$rs = _pageFr($sql, $urlfield, $page, $records, $aparam);
		return $rs;
	}
	
	public function getInfo($info_id) {
		$info_id = intval($info_id);
		$rs = $this->orm->from($this->info)->where('info_id='.$info_id)->getMetaOne();
		//提取文章中的图片地址
		$p = '/<img\s+.*src=[\"\']?([^\"\'\s]*)/';
		$_imgs = array();
		$pics = array_filter(explode('|', $rs['img']));
		preg_match_all($p, @$rs['detail'], $_imgs);		
		$rs['img'] = array_merge($pics, $_imgs[1]);
		return $rs;
	}
	
	public function getPreNextInfo($info_id,$getpre=true) {
		$info_id = intval($info_id);
		if($getpre) {
			$sql = "SELECT * FROM {$this->info} WHERE info_id<{$info_id} AND status=1 AND ori_channel_id IN (SELECT ori_channel_id FROM {$this->info} WHERE info_id={$info_id}) ORDER BY sort ASC,info_id DESC LIMIT 1";
		}else{
			$sql = "SELECT * FROM {$this->info} WHERE info_id>{$info_id} AND status=1 AND ori_channel_id IN (SELECT ori_channel_id FROM {$this->info} WHERE info_id={$info_id}) ORDER BY sort ASC,info_id ASC LIMIT 1";
		}
		$info = $this->orm->queryOne($sql);
		if($info) {
			$info['url'] = _urlRoot().$info['uf'].'/'.$info['info_id'];
		}
		return $info;
	}
	
	public function addReadCount($info_id) {
		$info_id = intval($info_id);
		$sql = "UPDATE {$this->info} SET read_count=read_count+1 WHERE info_id={$info_id}";
		$this->orm->exec($sql);
	}
	
	
	public function addReadStatis($info_id) {
		$info_id = intval($info_id);
		$flag = "({$info_id}:";
		$cdate = date('Y-m-d');
		//$cdate = "2012-05-10";
		
		if($this->orm->from($this->ir)->where("someday='{$cdate}'")->count() > 0) {
			$sql = "SELECT LOCATE('{$flag}',`read_count`) FROM {$this->ir} WHERE `someday`='{$cdate}'";		
			$pos1 = $this->orm->queryOne($sql,MYSQL_NUM);
			$pos1 = $pos1[0];
			$update_sql = "UPDATE {$this->ir} SET `read_count`=CONCAT(`read_count`,'({$info_id}:1)') WHERE `someday`='{$cdate}'";
			if(intval($pos1) > 0) {
				$len = strlen($flag);
				$pos2 = $pos1 + $len;
				$sql = "SELECT SUBSTRING(`read_count`,{$pos2},LOCATE(')',`read_count`,{$pos1})-({$pos2})) FROM {$this->ir} WHERE `someday`='{$cdate}'";
				$_count = $this->orm->queryOne($sql,MYSQL_NUM);
				$_count = intval($_count[0]);
				$len2 = $pos2-1;
				$newcount = $_count+1;
				$update_sql = "UPDATE {$this->ir} SET `read_count`=REPLACE(`read_count`,CONCAT(SUBSTRING(`read_count`,1,{$len2}),{$_count}),CONCAT(SUBSTRING(`read_count`,1,{$len2}),{$newcount})) WHERE `someday`='{$cdate}'";
			}
			return $this->orm->exec($update_sql);
		}else{
			return _opDb($this->orm, array(
				'_table' => $this->ir,
				'someday' => $cdate,
				'read_count' => "({$info_id}:1)"
			), 'insert');
		}
	}
	
	
	public function getReadStatis($somedays) {
		foreach ($somedays as $k => $d) {
			$somedays[$k] = "'{$d}'";
		}
		$somedays = implode(',', $somedays);
		$rs = $this->orm->from($this->ir)->fields('read_count')->where("someday IN ({$somedays})")->getMeta();
		$result = array();
		foreach ($rs as $k=>$v) {
			$tmp = explode(')(', substr($v['read_count'], 1, -1));
			foreach ($tmp as $v2) {
				$tmp2 = explode(':', $v2);
				$id = $tmp2[0];
				$value = $tmp2[1];
				if(isset($result[$id])) {
					$result[$id] += intval($value);
				}else{
					$result[$id] = intval($value);
				}
			}
		}
		unset($rs);
		arsort($result);
		return $result; 
	}
	
	
	public function getInfoRank($somedays,$chel_ids=array(),$limit=0) {
		$limit = intval($limit);
		$cids = implode(',', $chel_ids);
		$id_count = $this->getReadStatis($somedays);
		$ids = implode(',', array_keys($id_count));
		$result = array();
		if(!empty($ids)) {
			$c = !empty($cids) ? " AND b.channel_id IN ({$cids})" : '';
			$lm = $limit>0 ? " LIMIT {$limit}" : '';
			$sql = "SELECT a.* FROM {$this->info} AS a,{$this->ic} AS b WHERE a.status=1 AND a.info_id=b.info_id AND a.info_id IN ({$ids}){$c} GROUP BY a.info_id ORDER BY FIELD(a.info_id,{$ids}){$lm}";
			$result = $this->orm->query($sql);
		}
		//提取文章中的图片地址
		$p = '/<img\s+.*src=[\"\']?([^\"\'\s]*)/';
		$_imgs = array();
		foreach ($result as $k=>$v) {
			$result[$k]['read'] = $id_count[$v['info_id']];
			$result[$k]['url'] = _urlRoot().$v['uf'].'/'.$v['info_id'];
			preg_match_all($p, @$v['detail'], $_imgs);		
			$pics = array_filter(explode('|', $result[$k]['img']));
			$result[$k]['img'] = array_merge($pics, $_imgs[1]);
			$result[$k]['content'] = _getClearText(@$v['detail']);
		}
		return $result;
	}
	
	public function getInfoTotalRank($chel_ids=array(),$limit=0) {
		$limit = intval($limit);
		$cids = implode(',', $chel_ids);
		$c = !empty($cids) ? " AND b.channel_id IN ({$cids})" : '';
		$lm = $limit>0 ? " LIMIT {$limit}" : '';
		$sql = "SELECT a.* FROM {$this->info} AS a,{$this->ic} AS b WHERE a.status=1 AND a.read_count>0 AND a.info_id=b.info_id{$c} GROUP BY a.info_id ORDER BY a.read_count DESC{$lm}";
		$result = $this->orm->query($sql);
		//提取文章中的图片地址
		$p = '/<img\s+.*src=[\"\']?([^\"\'\s]*)/';
		$_imgs = array();
		foreach ($result as $k=>$v) {
			$result[$k]['url'] = _urlRoot().$v['uf'].'/'.$v['info_id'];
			preg_match_all($p, @$v['detail'], $_imgs);		
			$pics = array_filter(explode('|', $result[$k]['img']));
			$result[$k]['img'] = array_merge($pics, $_imgs[1]);
			$result[$k]['content'] = _getClearText(@$v['detail']);
		}
		return $result;
	}
	
	public function getBlockInfos($ib_id, $urlfield='', $page=1, $records=10) {
		$ib_id = intval($ib_id);
		$sql = "SELECT a.*,c.ib_name FROM {$this->info} AS a, {$this->ib} AS b, {$this->iblock} AS c WHERE a.info_id=b.info_id AND a.status=1 AND b.ib_id=c.ib_id AND c.ib_id={$ib_id} ORDER BY a.sort ASC,a.time_add DESC";
		$rs = _pageFr($sql, $urlfield, $page, $records,'');
		if(isset($rs['data'][0]['ib_name'])) {
			$rs['ib_name'] = $rs['data'][0]['ib_name'];
		}
		return $rs;		
	}
	
	public function getImDataByInfo($info_id, $im_id) {
		$info_id = intval($info_id);
		$im_id = intval($im_id);
		$im_table = $this->orm->from($this->im)->where('id='.$im_id)->fields('table_name')->getMetaOne();
		if(!$im_table['table_name']) return array();
		$im_table = $this->tprefix.$im_table['table_name'];
		
		$ff = $this->orm->from($this->imf)->where('im_id='.$im_id)->fields('field_name,flag')->order('sort ASC')->getMeta();
		$fs = $flag = array();
		foreach ($ff as $k => $v) {
			$fs[] = $v['field_name'];
			$flag[] = $v['flag'];
		}
		$fs = implode(',', $fs);		
		$data = $this->orm->from($im_table)->fields($fs)->where('info_id='.$info_id)->getMetaOne(); 
		$rs = array();
		$i = 0;
		if(is_array($data)) {
			foreach ($data as $k=>$v) {
				$rs[$k]['name'] = $flag[$i++];
				$rs[$k]['value'] = $v;			
			}
		}
		return $rs;
	}
	
}


/**
 * 分页读取信息
 * @param mixed $chids 栏目id/栏目id数组
 * @param string $urlfield URL字段
 * @param string $keyword 关键字
 * @param int $page 当前页
 * @param int $records 每页显示数量
 */
function gt_infos($chids,$urlfield, $keyword='', $page=1, $records=10,$aparam='') {
	return Core_Information::getInstance()->getInfoByChel($chids, $urlfield, $page, $records, $keyword,true,$aparam);
}

/**
 * 分页读取最新信息
 * @param mixed $chids 栏目id/栏目id数组
 * @param string $urlfield URL字段
 * @param string $keyword 关键字
 * @param int $page 当前页
 * @param int $records 每页显示数量
 */
function gt_newlyis($chids,$urlfield, $keyword='', $page=1, $records=10) {
	return Core_Information::getInstance()->getInfoByChel($chids, $urlfield, $page, $records, $keyword, false);
}

/**
 * 读取信息详情
 * @param int $info_id 信息id
 */
function gt_info($info_id) {
	return Core_Information::getInstance()->getInfo($info_id);
}

/**
 * 分页显示由后台指定分页的信息
 * @param int $info_id 信息id
 * @param int $page 当前页
 */
function gt_pinfo($info_id,$page=1) {
	$page = intval($page);
	$info = Core_Information::getInstance()->getInfo($info_id);
	if(@$info===false) {
		//找不到文章数据则跳转404页面
		if(!_run404()){
			return false;
		}else{
			exit;	
		}
	}	
	//分页符
	$p = '/<hr style="page-break-after:always;" class="ke-pagebreak" \/>|<hr class="ke-pagebreak" style="page-break-after:always;" \/>/';
	$arr = preg_split($p, $info['detail']);
	$rs = array('title'=>$info['title'],'data'=>'','pagebar'=>'');
	$p = PaginationArray::factory($arr);
	$p->Page = $page; 
	$p->Records = 1;	
	$pagecount = $p->getPageCount();
	if($page>$pagecount || $page<1) {
		//如果页码不合法则跳转到404页面
		if(!_run404()){
			return false;
		}else{
			exit;	
		}
	}
	$rs['data'] = $p->get();
	$ps = PaginationStyle::factory($p->Page, $pagecount);
	$ps->RecordCount = $p->getRecordCount();
	$ps->setLink($info_id.'-%s');	
	if($ps->RecordCount > $p->Records) {
		$rs['pagebar'] = $ps->getTwo();
	}		
	$rs['data'] = @$rs['data'][0];
	return $rs;	
}

/**
 * 读取上一条信息
 * @param int $info_id 信息id 
 */
function gt_preinfo($info_id) {
	return Core_Information::getInstance()->getPreNextInfo($info_id,true);
}

/**
 * 读取下一条信息
 * @param int $info_id 信息id 
 */
function gt_nextinfo($info_id) {
	return Core_Information::getInstance()->getPreNextInfo($info_id,false);
}

/**
 * 递增信息阅读次数
 * @param int $info_id 信息id 
 */
function gt_addrc($info_id) {
	Core_Information::getInstance()->addReadCount($info_id);
	Core_Information::getInstance()->addReadStatis($info_id);
}

/**
 * 根据日期读取信息阅读排行
 * @param array $somedays 日期数组.例如 array('2012-05-09','2012-5-10')
 * @param array $chel_ids 栏目id数组.例如 array(1,3)
 * @param int $limit 限制数量
 */
function gt_readstatis($somedays,$chel_ids=array(),$limit=0) {
	return Core_Information::getInstance()->getInfoRank($somedays,$chel_ids,$limit);
}

/**
 * 读取当天信息阅读排行
 * @param array $chel_ids 栏目id数组.例如 array(1,3)
 * @param int $limit 限制数量
 */
function gt_idr($chel_ids=array(),$limit=10) {
	return Core_Information::getInstance()->getInfoRank(array(date('Y-m-d')),$chel_ids,$limit);
}

/**
 * 读取当周信息阅读排行
 * @param array $chel_ids 栏目id数组.例如 array(1,3)
 * @param int $limit 限制数量
 */
function gt_iwr($chel_ids=array(),$limit=10) {
	$_t = time();	
	$wd = intval(date('w',$_t));
	$wd = $wd==0 ? 7 : $wd;
	$darr = array(date('Y-m-d',$_t));
	for ($i=1; $i<$wd; $i++) {
		$darr[] = date('Y-m-d',strtotime("-{$i} day",$_t));
	}
	for ($i=$wd,$j=1; $i<7; $i++,$j++) {
		$darr[] = date('Y-m-d',strtotime("+{$j} day",$_t));
	}
	sort($darr);
	return Core_Information::getInstance()->getInfoRank($darr,$chel_ids,$limit);
}

/**
 * 读取当月信息阅读排行
 * @param array $chel_ids 栏目id数组.例如 array(1,3)
 * @param int $limit 限制数量
 */
function gt_imr($chel_ids=array(),$limit=10) {
	$y = date('Y');
	$m = date('n');
	$darr = array();
	for ($i = 1; $i <= 31; $i++) {
		$darr[] = "{$y}-{$m}-{$i}";
	}
	return Core_Information::getInstance()->getInfoRank($darr,$chel_ids,$limit);
}

/**
 * 读取信息总阅读排行
 * @param array $chel_ids 栏目id数组.例如 array(1,3)
 * @param int $limit 限制数量
 */
function gt_itr($chel_ids=array(),$limit=10) {
	return Core_Information::getInstance()->getInfoTotalRank($chel_ids, $limit);
}

/**
 * 分页信息区块关联信息
 * @param int $ib_id 信息区块id
 * @param string $urlfield URL字段
 * @param int $page 当前页
 * @param int $records 每页显示数量
 */
function gt_ibs($ib_id, $urlfield='', $page=1, $records=10) {
	return Core_Information::getInstance()->getBlockInfos($ib_id, $urlfield, $page, $records);
}

/**
 * 读取指定信息的扩展数据
 * @param int $info_id 信息id
 * @param int $im_id 信息模型id
 */
function gt_imdata($info_id, $im_id) {
	return Core_Information::getInstance()->getImDataByInfo($info_id, $im_id);
}