<?php 
	
class Core_User {
	private $orm = null;
	private $u   = 'geeuser';
	private $uc  = 'geeuserctrl';
	
	public function __construct() {
		global $GEEORM;
		$this->orm = $GEEORM;
		$this->u   = _getTablePrefix().'geeuser';
		$this->uc  = _getTablePrefix().'geeuserctrl';
	}
	
	public function register($name,$password,$captcha='') {
		$ok     = 1;
		$ctrl   = $this->orm->from($this->uc)->getMetaOne();
		$verify = intval(!(bool)$ctrl['need_verify']);
		$capt   = (bool)$ctrl['need_captcha'];
		$cap    = Session::getInstance()->get('Captcha');
		if($name=='') {
			//名称为空
			$ok = -1;
		}else if ($password=='') {
			//密码为空
			$ok = -2;
		}else if ($capt && $cap!=$captcha) {
			//验证码错误
			$ok = -3;
		}else{
			//$name = Geeleaf_func_m_escape($name);
			//$password = Geeleaf_func_m_escape($password);
			if(!_opDb($this->orm, array(
				'_table' => $this->u,
				'name' => $name,
				'password' => Geeleaf_func_crypt($password, _getSalt(),true),
				'status' => $verify
			), 'insert')){
				$ok = -4; //会员名已存在
			}
		}
		return $ok;
	}
	
	public function login($name,$password,$captcha='') {
		$ok   = 1;
		$ctrl = $this->orm->from($this->uc)->getMetaOne();
		$capt = (bool)$ctrl['need_captcha_login'];
		$cap  = Session::getInstance()->get('Captcha');
		if($name=='') {
			//名称为空
			$ok = -1;
		}else if ($password=='') {
			//密码为空
			$ok = -2;
		}else if ($capt && $cap!=$captcha) {
			//验证码错误
			$ok = -3;
		}else{
			$name = Geeleaf_func_m_escape($name);
			$password = Geeleaf_func_crypt($password, _getSalt(), true);
			
			$c1 = "name='{$name}' AND password='{$password}' AND status=0";
			$c2 = "name='{$name}' AND password='{$password}' AND status=1";
			if ($this->orm->from($this->u)->where($c1)->count() > 0) {
				$ok = -4; //该会员未通过审核
			}else if ($this->orm->from($this->u)->where($c2)->count()==0) {
				$ok = -5; //会员和密码不匹配
			}else{
				$adm = $this->orm->from($this->u)->where($c2)->getMetaOne();
				if ($adm) {
					Session::getInstance()->set('LoginUser', $adm['name']);
					Session::getInstance()->set('LoginId', $adm['id']);
				}				
			}
		}
		return $ok;
	}

	public function changePw($oldpw,$newpw) {
		$ok    = false;
		$oldpw = Geeleaf_func_crypt($oldpw, _getSalt(), true);
		$newpw = Geeleaf_func_crypt($newpw, _getSalt(), true);
		$id    = intval(Session::getInstance()->get('LoginId'));
		$c     = "id={$id} AND password='{$oldpw}'";
		if ($this->orm->from($this->u)->where($c)->count() > 0) {
			_opDb($this->orm, array(
				'_table' => $this->u,
				'_where' => $c,
				'password' => $newpw
			), 'update');
			$ok = true;
		}
		return $ok;
	}
}

function cUserRegister($name,$password,$captcha='') {
	$u = new Core_User();
	return $u->register($name, $password, $captcha);
}

function cUserLogin($name,$password,$captcha='') {
	$u = new Core_User();
	return $u->login($name, $password, $captcha);
}

function cUserChangePw($oldpw,$newpw) {
	$u = new Core_User();
	return $u->changePw($oldpw,$newpw);
}

?>