<?php

//打印视图
function _printView($tfile,$vars=array(),$show=true){
	$temPlate = new TemplateOne();
	$temPlate->setTemplate($tfile);
	if(is_array($vars) && !empty($vars)) {
		$temPlate->assign($vars);
	}
	return $temPlate->render($show);
}

//读取../config/table.php(后台数据表配置文件)
function _getTableConf() {
	$f = dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'table.php';
	$mctable = $tmp = array();	
	if(is_readable($f)) {
		$tmp = require $f;
	}
	if(count($tmp) > 0) {
		foreach ($tmp as $k => $v) {
			if($k!='table_prefix' && $k!='rbac_admin') {
				$v = $tmp['table_prefix'].$v;
			}else if ($k=='rbac_admin') {
				$v['table'] = $tmp['table_prefix'].$v['table'];
			}
			$mctable[$k] = $v;
		}
	}	
	return $mctable;
}

//读取../config/database.php(后台数据库配置文件)
function _getDbConf() {
	$f = dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'database.php';
	$result = $tmp = array();
	if(is_readable($f)) {
		$tmp = require $f;
	}
	if(count($tmp)>0) {
		$result = $tmp;
	}
	return $result;
}

//获取数据表前缀
function _getTablePrefix() {
	$_prefix = '';
	$_tconf = _getTableConf();	
	if(isset($_tconf['table_prefix'])){
		$_prefix = $_tconf['table_prefix'];
	}
	$_tconf = NULL;
	return $_prefix;
}

/*
 * 添加或修改数据
 * array(
 * 	'_table' => '',
 * 	'_where' => '',
 * )
 */
function _opDb($orm,$arr,$op='insert',$returninsertid=FALSE) {
	$orm->table = $arr['_table'];
	foreach ($arr as $k=>$v) {
		if ($k!='_where' && $k!='_table') {
			$orm->$k = $v;
		}
	}
	switch ($op) {
		case 'insert':
			if($returninsertid){
				$orm->insert();
				return $orm->getInsertId();
			}else{
				return $orm->insert();
			}			
		break;
		case 'update':
			$w = isset($arr['_where']) && trim($arr['_where'])!="" ? $arr['_where'] : 1;
			return $orm->where($w)->update();
		break;
		default:
			if($returninsertid){
				$orm->insert();
				return $orm->getInsertId();
			}else{
				return $orm->insert();
			}
		break;
	}
}

//返回当前网站主题
function _getTheme() {
	global $GEEORM;	
	$t = '';
	$f = GEELEAF_ROOT.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'theme.php';
	if (is_readable($f)) {
		$t = @include $f;
	}
	if (!(bool)$t) {
		$table = _getTablePrefix().'geethemes';
		$theme = $GEEORM->from($table)->getMetaOne();
		if(isset($theme['themes']) && !empty($theme['themes'])) {
			$t = $theme['themes'];
		}else{
			$t = 'default';
		}
	}
	return $t;	
}

//返回服务器是否支持URL重写
function _getRewritable() {
	global $GEEORM;	
	$t = '';
	$f = GEELEAF_ROOT.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'rewritable.php';
	if (is_readable($f)) {
		$t = @include $f;
	}
	if (!(bool)$t) {
		$table = _getTablePrefix().'geethemes';
		$theme = $GEEORM->from($table)->getMetaOne();
		if(isset($theme['rewritable'])) {
			$t = $theme['rewritable'];
		}else{
			$t = 1;
		}
	}
	return intval($t);	
}

//返回当前网站404文件
function _get404($full=false) {
	global $GEEORM;	
	$t = '';
	$f = GEELEAF_ROOT.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'404.php';
	if (is_readable($f)) {
		$t = @include $f;
	}
	if (!(bool)$t) {
		$table = _getTablePrefix().'geethemes';
		$theme = $GEEORM->from($table)->getMetaOne();
		if(isset($theme['page404']) && !empty($theme['page404'])) {
			$t = $theme['page404'];
		}else{
			$t = '1.html';
		}
	}
	return $full ? GEELEAF_ROOT.DIRECTORY_SEPARATOR.'geemedia'.DIRECTORY_SEPARATOR.'404'.DIRECTORY_SEPARATOR.$t : $t;	
}

//执行当前网站404文件
function _run404() {
	$f =  _get404(true);
	if(is_readable($f)) {
		require $f;
		return true;
	}else{
		return false;
	}
}

//获取栏目数据表
function _getChannelTables() {
	$prefix = _getTablePrefix();
	return array(
		0 => $prefix.'geechannels',
		1 => $prefix.'geechannels2',
	);
}

//获取文章数据表
function _getArticleTables() {
	$prefix = _getTablePrefix();
	return array(
		0 => $prefix.'geearti',
		1 => $prefix.'geearti2',
	);
}

//导入模块API
function _loadModuleFunctions() {
	$g_path = GEELEAF_ROOT.DIRECTORY_SEPARATOR.'global'.DIRECTORY_SEPARATOR;
	$d = dir($g_path);
	while (false !== ($f = $d->read())) {
		$t = $g_path.$f;
		if(is_file($t) && is_readable($t) && $f!='functions.php' && $f!='variables.php') {
			require $t;
		}
	}
	$_path = GEECMS_THEMES._getTheme().DIRECTORY_SEPARATOR.'_api'.DIRECTORY_SEPARATOR;
	$d = dir($_path);
	while (false !== ($f = $d->read())) {		
		$t = $_path.$f;		
		if(is_file($t) && is_readable($t)) {
			require $t;
		}
	}
}

//跳转到安装向导
function _gotoInstall() {	
	if(!is_file(GEELEAF_ROOT.'/config/installed.lock.php')) {
		Geeleaf_func_redirect(GEELEAF_URIROOT.'install');
	}
}

//读取页面缓存
function _readPageCache($cf,$vars=array()) {
	$cv = array();
	if(is_readable($cf.'_channelvars.php')) {
		$cv = require $cf.'_channelvars.php';
	}	
	@extract(array_merge($vars,$cv), EXTR_OVERWRITE);	
	require $cf;
}

//写入页面缓存
function _writePageCache($cf,$content,$channelinfo='') {	
	$ok = false;
	if (is_writable(GEELEAF_ROOT.'/cache/pages/')) {
		$ok = (bool)file_put_contents($cf, $content);
		if(!empty($channelinfo)) {
			$ok = (bool)file_put_contents($cf.'_channelvars.php', $channelinfo);
		}
	}	
	return $ok;	
}

//获取不页面缓存的数组
function _getNoPageCache() {
	$arr = array();
	$t = _getTheme();
	$c = GEELEAF_ROOT.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR;
	$cname = $t.'_nocache';
	$nocf = $c.'pages'.DIRECTORY_SEPARATOR.$cname;
	if (is_readable($nocf)) {
		$arr = unserialize(file_get_contents($nocf));
	}else{			
		$d = GEELEAF_ROOT.DIRECTORY_SEPARATOR.'themes'.DIRECTORY_SEPARATOR.$t.DIRECTORY_SEPARATOR.'_nocache'.DIRECTORY_SEPARATOR;
		if(($handle = @opendir($d))==true){
			while (false !== ($file = readdir($handle))) {
		        if ($file!='.' && $file!='..') {
		        	$farr = explode('.', $file);
		        	$arr['NOCACHE_'.$farr[0]] = @file_get_contents($d.$file);
		        }
		    }	
		}
		@file_put_contents($nocf, serialize($arr));	
	}	
	return $arr;
}

//返回前页
function _goReferer() {
	if (@isset($_SERVER['HTTP_REFERER'])) {
		Geeleaf_func_redirect($_SERVER['HTTP_REFERER']);
	}
	return false;
}

//返回首页
function _goWebIndex() {
	Geeleaf_func_redirect(_urlRoot());
}

//加解密密匙
function _getSalt() {
	$f = GEELEAF_ROOT.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'salt.php';
	$s = '';
	if(is_readable($f)){
		$s = require $f;
	}else{
		$s = 'GeeWEB';
	}	
	return $s;
}

/**
 * 删除指定的$_POST变量
 * @param array $arr 变量名数组.array('username','userpw')
 */
function _deletePostVars($arr=array()) {
	foreach ($arr as $v) {
		unset($_POST[$v]);
	}
}

/**
 * 删除指定的$_GET变量
 * @param array $arr 变量名数组.array('username','userpw')
 */
function _deleteGetVars($arr=array()) {
	foreach ($arr as $v) {
		unset($_GET[$v]);
	}
}

/**
 * 删除指定的$_COOKIE变量
 * @param array $arr 变量名数组.array('username','userpw')
 */
function _deleteCookieVars($arr=array()) {
	foreach ($arr as $v) {
		unset($_COOKIE[$v]);
	}
}

/**
 * 删除指定的$_SESSION变量
 * @param array $arr 变量名数组.array('username','userpw')
 */
function _deleteSessionVars($arr=array()) {
	foreach ($arr as $v) {
		Session::getInstance()->delete($v);
	}
}

/**
 * 数据分页显示
 * @param string 数据表名
 * @param int $curpage 当前页
 * @param int $records 每页显示的记录数
 * @param mixed $where 查询条件
 * @param mixed $join 跨表名
 * @param string $appendparams 附加的GET参数
 */
function _pagination($table,$curpage=1,$records=10,$where='',$join='',$appendparams='',$select='',$useinfront=false,$orderby='',$urlfield='') {
	$pm = PaginationMysql::factory($table,'',_getDbConf());	
	if($select!='') {
		$pm->select($select);
	}
	if($where!='') {
		$pm->where($where);
	}
	if($join!='') {
		$pm->join($join);
	}
	if($orderby!='') {
		$pm->order($orderby);
	}
	$pm->Page = $curpage;
	$pm->Records = $records;
	$_data = $pm->get();

	//提取文章中的图片地址
	$p = '/<img\s+.*src=[\"\']?([^\"\'\s]*)/';
	$_imgs = array();
	foreach ($_data as $k=>$v) {
		preg_match_all($p, @$v['content'], $_imgs);
		$_data[$k]['article_imgs'] = $_imgs[1];
	}		
	$ps = new PaginationStyle();
	$ps->Page = $curpage;
	$ps->PageCount = $pm->getPageCount();
	$ps->RecordCount = $pm->getRecordCount();	
	if (!$useinfront) {
		//后台使用
		$ps->setLink('?page=%s'.$appendparams);
	}else{
		//前台使用
		if(empty($urlfield)) {
			$urifield = !@empty($_data[0]['urlfield']) ? @$_data[0]['urlfield'] : @$_data[0]['channel_id'];
		}else{
			$urifield = $urlfield;
		}
		$ps->setLink($urifield.'-%s'.$appendparams);
	}	
	$_pagebar = $ps->getTwo(10,true);
	if($ps->RecordCount <= $records) {
		$_pagebar = '';
	}		
	return array(
		'Data' => $_data,
		'PageBar' => $_pagebar,
		'PageCount' => $ps->PageCount,
		'RecordCount' => $ps->RecordCount,
	);
}

//获取$_SESSION变量
function _sessionVar($name) {
	return Session::getInstance()->get($name);
}

//上传图片.返回成功上传的文件名数组
function _uploadImages($dir='') {
	global $_upsavedir;
	$_upsavedir = empty($dir) ? 'upload/image/' : 'upload/'.$dir.'/';
	function __rename($name) {
		$tExt = explode('.',$name);
		$tExt = '.'.$tExt[count($tExt)-1];
		return md5(time().rand()).$tExt;
	}	
	function __getSuccessfulFiles() {
		global $_upsavedir;
		static $arr = null;
		static $i = 0;
		if($i++ <= 0){
			$arr = func_get_arg(0);
			$tarr = array();
			if (@is_array($arr['NewName'])) {
				foreach ($arr['NewName'] as $k=>$v) {
					$ti = $arr['Index'][$k];
					$tarr[$ti] = GEELEAF_URIROOT.$_upsavedir.$v;
				}
			}			
			$arr = $tarr;
		}else{
			return $arr;
		}	
	}		
	function __upok($arr1,$arr2) {
		__getSuccessfulFiles($arr1);	
	}		
	UpLoad::factory(GEELEAF_ROOT.'/'.$_upsavedir, array(
		'png' => 0,
		'gif' => 0,
		'jpg' => 0,
		'jpeg' => 0,
		'bmp' => 0,
		'ico' => 0,
	))->load('__rename',null,null,'__upok');	
	return __getSuccessfulFiles();
}

//设置网站时区
function _setTimeZone() {
	 $f = GEELEAF_ROOT.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'timezone.php';
	 $tz = @include $f;
	 if($tz) {
	 	@date_default_timezone_set($tz);
	 }else{
	 	@date_default_timezone_set('Asia/Shanghai');
	 }	 
}

//获取当前主题的栏目模板关联表
function _getThemeTplTable() {
	return _getTablePrefix().'gee'._getTheme().'tpls';
} 

//返回去除HTML、空格等的字符串
function _getClearText($string,$sublen=0,$rspace=true){
	$sublen = intval($sublen);
	$string = strip_tags($string);
	$string = preg_replace ('/\n\r/is', '', $string);
	if($rspace) {
		$string = preg_replace ('/[\n\t\r]/is', '', $string);
		$string = preg_replace ('/&nbsp;/is', '', $string);
	}
	preg_match_all("/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/", $string, $t_string);   
	$string = !empty($sublen) ? join('', array_slice($t_string[0], 0, $sublen)) : join('',$t_string[0]);
	return $string;
}

//
function _pageFr($sql, $urlfield='', $page=1, $records=10, $appendparams='',$styletwo=true) {
	global $GEEORM;
	$rs = array();
	$pm = new PaginationMysqlExt($GEEORM);
	$pm->Page = $page;
	$pm->Records = $records;
	$pm->query($sql);
	$ps = new PaginationStyle();
	$ps->Page = $page;
	$ps->PageCount = $pm->getPageCount();
	$ps->RecordCount = $pm->getRecordCount();
	$ps->setLink($urlfield.'-%s'.$appendparams);
	if($styletwo) {
		$_pagebar = $ps->getTwo(10,true);
	}else{
		$_pagebar = $ps->getOne(100,100);
	}
	if($ps->RecordCount <= $records) {
		$_pagebar = '';
	}
	
	$_data = $pm->get();
	//提取文章中的图片地址
	$p = '/<img\s+.*src=[\"\']?([^\"\'\s]*)/';
	$_imgs = array();
	foreach ($_data as $k=>$v) {
		$pics = array_filter(explode('|', @$_data[$k]['img']));
		preg_match_all($p, @$v['detail'], $_imgs);		
		$_data[$k]['img'] = array_merge($pics, $_imgs[1]);
		$_data[$k]['url'] = _urlRoot().@$v['uf'].'/'.$v['info_id'];
		if(@$v['detail']) $_data[$k]['content'] = _getClearText($v['detail']);
	}	
	$rs['data'] = $_data;
	$rs['pagebar'] = $_pagebar;
	$rs['pagecount'] = $ps->PageCount;
	$rs['recordcount'] = $ps->RecordCount;
	$rs['page'] = $page;
	return $rs;
}

function _urlRoot() {
	$urlroot = GEELEAF_URLROOT;
	if(!_getRewritable()) {
		if(stripos($urlroot, 'index.php/')===false) {
			$urlroot .= 'index.php/';
		}
	}	
	return $urlroot;
}