<?php 
	$step = '';
	require 'h.php';
	is_file('../config/installed.lock.php') && _goWebIndex();
	
	$var_arr = array(
		'Step' => $step,
	);

	switch ($step) {
		case 'checkenv' :
			
			$ServerInfo = igetServerInfo();	
			//是否合法的PHP版本
			$IsSuitPHPVersion = version_compare($ServerInfo['php_version'], '5.2.0', '>=');
			
			//检测admin/_base/databackup是否可读
			$CanReadAdmin = idirReadable('admin/_base/databackup');
			//检测config是否可读
			$CanReadConfig = idirReadable('config');
			//检测global是否可读
			$CanReadGlobal = true; //idirReadable('global')
			//检测upload是否可读
			$CanReadUpload = idirReadable('upload');
			//检测themes是否可读
			$CanReadThemes = idirReadable('themes');
			//检测log是否可读
			$CanReadLog = idirReadable('log');	
			//检测cache是否可读
			$CanReadCache = idirReadable('cache');
			



			$CanReadCachePages = idirReadable('cache/pages');
			$CanReadUploadEditor = idirReadable('upload/editor');
			$CanReadUploadImage = idirReadable('upload/image');
			$CanReadUploadImageChannel = idirReadable('upload/image/channel');
			$CanReadUploadImageProduct = idirReadable('upload/image/information');
			
			//检测admin/_base/databackup是否可写
			$CanWriteAdmin = idirWritable('admin/_base/databackup');
			//检测config是否可写
			$CanWriteConfig = idirWritable('config');
			//检测global是否可写
			$CanWriteGlobal = true; //idirWritable('global')
			//检测upload是否可写
			$CanWriteUpload = idirWritable('upload');
			//检测themes是否可写
			$CanWriteThemes = idirWritable('themes');
			//检测log是否可写
			$CanWriteLog = idirWritable('log');
			//检测cache是否可写
			$CanWriteCache = idirWritable('cache');
			
			$CanWriteCachePages = idirWritable('cache/pages');
			$CanWriteUploadEditor = idirWritable('upload/editor');
			$CanWriteUploadImage = idirWritable('upload/image');
			$CanWriteUploadChannel = idirWritable('upload/image/channel');
			$CanWriteUploadProduct = idirWritable('upload/image/information');
						
			//判断是否所有指定的目录都可读
			$AllR = $CanReadConfig && $CanReadGlobal && $CanReadUpload && $CanReadThemes && $CanReadLog && $CanReadCache && $CanReadAdmin && $CanReadCachePages && $CanReadUploadEditor && $CanReadUploadImage && $CanReadUploadImageChannel && $CanReadUploadImageProduct;
			//判断是否所有指定的目录都可写
			$AllW = $CanWriteConfig && $CanWriteGlobal && $CanWriteUpload && $CanWriteThemes && $CanWriteLog && $CanWriteCache && $CanWriteAdmin && $CanWriteCachePages && $CanWriteUploadEditor && $CanWriteUploadImage && $CanWriteUploadChannel && $CanWriteUploadProduct;
				
						

			$var_arr = array(
				'Step' => $step,			
				'ServerName' => $ServerInfo['server_name'],
				'ServerVersion' => $ServerInfo['server_version'],
				'PHPVersion' => $ServerInfo['php_version'],
				'MySQLVersion' => $ServerInfo['mysql_version'],
				'IsSuitPHPVersion' => $IsSuitPHPVersion,	
				'CanReadAdmin' => $CanReadAdmin,			
				'CanReadConfig' => $CanReadConfig,
				'CanReadGlobal' => $CanReadGlobal,
				'CanReadUpload' => $CanReadUpload,
				'CanReadThemes' => $CanReadThemes,
				'CanReadLog' => $CanReadLog,
				'CanReadCache' => $CanReadCache,	
				'CanWriteAdmin' => $CanWriteAdmin,
				'CanWriteConfig' => $CanWriteConfig,
				'CanWriteGlobal' => $CanWriteGlobal,
				'CanWriteUpload' => $CanWriteUpload,
				'CanWriteThemes' => $CanWriteThemes,
				'CanWriteLog' => $CanWriteLog,
				'CanWriteCache' => $CanWriteCache,
			
				'CanReadCachePages' => $CanReadCachePages,
				'CanReadUploadEditor' => $CanReadUploadEditor,
				'CanReadUploadImage' => $CanReadUploadImage,
				'CanReadUploadImageChannel' => $CanReadUploadImageChannel,
				'CanReadUploadImageProduct' => $CanReadUploadImageProduct,
				'CanWriteCachePages' => $CanWriteCachePages,
				'CanWriteUploadEditor' => $CanWriteUploadEditor,
				'CanWriteUploadImage' => $CanWriteUploadImage,
				'CanWriteUploadChannel' => $CanWriteUploadChannel,
				'CanWriteUploadProduct' => $CanWriteUploadProduct,
				
				'AllR' => $AllR,
				'AllW' => $AllW,
			);
			break;		
		case 'install' :	
			$_salt = trim($salt)!='' ? trim($salt) : 'geeweb'.time().rand();		
			$var_arr = array(
				'Step' => $step,
				'AdminName' => $adminname,
				'AdminPw' => $adminpw,
				'Salt' => $_salt,
				'TimeZone' => $timezone
			);			
			break;
		case 'dbset' :
			$var_arr = array(
				'Step' => $step,
				'TimeZoneList' => timezone_identifiers_list()
			);		
		default:
			;
		break;
	}
	
	$tpl = new TemplateOne();	
	$tpl->assign($var_arr);	
	$tpl->setTemplate('tpl.php');
	$tpl->render();	
?>