<?php
/**
 * 基准测试类.可测试代码段的内存占用和运行时间
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-10
 * @package      Geeleaf
 * @final
 */
  
final class Benchmark {
	private static $becnmarking = NULL;	
	
	public static function start($class,$method,$file) {
		if(!isset(self::$becnmarking[$class]) && !isset(self::$becnmarking[$class][$method])){
			self::$becnmarking[$class]= self::$becnmarking[$class][$method] = array();
		}	
		$mtime = microtime(); 
     	$mtime = explode(" ", $mtime); 
     	$_timebegin = $mtime[1] + $mtime[0];
		self::$becnmarking[$class][$method] = array(
			'Class' => $class,
			'Function' => $method,
			'File' => $file,
			//'TimeBegin' => microtime(TRUE),
			'TimeBegin' => $_timebegin,
			'MemoryBegin' => function_exists('memory_get_usage') ? memory_get_usage(FALSE) : 0,
		);	
	}
	
	public static function stop($class,$method) {
		if(!isset(self::$becnmarking[$class]) && !isset(self::$becnmarking[$class][$method])){
			throw new GeeLeafException(1015);			
		}
		$mtime = microtime(); 
     	$mtime = explode(" ", $mtime); 
     	$_timestop = $mtime[1] + $mtime[0];
		$_stopMemoryUsage = (function_exists('memory_get_usage')?memory_get_usage(FALSE):0);
		self::$becnmarking[$class][$method]['TimeUsage']     = $_timestop-@self::$becnmarking[$class][$method]['TimeBegin'];
		self::$becnmarking[$class][$method]['MemoryUsage_b'] = $_stopMemoryUsage-@self::$becnmarking[$class][$method]['MemoryBegin'];
		self::$becnmarking[$class][$method]['MemoryUsage_k'] = self::$becnmarking[$class][$method]['MemoryUsage_b'] / 1000;
		self::$becnmarking[$class][$method]['MemoryUsage_m'] = self::$becnmarking[$class][$method]['MemoryUsage_k'] / 1000;
		unset(self::$becnmarking[$class][$method]['TimeBegin']);
		unset(self::$becnmarking[$class][$method]['MemoryBegin']);	
	}

	public static function getResult($class='',$method='') {
		$_Result = NULL;
		if(!empty($class) && !empty($method)){
			$_Result = self::$becnmarking[$class][$method];
		}else if(!empty($class)){
			$_Result = self::$becnmarking[$class];
		}else{
			$_Result = self::$becnmarking;
		}
		return $_Result;
	}
}
