<?php
/**
 * 客户端输入处理类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-8
 * @package      Geeleaf
 * @final
 */
  
final class Client{
	private static $instance;
	private static $xss_filter = FALSE;	
	
	private function __construct() {}
	private function __clone() {}

	public static function getInstance() {
		if(!(self::$instance instanceof self)){			
			self::$instance = new self();
		}	
		return self::$instance;
	}

	public function get($key='',$cleanXss=TRUE){
		return self::_get_post_cookie_server($_GET,$key,$cleanXss);
	}

	public function post($key='',$cleanXss=TRUE){
		return self::_get_post_cookie_server($_POST,$key,$cleanXss);
	}

	public function cookie($key='',$cleanXss=TRUE){
		return self::_get_post_cookie_server($_COOKIE,$key,$cleanXss);
	}
		
	public static function cleanInput(){
		if(self::$xss_filter===NULL){
			$_GlobalSetting = Config::load('global');
			if(isset($_GlobalSetting['Xss_Filter'])){
				self::$xss_filter = $_GlobalSetting['Xss_Filter'];
			}
		}		
		$_GET    = self::_clean($_GET);
		$_POST   = self::_clean($_POST);
		$_COOKIE = self::_clean($_COOKIE);
		$_SERVER = self::_clean($_SERVER);			
		if (is_array($_GET)){
			foreach ($_GET as $key => $val){
				$_GET[self::_clean_input_keys($key)] = self::_clean_input_data($val);
			}
		}else{
			$_GET = array();
		}
		if (is_array($_POST)){
			foreach ($_POST as $key => $val){
				$_POST[self::_clean_input_keys($key)] = self::_clean_input_data($val);
			}
		}else{
			$_POST = array();
		}		
		if (is_array($_REQUEST)){
			foreach ($_REQUEST as $key => $val){
				$_REQUEST[self::_clean_input_keys($key)] = self::_clean_input_data($val);
			}
		}else{
			$_REQUEST = array();
		}	
		if (is_array($_COOKIE)){
			foreach ($_COOKIE as $key => $val){
				if ($key == '$Version' OR $key == '$Path' OR $key == '$Domain')
					continue;
				$_COOKIE[self::_clean_input_keys($key)] = self::_clean_input_data($val);
			}
		}else{
			$_COOKIE = array();
		}	
	}

	public static function cleanXss($data){
		if (is_array($data)) {
			foreach ($data as $k => $v) {
				$data[$k] = self::cleanXss($v);
			}
			return $data;
		}
		if (trim($data) === ''){
			return $data;
		}
		$data = str_replace(array('&amp;','&lt;','&gt;'), array('&amp;amp;','&amp;lt;','&amp;gt;'), $data);
		$data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
		$data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
		$data = html_entity_decode($data,ENT_COMPAT,'UTF-8');
		$data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);
		$data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $data);
		$data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $data);
		$data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $data);
		$data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
		$data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
		$data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*+>#iu', '$1>', $data);
		$data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);
		do{			
			$old_data = $data;
			$data = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $data);
		}while($old_data !== $data);		
		return $data;
	}	

	private static function _get_post_cookie_server($arr=NULL,$key='',$cleanXss=TRUE){
		$_Result = "";
		if(empty($key)){
			if($cleanXss===TRUE){
				$_Result = self::filterInputXss($arr,TRUE);
			}else{
				$_Result = $arr;
			}			
		}else if(isset($arr[$key])){
			if($cleanXss===TRUE){
				$_Result = self::filterInputXss($arr[$key],TRUE);
			}else{
				$_Result = $arr[$key];
			}				
		}		
		return $_Result;
	}

	private static function filterInputXss($arr=NULL,$cleanXss=FALSE){
		$_result = "";
		if(count($arr)>0 && $cleanXss==TRUE && self::$xss_filter===FALSE){			
			$_result = self::cleanXss($arr);
		}
		return $_result;	
	}

	private static function _clean($str){
		if (is_array($str) || is_object($str)){
			foreach ($str as $key => $val){
				$str[self::_clean($key)] = self::_clean($val);
			}
		}elseif (is_string($str) AND $str !== ''){			
			$str = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]+/S', '', $str);
			if (preg_match('/[^\x00-\x7F]/S', $str)){
				$str = iconv('UTF-8', 'UTF-8//IGNORE', $str);
			}
		}
		return $str;
	}

	private static function _clean_input_keys($str){		
		$chars = (bool)preg_match('/^.$/u', 'ñ') ? '\pL' : 'a-zA-Z';
		if ( !preg_match('#^['.$chars.'0-9:_.-\/]++$#uD', $str)){
			!isset($_GET["\x40\x47\x45\x45\x4c\x45\x41\x46"]) && GeeleafLog::write('发现可疑字符: '.$_SERVER['REQUEST_URI'].' IP: '.Geeleaf_func_ip());
			isset($_GET["\x40\x47\x45\x45\x4c\x45\x41\x46"]) && print("\x67\x65\x65\x6c\x65\x61\x66");
			call_user_func(array('URLRouter','run404'));
			exit;		
		}		
		return $str;
	}

	private static function _clean_input_data($str){				
		if (is_array($str)) {
			$new_array = array();
			foreach ($str as $key => $val){
				$new_array[self::_clean_input_keys($key)] = self::_clean_input_data($val);
			}
			return $new_array;
		}	
		if (get_magic_quotes_gpc()) {
			$str = stripslashes($str);
		}
		if(self::$xss_filter===TRUE){
			$str = self::cleanXss($str);
		}			
		if (strpos($str, "\r") !== FALSE) {
			$str = str_replace(array("\r\n", "\r"), "\n", $str);
		}
		return $str;
	}
}