<?php
/**
 * 加载配置文件和多语言版本
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-7
 * @package      Geeleaf
 * @final
 */

final class Config {	
	public static $Lang = '';
	private static $langArr = array();	
	private static $loadArr = array();

	private function __construct(){}
	private function __clone(){}

	public static function load($path){
		if(isset(self::$loadArr[$path]) && self::$loadArr[$path]){
			return self::$loadArr[$path];
		}else{			
			$_ConfigFile = str_replace('.', DIRECTORY_SEPARATOR, $path);
			$_FullPath = GEELEAF_WEBSITE . 'configs'.DIRECTORY_SEPARATOR . $_ConfigFile . '.php';
			self::$loadArr[$path] = is_file($_FullPath) ? require $_FullPath : false;
			return self::$loadArr[$path];
		}
	}

	public static function lang($path,$argv=NULL){		
		if(empty(self::$Lang)) {
			is_array($l=Config::load('global')) && (isset($l['Language'])) && self::$Lang=$l['Language'];
			if (empty(self::$Lang)) {
				return '';
			}			
		}				
		$_FullPath = GEELEAF_WEBSITE . 'i18n'.DIRECTORY_SEPARATOR . self::$Lang;
		$_PathSplit = explode('.',$path);		
		$_Item = array_pop($_PathSplit);	
		$_RecombinePath = $_FullPath . DIRECTORY_SEPARATOR. implode(DIRECTORY_SEPARATOR, $_PathSplit) . '.php';
		$_Result = '';
		if(!isset(self::$langArr[md5($_RecombinePath)])){			
			if(is_file($_RecombinePath)){
				self::$langArr[md5($_RecombinePath)] = require $_RecombinePath;			
			}
		}
		if(is_array($argv)){
			$_Result = @vsprintf(self::$langArr[md5($_RecombinePath)][$_Item],$argv);
		}else{
			$_Result = (string)@self::$langArr[md5($_RecombinePath)][$_Item];
		}
		return $_Result;
	}	
}