<?php
/**
 * Cookie类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-8
 * @package      Geeleaf
 * @final
 */

final class Cookie {
	private static $instance = NULL;
	private static $cookie_config = NULL;

	private function __clone() {}	

	public function __construct() {}

	public static function getInstance() {
		if(!(self::$instance instanceof self)){
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function set($Name,$Value,$Expire=NULL,$Path=NULL,$Domain=NULL,$Secure=NULL,$HttpOnly=NULL){		
		if(headers_sent()) {
			GeeleafLog::write('setcookie()函数使用之前不能有任何浏览器输出');
			return FALSE;
		}
		if(self::$cookie_config===NULL){
			$_CookieSetting = Config::load('cookie');			
			if(is_array($_CookieSetting) && count($_CookieSetting)>0){
				$_Diff = array_diff(				
					array('Expire','Path','Domain','Secure','HttpOnly'),
					array_keys($_CookieSetting)
				);	
				if(count($_Diff)>0){
					GeeleafLog::write('缺失website/configs/cookie.php或cookie.php设置有误');
					throw new GeeLeafException(1003);
				}else{						
					self::$cookie_config = $_CookieSetting;
					foreach (self::$cookie_config as $k=>$v) {
						is_null($$k) && $$k=$v;
					}
				}
			}else{
				GeeleafLog::write('缺失website/configs/cookie.php或cookie.php设置有误');
				throw new GeeLeafException(1003);
			}
		}
				
		$Expire = (int)$Expire;
		if($Expire <= 0){
			$Expire = 0;
		}else{
			$Expire = time() + $Expire;
		}
		$_Result = setcookie($Name,$Value,$Expire,$Path,$Domain,$Secure,$HttpOnly);	

		if(!$_Result){
			GeeleafLog::write('setcookie()执行失败');
			throw new GeeLeafException(1014);
		}		
		return (bool)$_Result;
	}

	public function get($name,$cleanXss=TRUE) {
		return Client::getInstance()->cookie($name,$cleanXss);
	}

	public function delete($name) {
		return setcookie($name,'',-86400);
	}

	public function __destruct() {}
}