<?php
/**
 * 事件驱动类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-7
 * @package      Geeleaf
 */

final class Event {
	private static $events = array();
	private static $has_run = array();

	public static function add($name, $callback) {		
		if (!isset(self::$events[$name]))	{
			self::$events[$name] = array();
		} elseif (in_array($callback, self::$events[$name], TRUE)) {
			return FALSE;
		}
		self::$events[$name][] = $callback;
		return TRUE;
	}

	public static function run($name, $argvs=array()) {	
		if (!empty(self::$events[$name])) {
			$callbacks = empty(self::$events[$name]) ? array() : self::$events[$name];		
			if(count($argvs)>0){
				foreach ($callbacks as $callback){
					$_Class = new ReflectionClass($callback[0]); 
	      			$_Instance = $_Class->newInstance(); 
	      			$_Method = $_Class->getMethod($callback[1]); 
					$_Method->invokeArgs($_Instance,$argvs); 
					unset($_Class,$_Instance,$_Method);
				}
			}else{
				foreach ($callbacks as $callback){
					call_user_func($callback);
				}				
			}
		}
		self::$has_run[$name] = $name;
	}

	public static function hasRun($name) {
		return isset(self::$has_run[$name]);
	}

} 
