<?php
/**
 * GeeLeaf class file.
 *
 * An open source application development framework for PHP 5.2.0 or newer
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the use of this software.
 *
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-7
 * @package      Geeleaf
 * @final
 */
final class GeeLeaf {
		private static $instance;
		private static $xss_filter = FALSE;
		
		private function __construct() {}

		public static function run(){
			if (isset($_SERVER['REQUEST_URI'])){
				$_SERVER['REQUEST_URI'] = $_SERVER['REQUEST_URI'];
			}else if (isset($_SERVER['HTTP_X_REWRITE_URL'])){
				$_SERVER['REQUEST_URI'] = $_SERVER['HTTP_X_REWRITE_URL'];
			}else if (isset($_SERVER['HTTP_REQUEST_URI'])){
				$_SERVER['REQUEST_URI'] = $_SERVER['HTTP_REQUEST_URI'];
			}else{
				if(isset($_SERVER['PHP_SELF'])){
					$_SERVER['REQUEST_URI'] = $_SERVER['PHP_SELF'];
				}else{
					$_SERVER['REQUEST_URI'] = $_SERVER['SCRIPT_NAME'];
				}
				if($_SERVER['QUERY_STRING']){
					$_SERVER['REQUEST_URI'] .= '?' . $_SERVER['QUERY_STRING'];
				}
			}			
			GeeLeafExceptionTrigger::run();
			$_GlobalSetting = Config::load('global');
			if(!isset($_GlobalSetting['Time_Zone']) || (string)$_GlobalSetting['Time_Zone']==""){				
				throw new GeeLeafException(1001); 
			}else{
				if(!@date_default_timezone_set($_GlobalSetting['Time_Zone'])){
					throw new GeeLeafException(1001);
				}							
			}			
			Client::cleanInput();		
			URLRouter::getInstance()->invoke();
		}

		public static function loadLib($className){
			$classFile = GEELEAF_LIB.$className.'.class.php';			
			$sessionInterfaceFiles = GEELEAF_LIB.'session'.DIRECTORY_SEPARATOR.$className.'.interface.php';
			$sessionClassFiles = GEELEAF_LIB.'session'.DIRECTORY_SEPARATOR.$className.'.class.php';			
			$viewInterfaceFiles = GEELEAF_LIB.'view'.DIRECTORY_SEPARATOR.$className.'.interface.php';
			$viewClassFiles = GEELEAF_LIB.'view'.DIRECTORY_SEPARATOR.$className.'.class.php';	
			$pluginClassFiles = GEELEAF_LIB.'plugin'.DIRECTORY_SEPARATOR.$className.'.class.php';		
			$pluginInterfaceFiles = GEELEAF_LIB.'plugin'.DIRECTORY_SEPARATOR.$className.'.interface.php';
			$dbClassFiles = GEELEAF_LIB.'database'.DIRECTORY_SEPARATOR.$className.'.class.php';
			$helperClassFiles = GEELEAF_LIB.'helper'.DIRECTORY_SEPARATOR.$className.'.class.php';			
			$websiteModels = GEELEAF_WEBSITE.'models'.DIRECTORY_SEPARATOR.$className.'.class.php';
			$websiteClasses = GEELEAF_WEBSITE.'classes'.DIRECTORY_SEPARATOR.$className.'.class.php';
			
			if(is_file($classFile) && $className!='GeeLeaf'){
				require $classFile;
			}
			
			if(is_file($sessionClassFiles)){
				require $sessionClassFiles;
			}
			if(is_file($sessionInterfaceFiles)){
				require $sessionInterfaceFiles;
			}			
			if(is_file($viewClassFiles)){
				require $viewClassFiles;
			}
			if(is_file($viewInterfaceFiles)){
				require $viewInterfaceFiles;
			}
			if(is_file($pluginClassFiles)){
				require $pluginClassFiles;
			}
			if(is_file($pluginInterfaceFiles)){
				require $pluginInterfaceFiles;
			}			
			if(is_file($dbClassFiles)){
				require $dbClassFiles;
			}	
			if(is_file($helperClassFiles)){
				require $helperClassFiles;
			}	
			if(is_file($websiteModels)){
				require $websiteModels;
			}	
			if(is_file($websiteClasses)){
				require $websiteClasses;
			}
		}
	}
?>