<?php
/**
 * Geeleaf异常处理类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-9
 * @package      Geeleaf
 */
class GeeLeafException extends Exception {
		private $errorPrompt = NULL;
		private $suggestion = NULL;		
		private $noCodeError = '
<!DOCTYPE html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<title>GeeLeaf Console</title>
</head>
<body>
<div style="width:380px;border:1px solid #AFAFAF;margin:auto;margin-top:100px;">
	<div style="font-weight:bold;padding:10px 10px 10px 10px;padding-bottom:5px;border:0;border-bottom:0px solid #AFAFAF;background:#E89E5B;">
		系统设置错误(System Error)</span>
	</div>
	<div style="text-align:left;list-style-type:none;font-size:12px;padding:5px 5px 5px 5px;">
		<li style="line-height:25px;border-bottom:1px dashed;"><span>文件(File)</span><span style="margin-left:10px;font-size:13px;color:blue;">{FILE}</span></li>
		<li style="line-height:25px;"><span>原因</span><span style="margin-left:10px;font-size:13px;color:blue;">错误代码({CODE})不存在</span></li>
		<li style="line-height:25px;border-bottom:1px dashed;"><span>Problem</span><span style="margin-left:10px;font-size:13px;color:blue;">Error Code ({CODE}) can not be found</span></li>
		<li style="line-height:25px;"><span>解决方法</span><span style="margin-left:10px;font-size:13px;color:blue;">检查错误代码是否填写有误</span></li>
		<li style="line-height:25px;"><span>Solution</span><span style="margin-left:10px;font-size:13px;color:blue;">Check if the error code was set in wrong</span></li>
	</div>
</div>
</body>';
		private $innerError = '
<!DOCTYPE html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<title>GeeLeaf Console</title>
</head>
<body>
<div style="width:380px;border:1px solid #AFAFAF;margin:auto;margin-top:100px;">
	<div style="font-weight:bold;padding:10px 10px 10px 10px;padding-bottom:5px;border:0;border-bottom:0px solid #AFAFAF;background:#E89E5B;">
		系统文件设置错误(System File Error)</span>
	</div>
	<div style="text-align:left;list-style-type:none;font-size:12px;padding:5px 5px 5px 5px;">
		<li style="line-height:25px;border-bottom:1px dashed;"><span>文件(File)</span><span style="margin-left:10px;font-size:13px;color:blue;">system/configs/Error.Prompt.php</span></li>
		<li style="line-height:25px;"><span>原因</span><span style="margin-left:10px;font-size:13px;color:blue;">文件不存在或内容设置有误</span></li>
		<li style="line-height:25px;border-bottom:1px dashed;"><span>Problem</span><span style="margin-left:10px;font-size:13px;color:blue;">File not be found or was set in wrong</span></li>
		<li style="line-height:25px;"><span>解决方法</span><span style="margin-left:10px;font-size:13px;color:blue;">用原文件重新替换即可</span></li>
		<li style="line-height:25px;"><span>Solution</span><span style="margin-left:10px;font-size:13px;color:blue;">Replace it with original file</span></li>
	</div>
</div>
</body>';
		
		private $warningBox = '
<!DOCTYPE html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<title>GeeLeaf Console</title>
</head>
<body>
<div style="width:380px;border:1px solid #AFAFAF;margin:auto;margin-top:100px;">
	<div style="font-weight:bold;padding:10px 10px 10px 10px;padding-bottom:5px;border:0;border-bottom:0px solid #AFAFAF;background:#E89E5B;">
		{MESSAGE}<span style="margin-left:10px;color:#ffffff;font-size:12px;font-weight:normal;" title="{CODETITLE}">({CODE})</span>
	</div>
	<div style="text-align:left;list-style-type:none;font-size:15px;padding-left:5px;padding-top:5px;">
		<li style="line-height:25px"><span>{FILEPATH}</span><span style="margin-left:10px;font-size:13px;color:blue;word-break:break-all;">{FILEPATH:VALUE}</span></li>
		<li style="line-height:25px"><span>{LINENO}</span><span style="margin-left:10px;font-size:13px;color:blue;word-break:break-all;">{LINENO:VALUE}</span></li>
		<li style="line-height:25px"><span>{CLASS}</span><span style="margin-left:10px;font-size:13px;color:blue;word-break:break-all;">{CLASS:VALUE}</span></li>
		<li style="line-height:25px"><span>{FUNCTION}</span><span style="margin-left:10px;font-size:13px;color:blue;word-break:break-all;">{FUNCTION:VALUE}</span></li>
		<li style="line-height:25px"><span>{PARAMETER}</span><span style="margin-left:10px;font-size:13px;color:blue;word-break:break-all;">{PARAMETER:VALUE}</span></li>
	</div>	
	<div style="text-align:right;padding-top:5px;padding-bottom:5px;border:0;border-top:0px solid #AFAFAF;">
		<span style="cursor:pointer;color:#999999;font-size:12px;padding-right:5px;" title="{SUGGESTION:OPEN}">+ More...</span>
	</div>		
	<div style="padding:5px 0 5px 5px;border:0;border-top:1px solid #AFAFAF;font-size:12px;display:none;">
		{MOREINFOMATION:VALUE}
	</div>
	<script type="text/javascript">
		window.onload = function(){
			var _div = document.getElementsByTagName("div")[0];	
			var _moreAll = _div.getElementsByTagName("div");		
			var _more = _moreAll[2].getElementsByTagName("span")[0];
			var _moreInfo = _moreAll[3];		
			_more.onclick = function(){
				if(_moreInfo.style.display=="none"){
					_moreInfo.style.display = "block";
					_more.title = "{SUGGESTION:CLOSE}";	
					_more.innerHTML = "- More...";					
				}else{
					_moreInfo.style.display = "none";
					_more.title = "{SUGGESTION:OPEN}";
					_more.innerHTML = "+ More...";					
				}
			}
		}
	</script>
</div>
</body>';
		public function __construct($code=0) {
			$this->code = $code;
			if($this->errorPrompt===NULL){
				if(is_file(GEELEAF_CONFIG.'Error.Prompt.php')){
					$this->errorPrompt = require(GEELEAF_CONFIG.'Error.Prompt.php');
				}else{
					exit($this->innerError);
				}
				$_CurrentLang = Config::load('global');
				$_CurrentLang = $_CurrentLang['Language'];			
				if(!is_array($this->errorPrompt) || count($this->errorPrompt) < 1){
					exit($this->innerError);
				}
			}			
			$this->errorPrompt = $this->errorPrompt[$_CurrentLang];
			if(isset($this->errorPrompt['Error'][$code]) && count($this->errorPrompt['Error'][$code])>0){
				$this->message = $this->errorPrompt['Error'][$code]['Message'];
				$this->suggestion = $this->errorPrompt['Error'][$code]['Suggestion'];
			}else{
				$_Result = str_replace('{FILE}',$_SERVER['REQUEST_URI'],$this->noCodeError);
				exit(str_replace('{CODE}',$code,$_Result));
			}
	    }		

	    public function showWarning() {	    	
	    	$_runEnv = Config::load('global');
			$_runEnv = $_runEnv['RunningEnv'];
			if (empty($_runEnv) || $_runEnv!='production') {
				$_runEnv = 'development';
			}
			if ($_runEnv != 'production') {
				$this->_replace();
	    		exit($this->warningBox);
			}else{
				@call_user_func(array('URLRouter','run404'));
			}
			exit;	    	
	    }

	    private function _replace($_ValueVars=array()){	    	    	
	    	$file = '';	    	
	    	$line = '';
	    	$class = '';
	    	$function = '';
	    	$args = '';
	    	$_Trace = $this->getTrace();
	    	extract($_Trace[0],EXTR_OVERWRITE);	
	    	$_TemplateVars = array(
	    		'/\{MESSAGE\}/',
	    		'/\{CODE\}/',
	    		'/\{CODETITLE\}/',
	    		'/\{FILEPATH\}/',
	    		'/\{FILEPATH\:VALUE\}/',
	    		'/\{LINENO\}/',
	    		'/\{LINENO\:VALUE\}/',
	    		'/\{CLASS\}/',
	    		'/\{CLASS\:VALUE\}/',
	    		'/\{FUNCTION\}/',
	    		'/\{FUNCTION\:VALUE\}/',
	    		'/\{PARAMETER\}/',
	    		'/\{PARAMETER\:VALUE\}/',
	    		'/\{SUGGESTION\:OPEN\}/',
	    		'/\{SUGGESTION\:CLOSE\}/',
	    		'/\{MOREINFOMATION\:VALUE\}/',
	    	);
	    	
	    	$_SuggestArr = $this->errorPrompt['Error'][$this->code]['Suggestion'];
	    	$_Suggest = "";
	    	foreach ($_SuggestArr as $k => $v) {
	    		$_Suggest .= ($k+1).".{$v}<br />";
	    	}
	    	if(count($_ValueVars)==0){	    	
		    	$_ValueVars = array(
		    		$this->message,
		    		$this->code,
		    		$this->errorPrompt['CodeTitle'],
		    		$this->errorPrompt['File'],
		    		$file,
		    		$this->errorPrompt['Line'],
		    		$line,
		    		$this->errorPrompt['Class'],
		    		$class,
		    		$this->errorPrompt['Function'],
		    		$function,
		    		$this->errorPrompt['Args'],
		    		implode(',',$args),
		    		$this->errorPrompt['SuggestOpen'],	    		
		    		$this->errorPrompt['SuggestClose'],
		    		$_Suggest,
		    	);
	    	}	
			$this->warningBox = preg_replace($_TemplateVars, $_ValueVars, $this->warningBox);
		}	    
}