<?php
/**
 * Geeleaf函数库
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-26
 * @package      Geeleaf
 */
  
function Geeleaf_func_crypt($data,$salt,$encode=TRUE) { 
	if(func_num_args()<2 || empty($salt)) {
		return FALSE;
	}
	$key[] =""; 
	$box[] =""; 
	$cipher = "";	
	if(!$encode){
		$data = base64_decode($data);
	}	
	$salt_length = strlen($salt); 
	$data_length = strlen($data); 	
	for ($i = 0; $i < 256; $i++) { 
		$key[$i] = ord($salt[$i % $salt_length]); 
		$box[$i] = $i; 
	} 
	for ($j = $i = 0; $i < 256; $i++) { 
		$j = ($j + $box[$i] + $key[$i]) % 256; 
		$tmp = $box[$i]; 
		$box[$i] = $box[$j]; 
		$box[$j] = $tmp; 
	} 	
	for ($a = $j = $i = 0; $i < $data_length; $i++) { 
		$a = ($a + 1) % 256; 
		$j = ($j + $box[$a]) % 256; 		
		$tmp = $box[$a]; 
		$box[$a] = $box[$j]; 
		$box[$j] = $tmp; 		
		$k = $box[(($box[$a] + $box[$j]) % 256)]; 
		$cipher .= chr(ord($data[$i]) ^ $k); 
	} 	
	if($encode){
		$cipher = str_replace('=', '', base64_encode($cipher));
	}	
	return $cipher; 
}

function Geeleaf_func_m_escape($str) {
	$s = '';
	if (!(get_magic_quotes_gpc() || get_magic_quotes_runtime())) {
		$s = @mysql_real_escape_string($str);
	}	
	if(empty($s)){
		$s = $str;
	}
	return $s;
}

function Geeleaf_func_ip() {
	if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
		$ip = getenv('HTTP_CLIENT_IP');
	} elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
		$ip = getenv('HTTP_X_FORWARDED_FOR');
	} elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
		$ip = getenv('REMOTE_ADDR');
	} elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
		$ip = $_SERVER['REMOTE_ADDR'];
	}
	return preg_match ( '/[\d\.]{7,15}/', $ip, $matches ) ? $matches [0] : '';
}

function Geeleaf_func_substr($str,$start=0,$length='') {
	$s = $str; 
	$num = intval($length); 
	if($num==0){
		$num = strlen($str);
	}
	$rs = ""; 
	$_getIndex = 0; 
	$_gotCount = 0; 
	for($i=0;$i<strlen($s);){
		$_byte = substr($s,$i,1); 
		$_getBit = 1; 
		if(ord($_byte) > 127){				
			$_getBit = 3;
			$_tmpChar = substr($s,$i,$_getBit);				
			$i += 3; 
		}else{ 
			$_tmpChar = substr($s,$i,$_getBit);
			$i++; 
		}		
		if($num>0 && $_getIndex>=$start){
			$rs .= $_tmpChar;
			if(++$_gotCount >= $num){
				break;
			}
		}
		$_getIndex++;
	}
	$_result = array();
	$_result['string'] = $rs;
	$_result['length'] = $_gotCount;
	return $_result;
}

function Geeleaf_func_redirect($uri='',$method='302') {
	if(headers_sent()) {
		return FALSE;
	}
	$codes = array(
		'refresh' => 'Refresh',
		'300' => 'Multiple Choices',
		'301' => 'Moved Permanently',
		'302' => 'Found',
		'303' => 'See Other',
		'304' => 'Not Modified',
		'305' => 'Use Proxy',
		'307' => 'Temporary Redirect'
	);
	if($method === 'refresh'){
		header('Refresh: 0; url='.$uri);
	}else{
		header('HTTP/1.1 '.$method.' '.@$codes[$method]);
		header('Location: '.$uri);
	}
}

function Geeleaf_func_sqlAddslashes($s, $is_like=false, $crlf=false, $php_code=false){
    if ($is_like) {
        $s = str_replace('\\', '\\\\\\\\', $s);
    } else {
        $s = str_replace('\\', '\\\\', $s);
    }
    if ($crlf) {
        $s = str_replace("\n", '\n', $s);
        $s = str_replace("\r", '\r', $s);
        $s = str_replace("\t", '\t', $s);
    }
    if ($php_code) {
        $s = str_replace('\'', '\\\'', $s);
    } else {
        $s = str_replace('\'', '\'\'', $s);
    }
    return $s;
}