<?php
/**
 * 用来操作系统运行日志
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-25
 * @package      Geeleaf
 * @final
 */

final class GeeleafLog {	
	private static $logPath = "";
	private function __construct() {}

	public static function write($log,$level=1) {
		$globalConf = Config::load('global');
		if(!(bool)$globalConf) {
			throw new GeeLeafException(1010);
		}
		if (func_num_args()==0 || !@$globalConf['OpenLog']) {
			return FALSE;
		}	
		if(!$loghandle = @fopen(self::_logFile(), 'a+b')) {
			throw new GeeLeafException(1011);
		}
		$_level = "";
		if($level==1){
			$_level = " [WARNING]-- ";
		}else{
			$_level = " [ERROR]  -- ";
		}		
		fwrite($loghandle, date('Y-m-d H:i:s').$_level.(string)$log.PHP_EOL);
		fclose($loghandle);
	}

	public static function read($date='') {				
		$logs = @file(self::_logFile($date));		
		$logs_arr = array();
		if($logs) {
			foreach ($logs as $v) {
				$one = substr($v, 0,32);
				preg_match_all('/\d\d\:\d\d\:\d\d|ERROR|WARNING/', $one, $result);
				if(isset($result[0]) && count($result[0])>=2) {
					$logs_arr[$result[0][0]][$result[0][1]][] = rtrim(substr($v, 32));
				}				
			}
		}
		return $logs_arr;
	}

	private static function _checkConf() {
		$globalConf = Config::load('global');
		if(!(bool)$globalConf) {
			throw new GeeLeafException(1010);
		}
		self::$logPath = @$globalConf['LogPath'];
		if (!is_dir(self::$logPath)) {			
			if(!@mkdir(self::$logPath,0777)) {
				throw new GeeLeafException(1011);
			}
		}		
	}

	private static function _logFile($date='') {		
		self::_checkConf();
		$date_check = TRUE;
		if($date!='') {
			$darr = @explode('-',$date);
			if(count($darr)==3 && isset($darr[0])  && isset($darr[1])  && isset($darr[2]) ) {
				if(!checkdate(intval($darr[1]), intval($darr[2]), intval($darr[0]))) {
					$date_check = FALSE;
				}
			}else{
				$date_check = FALSE;
			}
		}		
		if($date_check && $date!='') {
			$date = strtotime($date);
		}else{
			$date = time();
		}
		$path_tail = substr(self::$logPath,-1,1);
		if($path_tail==DIRECTORY_SEPARATOR || $path_tail=='/') {
			$logfile = self::$logPath.date('Y-m-d',$date).'.log';	
		}else{
			$logfile = self::$logPath.DIRECTORY_SEPARATOR.date('Y-m-d',$date).'.log';	
		}
		return $logfile;
	}
}