<?php
/**
 * RBAC权限控制类
 *  
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-11-16
 * @package      Geeleaf
 */

class Rbac {
	public $User = 0;
	public $TopPermission = FALSE;
	public $UseReg = FALSE;
	
	private static $instance = NULL;
	private $orm = NULL;
	private $table_user = '';
	private $table_user_group = '';
	private $table_user_group_desc = '';
	private $table_role = '';
	private $table_role_desc = '';
	private $table_privilege = '';

	public function __construct($t_u,$t_u_g,$t_u_g_d,$t_r,$t_r_d,$t_p,$db='',$configarr=array()) {
		$this->table_user = $t_u;
		$this->table_user_group = $t_u_g;
		$this->table_user_group_desc = $t_u_g_d;
		$this->table_role = $t_r;
		$this->table_role_desc = $t_r_d;
		$this->table_privilege = $t_p;		
		$_db = Config::load('database');
		if($configarr) {
			$_db = $configarr;
		}		
		if(empty($db)){			
			$this->orm = new GeeleafORM($_db['Database'],$configarr);
		}else{
			$this->orm = new GeeleafORM($db,$configarr);
		}
	}

	public static function factory($t_u,$t_u_g,$t_u_g_d,$t_r,$t_r_d,$t_p,$db='',$configarr=array()) {
		if(self::$instance==NULL) {
			self::$instance = new self($t_u,$t_u_g,$t_u_g_d,$t_r,$t_r_d,$t_p,$db,$configarr);
		}
		return self::$instance;
	}

	public function addPrivilege($name,$resource,$sys=0) {		
		$_success = FALSE;
		if (empty($name) || empty($resource)) {
			return $_success;
		}
		$this->orm->table = $this->table_privilege;
		$this->orm->privilege_id = 0;
		$this->orm->name = $name;
		$this->orm->sys = $sys;
		$this->orm->resource = $resource;
		$_success = (bool)$this->orm->insert();		
		return $_success;
	}

	public function addRole($name,$sys=0) {
		$_success = FALSE;
		if (empty($name)) {
			return $_success;
		}
		$this->orm->table = $this->table_role_desc;
		$this->orm->name = $name;
		$this->orm->sys = $sys;
		$_success = (bool)$this->orm->insert();
		return $_success;
	}

	public function addPermission($role,$privilege) {
		$_success = FALSE;
		if (empty($role) || empty($privilege)) {
			return $_success;
		}
		$role = intval($role);
		$privilege = intval($privilege);
		$this->orm->table = $this->table_role;
		$this->orm->role_id = $role;
		$this->orm->privilege_id = $privilege;
		$_success = (bool)$this->orm->insert();
		return $_success;
	}

	public function addGroup($name,$sys=0) {
		$_success = FALSE;
		if (empty($name)) {
			return $_success;
		}
		$this->orm->table = $this->table_user_group_desc;
		$this->orm->name = $name;
		$this->orm->sys = $sys;
		$_success = (bool)$this->orm->insert();
		return $_success;
	}

	public function addGroupRole($group,$role) {
		$_success = FALSE;
		if (empty($group) || empty($role)) {
			return $_success;
		}		
		$group = intval($group);
		$role = intval($role);
		$this->orm->table = $this->table_user_group;
		$this->orm->group_id = $group;
		$this->orm->role_id = $role;
		$_success = (bool)$this->orm->insert();
		return $_success;
	}

	public function addUser($user,$group) {
		$_success = FALSE;
		if (empty($user) || empty($group)) {
			return $_success;
		}		
		$user = intval($user);
		$group = intval($group);
		$this->orm->table = $this->table_user;
		$this->orm->user_id = $user;
		$this->orm->group_id = $group;		
		$_success = (bool)$this->orm->insert();
		return $_success;
	}

	public function removeUserFromGroup($user,$group) {
		$_success = FALSE;
		if (empty($user) || empty($group)) {
			return $_success;
		}
		$_success = $this->del($this->table_user, "user_id=".$user." AND group_id=".$group);
		return $_success;
	}

	public function removeUser($user) {
		$_success = FALSE;
		if (empty($user)) {
			return $_success;
		}
		$_success = $this->del($this->table_user, "user_id=".$user);
		return $_success;
	}

	public function removeGroup($group) {
		$step_1 = $step_2 = $step_3 = FALSE;
		$step_1 = $this->del($this->table_user_group_desc, "group_id=".$group);
		$step_1 && $step_2 = $this->del($this->table_user_group, "group_id=".$group);
		$step_2 && $step_3 = $this->del($this->table_user, "group_id=".$group);
		return $step_1;
	}

	public function removePrivilege($privilege) {
		$step_1 = $step_2 = FALSE;
		$step_1 = $this->del($this->table_privilege, "privilege_id=".$privilege);
		$step_1 && $step_2 = $this->del($this->table_role, "privilege_id=".$privilege);
		return $step_1;
	}

	public function removeRole($role) {
		$step_1 = $step_2 = $step_3 = FALSE;
		$step_1 = $this->del($this->table_role_desc, "role_id=".Geeleaf_func_m_escape($role));
		$step_1 && $step_2 = $this->del($this->table_role, "role_id=".Geeleaf_func_m_escape($role));
		$step_2 && $step_3 = $this->del($this->table_user_group, "role_id=".Geeleaf_func_m_escape($role));
		return $step_1;
	}

	public function removePrivilegeForRole($role,$privilege=0) {
		$deleted = false;
		if(intval($privilege) > 0){
			$deleted = $this->del($this->table_role,"role_id=".Geeleaf_func_m_escape($role)." AND privilege_id=".Geeleaf_func_m_escape($privilege));
		}else{
			$deleted = $this->del($this->table_role,"role_id=".Geeleaf_func_m_escape($role));
		}
		return $deleted;
	}

	public function removeRoleForGroup($group,$role=0) {
		$deleted = false;
		if(intval($role) > 0){
			$deleted = $this->del($this->table_user_group,"group_id=".Geeleaf_func_m_escape($group)." AND role_id=".Geeleaf_func_m_escape($role));
		}else{
			$deleted = $this->del($this->table_user_group,"group_id=".Geeleaf_func_m_escape($group));
		}
		return $deleted;
	}
	
	private function del($table,$where) {
		return (bool)$this->orm->from($table)->where($where)->delete();
	}

	public function editGroup($name,$group) {
		$this->orm->from($this->table_user_group_desc)
				  ->where("group_id=".Geeleaf_func_m_escape($group))
				  ->name = $name;
		return (bool)$this->orm->update();
	}

	public function editPrivilege($name,$resource,$privilege) {
		$this->orm->from($this->table_privilege)->where("privilege_id=".Geeleaf_func_m_escape($privilege));
		$this->orm->name = $name;
		$this->orm->resource = $resource;
		return (bool)$this->orm->update();
	}

	public function editRole($name,$role) {
		$this->orm->from($this->table_role_desc)->where("role_id=".Geeleaf_func_m_escape($role));
		$this->orm->name = $name;
		return (bool)$this->orm->update();
	}

	public function getUsers() {
		$user_ids = $this->orm->from($this->table_user)->fields('DISTINCT user_id')->getMeta();
		$ids = array();
		if($user_ids) {
			foreach ($user_ids as $v) {
				array_push($ids, $v['user_id']);
			}
		}
		return $ids;
	}

	public function getGroups() {
		return $this->orm->from($this->table_user_group_desc)->getMeta();
	}

	public function getGroupsByUser($user) {
		$id_arr = array();
		$_result = array();
		$ids = "";
		if (is_array($user)) {
			$id_arr = $user;
		}else{
			$id_arr[] = $user;
		}
		if($id_arr){
			$ids = implode($id_arr,',');			
			$groups =  $this->orm
						 ->from($this->table_user_group_desc)
						 ->join($this->table_user)
						 ->where($this->table_user.".group_id=".$this->table_user_group_desc.".group_id AND ".$this->table_user.".user_id in (".$ids.")")
						 ->getMeta();
			foreach ($id_arr as $k => $v) {
				foreach ($groups as $k2 => $v2) {
					if($v2['user_id']==$v) {
						$_result[$v][] = $v2;
					}
				}
			}
		}
		return $_result;	
	}

	public function getUsersByGroup($group) {
		$id_arr = array();
		$_result = array();
		$ids = "";
		if (is_array($group)) {
			$id_arr = $group;
		}else{
			$id_arr[] = $group;
		}
		if($id_arr){
			$ids = implode($id_arr,',');
			$users = $this->orm
						->from($this->table_user)
						->where($this->table_user.".group_id in (".$ids.")")
						->getMeta();
			foreach ($id_arr as $k => $v) {
				foreach ($users as $k2 => $v2) {
					if($v2['group_id']==$v) {
						$_result[$v][] = $v2;
					}
				}
			}
		}
		return $_result;
	}

	public function getPrivilege() {
		return $this->orm->from($this->table_privilege)->getMeta();
	}

	public function getRoles() {
		return $this->orm->from($this->table_role_desc)->getMeta();
	}

	public function getRolesByGroup($group) {
		$id_arr = array();
		$_result = array();
		$ids = "";
		if (is_array($group)) {
			$id_arr = $group;
		}else{
			$id_arr[] = $group;
		}
		if($id_arr){
			$ids = implode($id_arr,',');			
			$roles =  $this->orm
						 ->from($this->table_role_desc)
						 ->join($this->table_user_group)
						 ->where($this->table_user_group.".role_id=".$this->table_role_desc.".role_id AND ".$this->table_user_group.".group_id in (".$ids.")")
						 ->getMeta();
			foreach ($id_arr as $k => $v) {
				foreach ($roles as $k2 => $v2) {
					if($v2['group_id']==$v) {
						$_result[$v][] = $v2;
					}
				}
			}
		}
		return $_result;	
	}

	public function getPrivilegeByRole($role) {
		$id_arr = array();
		$_result = array();
		$ids = "";
		if (is_array($role)) {
			$id_arr = $role;
		}else{
			$id_arr[] = $role;
		}
		if($id_arr){
			$ids = implode($id_arr,',');			
			$roles =  $this->orm
						 ->from($this->table_privilege)
						 ->join($this->table_role)
						 ->where($this->table_role.".privilege_id=".$this->table_privilege.".privilege_id AND ".$this->table_role.".role_id in (".$ids.")")
						 ->getMeta();
			foreach ($id_arr as $k => $v) {
				foreach ($roles as $k2 => $v2) {
					if($v2['role_id']==$v) {
						$_result[$v][] = $v2;
					}
				}
			}
		}
		return $_result;	
	}	

	public function checkUserInGroup($user,$group) {
		return (bool)$this->orm
			 ->from($this->table_user)
			 ->where("user_id=".Geeleaf_func_m_escape($user)." AND group_id=".Geeleaf_func_m_escape($group))
			 ->count();
	}

	public function checkGroupInRole($group,$role) {
		return (bool)$this->orm
			 ->from($this->table_user_group)
			 ->where("group_id=".Geeleaf_func_m_escape($group)." AND role_id=".Geeleaf_func_m_escape($role))
			 ->count();
	}

	public function checkRoleInPrivilege($role,$privilege) {
		return (bool)$this->orm
			 ->from($this->table_role)
			 ->where("role_id=".Geeleaf_func_m_escape($role)." AND privilege_id=".Geeleaf_func_m_escape($privilege))
			 ->count();
	}

	public function hasPermission($resource='') {
		$_permission = FALSE;
		if($this->TopPermission) {
			return TRUE;
		}
		$privilege_list = $this->orm
			 ->from($this->table_user.' as u')
			 ->fields('p.resource')
			 ->join($this->table_privilege.' as p,'.$this->table_role.' as r,'.$this->table_user_group.' as g')
			 ->where("u.group_id=g.group_id AND g.role_id=r.role_id AND r.privilege_id=p.privilege_id AND u.user_id=".Geeleaf_func_m_escape($this->User))
			 ->getMeta();		
		if($privilege_list) {
			foreach ($privilege_list as $v) {
				//if($v['resource']==$resource) {
				if(strpos($resource,$v['resource'])!==FALSE) {
					$_permission = TRUE;
					break;
				}
			}
			if($_permission==FALSE && $this->UseReg) {
				foreach ($privilege_list as $v) {
					@preg_match('/'.$v['resource'].'/',$resource,$matches);
					if(count($matches) > 0) {
						$_permission = TRUE;
						break;						
					}
				}
			}
		}		
		return $_permission;
	}
}