<?php
/**
 * URL路由类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-27
 * @package      Geeleaf
 */
  
class URLRouter {
	
	private static $instance = NULL;

	public $Theme = 'default';
	
	public function __construct() {
		$theme = Config::load('global');
		if (!empty($theme['Theme'])) {
			$this->Theme = $theme['Theme'];
		}	
	}

	public static function getInstance() {
		if (!(self::$instance instanceof self)) {
			self::$instance = new self();;
		}
		return self::$instance;
	}

 	private function getDomain($showhttp=false) {		
		$server_name = !empty($_SERVER['HTTP_HOST']) ? strtolower($_SERVER['HTTP_HOST']) : $_SERVER['SERVER_NAME'];
		$server_port = ($_SERVER['SERVER_PORT'] == '80') ? '' : ':' . (int)$_SERVER['SERVER_PORT'];		
		$secure = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 1 : 0;		
		$secure = $secure ? 'https://' : 'http://';
		if($showhttp){
			$domain = $secure . $server_name . $server_port;
		}else{
			$domain = $server_name . $server_port;
		}		
		return $domain;
	}

	public function getBaseURI() {	
		$url = str_replace(array('\\', '//'), '/', dirname($_SERVER['SCRIPT_NAME']));		
		$url = ($url=="/") ? "" : ((substr($url, -1) == '/') ? $url : $url . '/');			
		return $url;
	}

	private function getBasePath(){	
		if (!function_exists('_formatURI')) {
			function _formatURI($uri){
				return preg_replace('/\/+/','/',$uri);
			}
		}	
		if (!function_exists('removeQueryString')) {			
			function removeQueryString($uri){
				return str_replace('?'.$_SERVER['QUERY_STRING'],'',$uri);
			}
		}		
		$_formatUri = _formatURI($_SERVER['REQUEST_URI']);		
		$_baseUri = $this->getBaseURI();		
		$_search = str_replace('/','\/',$_baseUri);
		$_search = '/'.$_search.'[index\.php]*/';
		if(strlen($_baseUri)>1){
			$_formatUri = preg_replace($_search,'',$_formatUri);
		}
		$_formatUri = preg_replace('/^(\/index\.php)*\//', '', $_formatUri);		
		$_formatUri = preg_replace('/^\/|\/$/', '', $_formatUri);
		$_formatUri = removeQueryString($_formatUri);
		if(strcmp($_formatUri,'index.php')==0){
			$_formatUri = "";
		}
		return $_formatUri;
	}
	
	public function getMvcPath() {
		$_configURL = "";			
		$_key_arr   = array();
		$_re_arr    = array();
		$_result    = array();
		$confgarr   = Config::load('router');			
		$_baseURI   = $this->getBaseURI();
		$_basePath  = $this->getBasePath();
		if($_baseURI!=""){
			$url = $this->getDomain().$_baseURI.$_basePath;
		}else{
			if(empty($_basePath)) {
				$url = $this->getDomain();
			}else{
				$url = $this->getDomain().'/'.$_basePath;
			}		
		}	

		$opensubdomain = Config::load('global');
		if(!isset($opensubdomain['OpenWDnsRouter']) || $opensubdomain['OpenWDnsRouter']==FALSE) {
			$url = $_basePath;
		}	

		if(is_array($confgarr)){
			foreach($confgarr as $k => $v){	
				@preg_match("/{$k}/",$url,$_result);
				if($_result){
					for($i=1;$i<count($_result);$i++){
						$_key_arr[] = '/\$'.$i.'/';
						$_re_arr[] = $_result[$i];
					}
					$_configURL = preg_replace($_key_arr,$_re_arr,$v);					
					break;
				}								
			}			
		}	
		
		return empty($_configURL) ? $_basePath : $_configURL;
	}

	public function getMvcPathByGet() {
		$routerconf = Config::load('global');
		$r_var = $routerconf['OpenGetForRouter']['Var'];
		if($r_var!='') {
			$confgarr   = Config::load('router');
			$r_var = Client::getInstance()->get($r_var,TRUE);			
			$parsed_url = isset($r_var) ? $r_var : '';
			if(is_array($confgarr)){
				foreach($confgarr as $k => $v){
					@preg_match("/{$k}/",$parsed_url,$_result);
					if($_result){
						for($i=1;$i<count($_result);$i++){
							$_key_arr[] = '/\$'.$i.'/';
							$_re_arr[] = $_result[$i];
						}
						$parsed_url = preg_replace($_key_arr,$_re_arr,$v);					
						break;
					}								
				}		
			}
			return $parsed_url;
		}else{
			throw new GeeLeafException(1013);
		}
	}

	private function parseMvc($mvcpath,$default='index') {
		$mvc_arr = array();
		$default_c = $default;
		$c_suffix = "Controller.class.php";
		$m_suffix = "Model.class.php";
		$v_suffix = "View.class.php";	
		$t_suffix = ".php";	
		$web_entrance = GEELEAF_WEBSITE."entrance".DIRECTORY_SEPARATOR;
		$theme_dir = GEELEAF_WEBSITE.'themes'.DIRECTORY_SEPARATOR.$this->Theme.DIRECTORY_SEPARATOR;		
		if($mvcpath==""){
			$mvcpath = preg_replace('/^\/+|\/+$/', '', $default_c);
		}
				
		$mp_arr    = explode('/', strtolower($mvcpath));		
		$c 		   = ""; 	  
		$c_file    = ""; 	  	
		$c_path    = ""; 	 
		$c_method  = ""; 	 
		$c_m_pos   = -1; 	 
		$params	   = array(); 
		$m_file	   = "";	 
		$v_file	   = "";	
		$t_file    = "";	
		$tmp_c     = "";

		foreach ($mp_arr as $k => $v) {
			$tmp_c    .= $v.DIRECTORY_SEPARATOR;
			$c_f       = $web_entrance.substr($tmp_c,0,-1).$c_suffix;
			$c_index_f = $web_entrance.$tmp_c.'index'.$c_suffix;
			if(is_file($c_f)) { 
				$tmp = $v;
				$c = $tmp.'Controller';
				$model = $tmp.'Model';
				$view = $tmp.'View';
				$c_file = $c_f;
				$c_path = substr($web_entrance.$tmp_c, 0,-strlen($v.DIRECTORY_SEPARATOR));
				$m_file = $c_path.$v.$m_suffix;
				$v_file = $c_path.$v.$v_suffix;
				//$t_file = $theme_dir.$v.$t_suffix;
				$t_file = $theme_dir.substr($tmp_c, 0,-1).$t_suffix;
				$c_m_pos = $k+1;
				$c_method = isset($mp_arr[$c_m_pos]) ? $mp_arr[$c_m_pos] : '';
				break;
			}else if(is_file($c_index_f)) {}
		}		

		if($c_m_pos > -1) {
			$params = array_slice($mp_arr,$c_m_pos+1);
		}				

		if($c!="") {
			$mvc_arr['c_class'] = $c;        
			$mvc_arr['c_file']  = $c_file;   
			$mvc_arr['method']  = $c_method;
			$mvc_arr['param']   = $params; 
			$mvc_arr['m_class'] = $model;	
			$mvc_arr['m_file']  = $m_file;  
			$mvc_arr['v_class'] = $view;    
			$mvc_arr['v_file']  = $v_file;  
			$mvc_arr['t_file']  = $t_file; 
			$mvc_arr['dir']     = $c_path; 
		}
		return $mvc_arr;
	}	

	private function parse() {
		$router_set = Config::load('global');		
		if($router_set['OpenGetForRouter']['Open']===TRUE) {
			$mvc = $this->getMvcPathByGet();
		}else{
			$mvc = $this->getMvcPath();
		}
		$default_url = !empty($router_set['DefaultRouter']) ? $router_set['DefaultRouter'] : 'index';
		return $this->parseMvc($mvc,$default_url);
	}

	public function invoke() {
		$arr = $this->parse();
		if(count($arr) < 1) {
			$this->run404();
			return FALSE;
		}	

		require $arr['c_file'];
		if(!class_exists($arr['c_class'])) {
			throw new GeeLeafException(1016);
		}		
		$c = new ReflectionClass($arr['c_class']);
      	$c_ins = $c->newInstance(); 
      	$c_ins->Arguments = $arr['param'];

      	$c_ins->Tfile = is_file($arr['t_file']) ? $arr['t_file'] : '';

		if(is_file($arr['m_file'])){
			require $arr['m_file'];
			if(class_exists($arr['m_class'])) {
				$c_ins->Model = new $arr['m_class'];
			}
		}

		if(is_file($arr['v_file'])){
			require $arr['v_file'];
			if(class_exists($arr['v_class'])) {
				$c_ins->View = new $arr['v_class']($this->Theme,$c_ins->Tfile);
			}
		}		

      	if ($c->hasMethod($arr['method'])) {      		      		
      		$method = $c->getMethod($arr['method']);       		
      		if($method->isPublic()){      		
      			$method->invokeArgs($c_ins,$arr['param']);
      		}else{
      			$this->run404();
      		}      		
      	}else{      		
      		if ($c->hasMethod('index')) {
      			$tmp = $arr['method'];
      			$arr['method'] = 'index';
      			!empty($tmp) && array_unshift($arr['param'],$tmp);
      			$method = $c->getMethod('index'); 
      			$param_obj = $method->getParameters();  
      			$params = array(); 
      			foreach ($param_obj as $v){
      				$params[] = '';
      			}	
      			$c_ins->Arguments = $arr['param'];      			
      			$method->invokeArgs($c_ins,$params);   			
      		}else{
      			$this->run404();
      		}
      	}      	
	}

	public function run404() {
		$not_found_page = _get404(true); //仅供GeeWeb程序使用
		if (!is_readable($not_found_page)) {
			$html = '<div><p>404 Not Found</p><p><a href="'.GEELEAF_URLROOT.'">Go to index</a></p><p>Copyright &copy; Geeleaf</p></div>';
			exit($html);
		}else{	
			require $not_found_page;
		}
	}
	
}