<?php
/**
 * 视图抽象类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-30
 * @package      Geeleaf
 * @abstract
 */

abstract class View {
	public $Theme;
	protected $themeDriver = NULL;
	
	public function __construct($theme='',$file='') {
		$this->Theme = GEELEAF_WEBSITE.'themes'.DIRECTORY_SEPARATOR.$theme;
		if(substr($this->Theme,-1)!=DIRECTORY_SEPARATOR) {
			$this->Theme .= DIRECTORY_SEPARATOR;
		}
		$template_class = 'TemplateOneDriver';
		$theme = Config::load('global');
		if (class_exists($theme['ThemeDriver'])) {
			$template_class = $theme['ThemeDriver'];
		}		
		$this->themeDriver = new $template_class($file);
	}	

	public function setTfile($tfile) {
		$this->themeDriver->setTfile($this->Theme.$tfile);
	}

	public function assign($name,$value=NULL) {
		return $this->themeDriver->assign($name,$value);
	}

	public function render($print=TRUE) {		
		return $this->themeDriver->render($print);
	}
	
}