<?php
/**
 * GeeleafORM类用来简化数据库访问
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-23
 * @package      Geeleaf/database
 * @example
 */
	class GeeleafORM {
		public 	  $table      = "";
		protected static $ins = NULL;
		protected $db_schema  = NULL;	
		protected $from       = "";
		protected $join       = "";
		protected $fields     = "";
		protected $where      = "";
		protected $order      = "";
		protected $group      = "";
		protected $having     = "";
		protected $limit      = "";
		protected $queried	  	  = array();	
		protected $data_container = array();	
		protected $pre_pro_values = array();	
		protected $inner_pro_arr  = array();	

		public function __construct($db='',$configarr=array()) {		
			$_db_conf = Config::load('database');
			if(is_array($configarr) && count($configarr)>0) {				
				$_db_conf = $configarr;
			}
			if($_db_conf===FALSE) {
				throw new GeeLeafException(1005);
			}
			if(
				!(isset($_db_conf['LocalHost']) &&
				isset($_db_conf['Port']) &&	
				isset($_db_conf['UserName']) &&
				isset($_db_conf['Password']) &&
				isset($_db_conf['Database']))
			){
				throw new GeeLeafException(1006);
			}			
			if (!(bool)trim($db)) {
				$this->db_schema = new MySQL($_db_conf['LocalHost'],$_db_conf['UserName'],$_db_conf['Password'],$_db_conf['Database']);
			}else{
				$this->db_schema = new MySQL($_db_conf['LocalHost'],$_db_conf['UserName'],$_db_conf['Password'],$db);
			}			
			$this->from($this->table);			
			$this->inner_pro_arr = array(
				'table',
				'db_schema',
				'from',
				'join',
				'fields',
				'where',
				'order',
				'group',
				'having',
				'limit',
				'data_container',
				'pre_pro_values',
				'inner_pro_arr',
				'queried',
			); 			
			foreach (get_object_vars($this) as $k => $v) {
				if(array_search($k,$this->inner_pro_arr)===FALSE) {
					$this->pre_pro_values[$k] = $v;				
				}
			}
		}

		public static function factory($table,$db='',$configarr=array()) {
			if(self::$ins===NULL) {
				self::$ins = new self($db,$configarr);
			}
			return self::$ins->from($table);
		}

		public function selectDb($db) {
			if ($this->db_schema->selectDb($db)) {
				return $this;
			}else{
				return FALSE;
			}			
		}

		public function __get($key){		          
			if(isset($this->data_container[$this->table][$key])) {
				return $this->data_container[$this->table][$key];
			}
			return '';
		} 

		public function __set($key, $value){
			$this->data_container[$this->table][$key] = $value; 	          
		} 

		protected function _clear() {
			$this->join   = "";
			$this->fields = "";
			$this->where  = "";
			$this->order  = "";
			$this->group  = "";
			$this->having = "";
			$this->limit  = "";
		}

		protected function _makePart($str,$flag='') {
			$_part = "";
			if(is_array($str)){
				$_part = implode(',',$str);	
			}else{
				$_part = $str;
			}
			if(!empty($_part)) {
				$_part = $flag.$_part.' ';
			}
			return $_part;
		}

		protected function _makeCondition($arr) {			
			$_part = "";
			if(is_array($arr[0])){
				foreach($arr[0] as $v){					
					$_val = isset($v['EscapeValue']) ? $v['EscapeValue'] : $v['Value'];					
					if(isset($v['EscapeValue']) && $_val==$v['EscapeValue'] && !is_numeric($_val)){
						$_val = "'".Geeleaf_func_m_escape($_val)."'";
					}
					
					if(isset($v['Connector']) && $v['Connector']){
						$_part .= $v['Connector'].' '.$v['Field'].' '.$v['Operator'].' '.$_val.' ';
					}else{
						$_part .= $v['Field'].' '.$v['Operator'].' '.$_val.' ';
					}					
				}
			}else{
				$_part = implode('',$arr);
			}
			return $_part;			
		}

		protected function _makeQuerySql() {
			$this->fields=="" && $this->fields="* "; 
			$_sql = $this->fields.$this->from.$this->join.$this->where.$this->order.$this->group.$this->having.$this->limit;
			if(!empty($_sql)){
				$_sql = 'SELECT '.$_sql.' ';
			}
			return $_sql;
		}		

		public function from($str) {	
			$this->table = $str; 	
			$this->from = $this->_makePart($str,'FROM ');
			return $this;
		}

		public function join($str) {
			$this->join = $this->_makePart($str,'JOIN ');
			return $this;
		}

		public function fields($str) {
			$this->fields = $this->_makePart($str);
			return $this;
		}

		public function where() {
			$_Args = func_get_args();
			if($_Args==NULL) {
				throw new GeeLeafException(1007);				
			}
			$_Where = $this->_makeCondition($_Args);
			if(!empty($_Where)){
				$this->where = 'WHERE '.$_Where.' ';
			}
			return $this;
		}

		public function order($str) {
			$_Order = "";
			if(is_array($str)){
				foreach($str as $k => $v) {
					$_Order .= $k.' '.($v ? $v : 'ASC').',';
				}
				$_Order = substr($_Order,0,-1);
			}else{
				$_Order = $str;
			}				
			if(!empty($_Order)) {
				$this->order = 'ORDER BY '.$_Order.' ';
			}
			return $this;
		}

		public function group($str) {
			$this->group = $this->_makePart($str,'GROUP BY ');
			return $this;
		}

		public function having() {
			$_Args = func_get_args();
			if($_Args==NULL) {
				throw new GeeLeafException(1008);				
			}
			$_Having = $this->_makeCondition($_Args);
			if(!empty($_Having)){
				$this->having = 'HAVING '.$_Having.' ';
			}
			return $this;
		}

		public function limit($being=1,$length=0){
			$_Limit = "";
			if(func_num_args()==1){
				$_Limit = (int)$being;
			}else{
				$_Limit = ((int)$being-1).','.$length;
			}
			if($_Limit!==""){
				$this->limit = 'LIMIT '.$_Limit;
			}
			return $this;
		}

		public function get() {
			$sql = $this->_makeQuerySql();
			if(isset($this->queried['Object_'.md5($sql)]) && $this->queried['Object_'.md5($sql)]) {
				$data = $this->queried['Object_'.md5($sql)];
			}else{
				$data = $this->db_schema->getObject($sql);
				$this->queried['Object_'.md5($sql)] = $data;
			}
			$this->_clear();
			return $data;
		}

		public function getOne() {
			$sql = $this->_makeQuerySql();
			if(isset($this->queried['Object_one_'.md5($sql)]) && $this->queried['Object_one_'.md5($sql)]) {
				$data = $this->queried['Object_one_'.md5($sql)];
			}else{
				$data = $this->db_schema->getObject($sql,FALSE);
				$this->queried['Object_one_'.md5($sql)] = $data;
			}
			$this->_clear();
			return $data;
		}

		public function getMetaOne($type=MYSQL_ASSOC, $usecache=TRUE) {
			$sql = $this->_makeQuerySql();
			if(isset($this->queried['MetaData_one_'.md5($sql)]) && $this->queried['MetaData_one_'.md5($sql)] && $usecache) {
				$data = $this->queried['MetaData_one_'.md5($sql)];
			}else{
				$data = $this->db_schema->getOneRow($sql,$type);
				$this->queried['MetaData_one_'.md5($sql)] = $data;
			}
			$this->_clear();
			return $data;
		}

		public function getMeta($type=MYSQL_ASSOC, $usecache=TRUE) {
			$sql = $this->_makeQuerySql();
			if(isset($this->queried['MetaData_'.md5($sql)]) && $this->queried['MetaData_'.md5($sql)] && $usecache) {
				$data = $this->queried['MetaData_'.md5($sql)];
			}else{
				$data = $this->db_schema->getAllRows($sql,$type);
				$this->queried['MetaData_'.md5($sql)] = $data;
			}
			$this->_clear();
			return $data;
		}

		protected function _getPropertys($type='') {
			$_pro_arr = array();
			$_changed_arr = array();	
			$_inner_pros = array();			
			foreach (get_object_vars($this) as $k => $v) {
				if(array_search($k,$this->inner_pro_arr)===FALSE) {
					$_inner_pros[$k] = $v;
				}
			}				
			if($type=='UPDATE'){				
				foreach($_inner_pros as $k=>$v) {								
					if($_inner_pros[$k]!==$this->pre_pro_values[$k]) {
						$_changed_arr[$k] = $v;
						$this->pre_pro_values[$k] = $v;
					}
				}
				if(isset($this->data_container[$this->table]) && $this->data_container[$this->table]) {
					$_pro_arr = array_merge($_changed_arr,$this->data_container[$this->table]);
				}else{
					$_pro_arr = $_changed_arr;
				}								
			}else{				
				if(isset($this->data_container[$this->table]) && $this->data_container[$this->table]) {
					$_pro_arr = array_merge($_inner_pros,$this->data_container[$this->table]);
				}else{
					$_pro_arr = $_inner_pros;
				}
			}
			return $_pro_arr;
		}

		public function update() {
			$_arr = $this->_getPropertys('UPDATE');
			if(count($_arr) > 0){
				$_field_arr = $_arr;
				$_update = "";
				foreach($_field_arr as $k=>$v) {
					$_update .= '`'.$k.'`='.(is_numeric($v) ? $v : "'".Geeleaf_func_m_escape($v)."'").',';
				}
				$_update = (string)substr($_update,0,-1);
				if(empty($_update)) {
					return FALSE;
				}
				$_sql = "UPDATE {$this->table} SET {$_update} {$this->where}";
				
				$this->_clear();
				
				return $this->db_schema->update($_sql);
			}				
			$this->_clear();			
			return FALSE;		
		}

		public function insert(){			
			$_arr = $this->_getPropertys();			
			if(count($_arr) > 0){
				$_field_arr = $_arr;
				$_insert = "";
				$_fields = "";
				$_values = "";
				foreach($_field_arr as $k=>$v) {
					$_fields .= '`'.$k.'`,';					
					$_values .= is_numeric($v) ? $v.',' : "'".Geeleaf_func_m_escape($v)."'".',';
				}
				if(!empty($_fields) && !empty($_values)) {
					$_fields = '('.substr($_fields,0,-1).')';
					$_values = '('.substr($_values,0,-1).')';					
					$_sql = "INSERT INTO {$this->table}{$_fields} VALUES{$_values}";
					return $this->db_schema->insert($_sql) > 0 ? TRUE : FALSE ;
				}
			}
			return FALSE;
		}

		public function getInsertId() {
			return $this->db_schema->getInsertId();
		}

		public function delete() {
			$_sql = "DELETE {$this->from} {$this->where}";
			$this->_clear();
			return $this->db_schema->delete($_sql);
		}

		public function count() {			
			$count = 0;
			$sql = "SELECT COUNT(*) ".$this->from.$this->join.$this->where.$this->order.$this->group.$this->having.$this->limit;
			if(isset($this->queried['Count_'.md5($sql)]) && $this->queried['Count_'.md5($sql)]) {
				$count = $this->queried['Count_'.md5($sql)];
			}else{
				$count = $this->db_schema->getOneRow($sql,MYSQL_NUM);
				$count = isset($count[0]) ? intval($count[0]) : 0;
				$this->queried['Count_'.md5($sql)] = $count;
			}
			$this->_clear();			
			return $count;
		}

		public function exec($sql,$db='') {
			if(!empty($db))	$this->db_schema->selectDb($db);
			return $this->db_schema->exec($sql,'UNBUFFERED');
		}

		public function query($sql, $type=MYSQL_ASSOC) {
			if (empty($sql)) {
				return FALSE;
			}
			return $this->db_schema->getAllRows($sql,$type);
		}

		public function queryOne($sql, $type=MYSQL_ASSOC) {
			if (empty($sql)) {
				return FALSE;
			}
			return $this->db_schema->getOneRow($sql,$type);
		}
		
		public function close() {
			$this->db_schema->close();
		}
	}	
?>