<?php
/**
 * MySQL数据库访问类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-23
 * @package      Geeleaf/database
 * @final
 */
final class MySQL {
	private $mlink;
	private $dataObjects = array();
	private $affectedRows = 0;
	private $insertid = 0;
	private static $instance = NULL;

	public function __construct($dbhost, $dbuser, $dbpw, $dbname='',$dbcharset='utf8',$pconnect=false){
		if($pconnect){
			if(!$this->mlink = @mysql_pconnect($dbhost, $dbuser, $dbpw)){
				$this->halt();
			}
		} else {
			if(!$this->mlink = @mysql_connect($dbhost, $dbuser, $dbpw)){
				$this->halt();
			}
		}
		$_version = mysql_get_server_info($this->mlink);
		if($_version > '4.1'){
			if('utf-8'==strtolower($dbcharset)){
				$dbcharset='utf8';
			}
			if($dbcharset){
				mysql_query("SET character_set_connection=$dbcharset, character_set_results=$dbcharset, character_set_client=binary", $this->mlink);
			}
			if($_version > '5.0.1'){
				mysql_query("SET sql_mode=''", $this->mlink);
			}
		}
		if($dbname){
			mysql_select_db($dbname, $this->mlink);
		}				
	}

	public static function factory($dbhost,$dbuser,$dbpw,$dbname='',$dbcharset='utf8',$pconnect=false) {
		if (self::$instance==NULL) {
			self::$instance = new self($dbhost,$dbuser,$dbpw,$dbname,$dbcharset,$pconnect);
		}
		return self::$instance;
	}
	
	public function  __destruct() {
		
	}

	public function selectDb($dbname){
		return mysql_select_db($dbname, $this->mlink);
	}

	public function exec($sql, $type = ''){
		$func = $type == 'UNBUFFERED' && @function_exists('mysql_unbuffered_query') ? 'mysql_unbuffered_query' : 'mysql_query';
		if(!($query = $func($sql, $this->mlink))){
			$this->halt(TRUE,$sql);
		}
		$this->insertid = mysql_insert_id($this->mlink);
		return $query;
	}

	private function execModify($sql){
		$this->beginWork(); 
		if(!($query = mysql_query($sql, $this->mlink))){
			if($this->halt(TRUE,$sql)==1062){
				return FALSE;
			}
		}
		$this->affectedRows = mysql_affected_rows($this->mlink);
		$this->insertid = mysql_insert_id($this->mlink);
		$this->commitWork(); 
		return $query;
	}

	public function getOneRow($sql,$result_type=MYSQL_ASSOC){
		$rs = $this->exec($sql,'UNBUFFERED');
		$rs2 = NULL;
		if($result_type==MYSQL_ASSOC){
			$rs2 = mysql_fetch_assoc($rs);
		}else{
			$rs2 = mysql_fetch_row($rs);
		}	
		mysql_free_result($rs);
		return $rs2;
	}

	public function getAllRows($sql,$result_type=MYSQL_ASSOC) {
		$_rsArr = array();
		$rs = $this->exec($sql,'UNBUFFERED');
		if($rs) {
			while(($row=mysql_fetch_array($rs,$result_type)) != FALSE) {
				$_rsArr[] = $row;
			}
		}	
		mysql_free_result($rs);	
		return $_rsArr;
	}

	public function getObject($sql,$return_all=TRUE){
		$dataObjects = NULL;
		$rs = $this->exec($sql);		
		if($rs) {
			if($return_all) {
				while(($row=mysql_fetch_object($rs)) != FALSE) {
				    $dataObjects[] = $row;
				}
			}else{
				$dataObjects = mysql_fetch_object($rs);
			}
		}
		mysql_free_result($rs);
		return $dataObjects;
	}

	public function insert($sql) {
		$this->execModify($sql);
		return $this->affectedRows;
	}

	public function update($sql) {
		$this->execModify($sql);
		return $this->affectedRows;
	}

	public function delete($sql) {		
		$this->execModify($sql);
		return $this->affectedRows;
	}

	public function getInsertId(){
		return $this->insertid;
	}

	private function beginWork() {
		mysql_query('START TRANSACTION',$this->mlink);
	}

	private function commitWork() {
		mysql_query('COMMIT',$this->mlink);
	}

	private function rollbackWork() {
		$this->affectedRows = 0;
		mysql_query('ROLLBACK',$this->mlink);
	}

	public function close(){
		return @mysql_close();
	}

	private function halt($debug=TRUE,$sql=''){		
		if($debug){
			$_errorCode = intval(($this->mlink) ? mysql_errno($this->mlink) : mysql_errno());
			$_errorMsg = ($this->mlink) ? mysql_error($this->mlink) : mysql_error();
			if ($_errorCode==1062) {
				GeeleafLog::write($_errorMsg,2);				
				return 1062;
			}
			$error = '
				<!DOCTYPE html>
				<head>
					<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
					<title>GeeLeaf Console</title>
				</head>
				<body>
				<div style="width:380px;border:1px solid #AFAFAF;margin:auto;margin-top:100px;">
					<div style="font-weight:bold;padding:10px 10px 10px 10px;padding-bottom:5px;border:0;border-bottom:0px solid #AFAFAF;background:#E89E5B;">
						MySQL错误(MySQL Error)</span>
					</div>
					<div style="text-align:left;list-style-type:none;font-size:12px;padding:5px 5px 5px 5px;word-break:break-all;">
						<li style="line-height:25px;"><span>错误代码</span><span style="margin-left:10px;font-size:13px;color:blue;">'.$_errorCode.'</span></li>
						<li style="line-height:25px;"><span>错误描述</span><span style="margin-left:10px;font-size:13px;color:blue;">'.$_errorMsg.'</span></li>
						<li style="line-height:25px;"><span>错误SQL </span><span style="margin-left:10px;font-size:13px;color:blue;">'.$sql.'</span></li>
						<li style="line-height:25px;"><span>所在文件</span><span style="margin-left:10px;font-size:13px;color:blue;">'.$_SERVER['PHP_SELF'].'</span></li>
					</div>
				</div>
				</body>';
			GeeleafLog::write($_errorMsg.$sql,2);
			$this->rollbackWork(); 			
			$_runEnv = Config::load('global');
			$_runEnv = $_runEnv['RunningEnv'];
			if (empty($_runEnv) || $_runEnv!='production') {
				$_runEnv = 'development';
			}
			if ($_runEnv != 'production') {
				exit($error);
			}else{
				@call_user_func(array('URLRouter','run404'));
				exit;
			}			
		}
		$this->rollbackWork(); 
	}
}
?>