<?php 
/**
 * 验证码类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-11-23
 * @package      Geeleaf/helper
 */

class Captcha {
	public $Font = "";
	public $Width = 50;
	public $Height = 22;
	public $BgColor = "#ffffff";
	public $FontColor = "";
	public $LineColor = "";
	public $LineCount = 3;
	public $Pixel = 10;
	public $Text = "";	
	private $TextLength = 0;	
	private $hasFontFile = TRUE;

	public function __construct($useConfigFile=TRUE) {
		if ($useConfigFile) {
			$Font = $Width = $Height = $BgColor = $FontColor = $LineColor = $LineCount = $Pixel = NULL;
			$captche_set = Config::load('captcha');
			if($captche_set!==FALSE) {
				extract($captche_set,EXTR_OVERWRITE);
				$this->Font      = $Font;
				$this->Width     = $Width;
				$this->Height    = $Height;
				$this->BgColor   = $BgColor;
				$this->FontColor = $FontColor;
				$this->LineColor = $LineColor;
				$this->LineCount = $LineCount;
				$this->Pixel     = $Pixel;
			}
		}				
	}

	public function get() {
		if(empty($this->Text) || headers_sent()) {
			return FALSE;
		}
		if(!is_readable($this->Font)) {
			$this->hasFontFile = FALSE;
		}
		$this->TextLength = Geeleaf_func_substr($this->Text);
		$this->TextLength = $this->TextLength['length'];
		
		$im = imageCreateTrueColor($this->Width, $this->Height);
		if(empty($this->BgColor)) {
			$this->BgColor = imageColorallocate($im,rand(0,255),rand(0,255),rand(0,255));
		}else{
			$this->BgColor = $this->_getColor($im,$this->BgColor);
		}		
		imageFill($im, 0, 0, $this->BgColor);		
		for ($i = 0; $i < $this->TextLength; $i++) {
			$c = Geeleaf_func_substr($this->Text,$i,1);
			$h = rand(10,$this->Height);
			if(empty($this->FontColor)) {
				$fontcolor = $this->getRandColor($im,$this->BgColor);
			}else{
				$fontcolor = $this->_getColor($im,$this->FontColor);
			}
			if($this->hasFontFile) {				
				imagettftext($im, $h, rand(0,20), ceil($this->Width/$this->TextLength)*$i, rand($h,$this->Height), $fontcolor, $this->Font, $c['string']);
			}else{				
				imagestring($im, 20, ceil($this->Width/$this->TextLength)*$i, rand(0, ceil($this->Height/2)), $c['string'], $fontcolor);
			}
		}
		$this->Pixel = intval($this->Pixel);
		for($i=0;$i<$this->Pixel;$i++){
			$randcolor = $this->getRandColor($im);
			imagesetpixel($im, rand()%70 , rand()%30 , $randcolor);
		}		
		for ($i = 1; $i <= $this->LineCount; $i++) {			
			if(empty($this->LineColor)) {
				$linecolor = $this->getRandColor($im,$this->BgColor);
			}else{
				$linecolor = $this->_getColor($im,$this->LineColor);
			}
			imageLine($im,rand(1,$this->Width), rand(1,$this->Height), rand(1,$this->Width), rand(1,$this->Height), $linecolor);
		}		
		Header('Content-type: image/png');
		imagePng($im);	
		imageDestroy($im);
		return TRUE;
	}

	private function getRandColor($im,$color=NULL) {
		$_n = imageColorallocate($im,rand(0,255),rand(0,255),rand(0,255));
		if($color===NULL) {
			return $_n;
		}else{
			static $_color = 0;	
			if($_n==$color) {		
				$this->getRandColor($color);
			}else{
				$_color = $_n;
			}
			return $_color;
		}
	}

	private function _getColor($im,$hexcolor) {
		$rgb = $this->_translateRgb($hexcolor);
		$r = $rgb['r'];
		$g = $rgb['g'];
		$b = $rgb['b'];
		return imageColorallocate($im,$r,$g,$b);
	}

	private function _translateRgb($hexColor) {
		preg_match('/^#?[0-9a-zA-Z]{6}$/',$hexColor,$match);
		if(count($match)<=0){
			return NULL;
		}		
		$color = str_replace('#', '', $hexColor);
	    return array(
	    	'r' => hexdec(substr($color, 0, 2)),
	   		'g' => hexdec(substr($color, 2, 2)),
	    	'b' => hexdec(substr($color, 4, 2))
	    );
	}	
}
?>