<?php
/**
 * 数据库备份类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2012-2-15
 * @package      GeeLeaf/helper
 */
  
class DataBackup {	
	private $orm = NULL;
	private static $instance = NULL;	
	public $Tables = array();
	public $Db = '';
	public $LimitKb = 0;
	
	public function __construct($orm) {		
		$this->orm = $orm;
	}
	
	public static function factory($orm) {
		if (!(self::$instance instanceof self)) {
			self::$instance = new self($orm);
		}
		return self::$instance;
	} 

	public function server($backup_dir) {
		if (!is_writable($backup_dir)) {
			return FALSE;
		}		
		$data = $this->_backup($this->Tables, $this->Db, $this->LimitKb);
		if(!$data) {
			return FALSE;
		}
		if (substr($backup_dir, -1) != DIRECTORY_SEPARATOR) {
			$backup_dir .= DIRECTORY_SEPARATOR;
		}
		$f_name = $backup_dir.$this->Db.'_'.date('YmdHi',time()).'_';
		foreach ($data as $k => $v)  {
			foreach ($v as  $k2 => $v2) {
				@file_put_contents($f_name.$v2['Table'].'_'.($k2+1).'.sql', $v2['Data']);
			}
		}
		return TRUE;
	}

	public function local() {
		$data = $this->_backup($this->Tables, $this->Db, 0);
		if(!$data) {
			return FALSE;
		}
		$ds = '';
		foreach ($data as $k => $v)  {
			foreach ($v as  $k2 => $v2) {
				$ds .= $v2['Data'];
			}
		}
		$f_name = date('YmdHi',time()).'_'.$this->Db.'.sql';
		unset($data);
		$d = new Download();
		return $d->content($ds, $f_name, 'sql');
	}

	public function restoreFromServer($backupfile) {
		$arr = @file($backupfile);
		return $this->__insert($arr);
	}

	public function restorFromLocal($tmpdir='') {
		global $G_DATABACKUP_OBJECT,$G_DATABACKUP_SUCCESSED;
		$G_DATABACKUP_OBJECT = $this;
		$G_DATABACKUP_SUCCESSED = TRUE;
		$ok = TRUE;
		if (!function_exists('_rename')) {
			function _rename($name){				
				return time().rand().'.sql';
			}
			function _uploadedAll($s,$f){
				global $G_DATABACKUP_OBJECT,$G_DATABACKUP_SUCCESSED;
				if(isset($s['NewName']) && count($s['NewName'])>0) {
					foreach ($s['NewName'] as $k => $fname) {
						$tmp = $s['SaveDir'].$fname;
						$farr = @file($tmp);
						if(!$G_DATABACKUP_OBJECT->__insert($farr)) {
							$G_DATABACKUP_SUCCESSED = FALSE;
							@unlink($tmp);
							return FALSE;
						}
						@unlink($tmp);						
					}
				}else{
					$G_DATABACKUP_SUCCESSED = FALSE;
				}
			}
		}
		$up = UpLoad::factory($tmpdir, array(
			'sql' => 0
		))->load('_rename', NULL, NULL, '_uploadedAll');
		$ok = $G_DATABACKUP_SUCCESSED;
		$G_DATABACKUP_OBJECT = $G_DATABACKUP_SUCCESSED = $up = NULL;
		unset($GLOBALS['G_DATABACKUP_OBJECT'], $GLOBALS['G_DATABACKUP_SUCCESSED'], $up);
		return $ok;	
	}

	private function _backup($tableArr=array(),$db='',$limitkb=0) {		
		$tables = $this->_getTables($db);
		$_tables = $result = array();
		if (is_array($tableArr) && count($tableArr)>0) {
			$_tables = $tableArr;
		}else{
			$_tables = $tables;	
		}
		foreach ($_tables as $t) {
			if(array_search($t, $tables)===FALSE){
				continue;
			}
			$result[] = $this->_createBackup($t,$db,$limitkb);
		}
		return $result;
	}

	private function _createBackup($table,$db='',$limitkb=0) {
		$s1 = $this->_getCreatedTable($table,$db);
		$data = $this->_getData($table,$db,true,$limitkb);
		$result = array();
		if(count($data)>0) {
			foreach ($data as $k=>$v) {
				$result[] = array(
					'Table' => $table,
					'Data' => $s1.PHP_EOL.$v.PHP_EOL
				);
			}
		}else{
			$result[] = array(
				'Table' => $table,
				'Data' => $s1.PHP_EOL
			);
		}		
		unset($s1,$data);
		return $result;
	}

	private function _getData($table,$db='',$blob16=TRUE,$limitkb=0) {
		$data = $fields_meta = $fields_flags = $fields = $values = $tmp_values = array();
		$_sFields = $_sValues = '';
		$table = $this->_addBackquote($table);
		$result = $this->orm->exec('SELECT * FROM '.$table,$db);
				
		$num_fields   = mysql_num_fields($result);	
	    for ($i = 0; $i < $num_fields; $i++) {
	        $fields_meta[] = mysql_fetch_field($result, $i);
	        $fields_flags[] = mysql_field_flags($result, $i);
	        $fields[] = $this->_addBackquote($fields_meta[$i]->name);
	    }
	    $_sFields = 'INSERT INTO '.$table.' ('.implode(', ', $fields).') VALUES ';
	    $tmp_s = $tmp_s2 = '';
	    $limitkb = floatval($limitkb) * 1024; //byte
	    $index = 0;
	    while (($row = mysql_fetch_array($result,MYSQL_NUM)) != FALSE) {
	    	for ($i = 0; $i < $num_fields; $i++) {
	    		if (!isset($row[$i]) || is_null($row[$i])) {
	    			$tmp_values[] = 'NULL';
	    		}elseif ($fields_meta[$i]->numeric && $fields_meta[$i]->type != 'timestamp' && !$fields_meta[$i]->blob) {
	    			$tmp_values[] = $row[$i];
	    		}elseif (stristr($fields_flags[$i], 'BINARY') && $fields_meta[$i]->blob && $blob16) {
	    			if (empty($row[$i]) && $row[$i]!='0') {
                        $tmp_values[] = '\'\'';
                    } else {
                        $tmp_values[] = '0x'.bin2hex($row[$i]);
                    }
	    		}elseif ($fields_meta[$i]->type == 'bit') {
	    			$printable = '';
	    			$length = $fields_meta[$i]->length;
				    for ($j = 0, $len_ceiled = ceil($length / 8); $j < $len_ceiled; $i++) {
				        $printable .= sprintf('%08d', decbin(ord(substr($row[$j], $j, 1))));
				    }
				    $printable = substr($printable, -$length);
				    $tmp_values[] = "b'".Geeleaf_func_sqlAddslashes($printable);
	    		}else {
                    $tmp_values[] = '\''.str_replace(array("\x00", "\x0a", "\x0d", "\x1a"), array('\0', '\n', '\r', '\Z'), Geeleaf_func_sqlAddslashes($row[$i])).'\'';
                }
	    	}
	    	$tmp_s = '('.implode(', ', $tmp_values).')';
	    	if($limitkb > 0) {
		    	$tmp_s2 .= $tmp_s;			
		    	if(strlen($tmp_s2) >= $limitkb){
		    		$index++;
		    		$tmp_s2 = '';
		    	}
	    	}	    	
		    $values[$index][] = $tmp_s;
		    $tmp_s = '';
		    $tmp_values = array();
	    }	    
	    foreach ($values as $k=>$v) {
	    	$_sValues = implode(',',$values[$k]).';';
	    	$data[] = $_sFields.$_sValues;
	    }
	    mysql_free_result($result);
	    unset($fields_meta,$fields_flags,$fields,$values,$tmp_values,$_sFields,$_sValues,$result,$num_fields,$table,$tmp_s,$tmp_s2,$limitkb,$index,$row);
	    return $data;
	}

	private function _addBackquote($s) {
		if (is_array($s)) {
	         $result = array();
	         foreach ($s as $k => $v) {
	             $result[$k] = $this->_addBackquote($v);
	         }
	         return $result;
	    }
	    if (strlen($s) && $s!=='*') {
	        return '`'.str_replace('`','``',$s).'`';
	    } else {
	        return $s;
	    }
	}

	private function _getTables($db='') {
		$tables = array();
		$rs = $this->orm->exec('show tables',$db);
		while (($row=mysql_fetch_array($rs,MYSQL_NUM))!=false) {
			array_push($tables, $row[0]);
		}
		mysql_free_result($rs);
		return $tables;
	}

	private function _getCreatedTable($table,$db='') {
		$sql = '';
		if(array_search($table, $this->_getTables($db))!==FALSE) {
			$rs = $this->orm->exec('show create table '.$this->_addBackquote($table),$db);
			$row = @mysql_fetch_row($rs);	
			$sql = preg_replace(array('/\n/','/CREATE\sTABLE\s/'), array('','CREATE TABLE IF NOT EXISTS '), @$row[1]).';';
			mysql_free_result($rs);
		}		
		return $sql;		
	}

	public function __insert($arr) {
		if (!is_array($arr) || count($arr)==0) {
			return FALSE;
		}
		foreach ($arr as $k=>$v){
			$op = $this->orm->exec(trim(trim($v),';'),$this->Db);
			if($op===FALSE) {
				unset($op);
				return FALSE;
			}
		}
		unset($op);
		return TRUE;
	}	
}