<?php
/**
 * 下载类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-11-24
 * @package      GeeLeaf
 */
  
class Download {	
	private $mime_arr = array();

	public function file($file,$newfile,$type) {
		return $this->_download($file, $newfile, $type, TRUE);
	}

	public function content($content,$filename,$type) {
		return $this->_download($content, $filename, $type, FALSE);
	}

	private function _download($content,$newfile,$type,$dfile=TRUE) {
		if(headers_sent() || empty($content) || empty($newfile) || empty($type) || ($dfile && !is_readable($content))) {
			return FALSE;
		}
		$f_len = strlen($content);
		$buffer = $content;
		if ($dfile) {
			$f_len = filesize($content);
			$buffer = file_get_contents($content);
		}				
		if(count($this->mime_arr)==0) {
			$mimefile = GEELEAF_CONFIG.'MIME.Type.php';
			if(is_file($mimefile)) {
				$this->mime_arr = require $mimefile;
			}
		}
		if(!array_key_exists($type,$this->mime_arr)) {
			return FALSE;
		}
		$f_type = $this->mime_arr[$type];
		ob_start(); 
		ob_clean(); 
		header("Pragma: public");    
		header("Expires: 0");        
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");        
		header("Cache-Control: private", false);  
		header("Content-Transfer-Encoding: binary");        
		header("Content-Type: " . $f_type);        
		header("Content-Length: " . $f_len);        
		header("Content-Disposition: attachment; filename=" . $newfile . ";" ); 
		echo $buffer;
		echo ob_get_clean();
		return TRUE;
	}
}