<?php
/**
 * Html类简化了Web前台的操作
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-31
 * @package      Geeleaf/helper
 */
  
class Html {	
	public static function js($jsfile,$isvendor=TRUE) {		
		$script = '<script type="text/javascript" src="'.self::_setdir($jsfile,$isvendor).$jsfile.'"></script>';
		return $script;
	}

	public static function css($cssfile,$isvendor=TRUE) {				
		$css = '<link rel="stylesheet" type="text/css" href="'.self::_setdir($cssfile,$isvendor).$cssfile.'" />';
		return $css;
	}

	public static function swf($swffile,$width,$height,$isvendor=TRUE) {
		$_f = self::resource($swffile,$isvendor);
		$swf ='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=5,0,0,0" width="'.$width.'" height="'.$height.'">
					<param name=movie value="'.$_f.'">
					<param name=quality value=High>
					<param name="FlashVars" value>
					<param name="WMode" value="Window">
					<param name="Play" value="-1">
					<param name="Loop" value="-1">
					<param name="SAlign" value>
					<param name="Menu" value="-1">
					<param name="Base" value>
					<param name="AllowScriptAccess" value="always">
					<param name="Scale" value="ShowAll">
					<param name="DeviceFont" value="0">
					<param name="EmbedMovie" value="0">
					<param name="BGColor" value>
					<param name="SWRemote" value>
					<param name="MovieData" value>
					<embed src="'.$_f.'" quality=high pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash" type="application/x-shockwave-flash" width="'.$width.'" height="'.$height.'">
					</embed>
				</object>';
		return $swf;
	}

	public static function resource($file,$isvendor=TRUE) {
		return self::_setdir($file,$isvendor).$file;
	}

	private static function _setdir($file,$isvendor=TRUE) {		
		$web_root = URLRouter::getInstance()->getBaseURI();						
		if(!$isvendor){			
			$theme = Config::load('gloal');
			if (isset($theme['Theme']) && $theme['Theme']) {
				$theme = $theme['Theme'];
			}else{
				$theme = 'default';
			}
			if(empty($web_root)) {
				$file_prefix = '/website/themes/'.$theme.'/';
			}else{
				$file_prefix = $web_root.'website/themes/'.$theme.'/';
			}			
		}else{
			if(empty($web_root)) {
				$file_prefix = '/website/themes/vendors/';
			}else{
				$file_prefix = $web_root.'website/themes/vendors/';
			}
		}
		return $file_prefix;
	}

	private static function _innerMediaFile($file) {
		return GEELEAF_URIROOT.'geemedia/'.$file;
	}

	public static function innerCss($cssfile) {
		$css = '<link rel="stylesheet" type="text/css" href="'.self::_innerMediaFile($cssfile).'" />';
		return $css;
	}

	public static function innerJs($jsfile) {
		$script = '<script type="text/javascript" src="'.self::_innerMediaFile($jsfile).'"></script>';
		return $script;
	}
}