<?php
/**
 * InfinityTree类用于无限分类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-11-2
 * @package      Geeleaf/helper
 * @example	
 */
 
class InfinityTree {
	
	private $arr=array();

	public function __construct($arr) {
		$this->arr = $arr;
	}

	public function resetArr($arr) {
		$this->arr = $arr;
	}

	public function select($_selectnameid="pid",$_selid=0,$root="",$multiple=false) {
		$_parr = $this->_makeParentArr();		
		$_str = "";
		$multi = $multiple ? " multiple=' multiple'" : '';
		if($root){			
			$_str .= "<select id='$_selectnameid' name='$_selectnameid'{$multi}><option value=0>$root</option>";
		}else{
			$_str .= "<select id='$_selectnameid' name='$_selectnameid'{$multi}>";
		}		
		$currid = 0;
		if(@$_parr[0]){
			foreach(@$_parr[0] as $k=>$v){
				$currid = $v['id'];
				if($currid==$_selid || @in_array($currid,$_selid)){
					$_str .= "<option value=$v[id] selected='true'>$v[name]</option>";
				}else{
					$_str .= "<option value=$v[id]>$v[name]</option>";
				}
				if(@$_parr[$currid]){
					$_str .= $this->_drawSelectOptions(@$_parr[$currid],$_parr,0,$_selid);
				}
			}
		}
		$_str .= "</select>";
		return $_str;
	}

	private function _makeParentArr(){
		$_parr = array();
		$array = $this->arr;		
		if($array){
			foreach ( $array as $v ){
				$pt = $v['pid']; 
				$list = @$_parr[$pt] ? @$_parr[$pt] : array();
				array_push($list,$v);
				@$_parr[$pt] = $list;
			}			
		}
		return $_parr;		
	}

	private function _drawSelectOptions($arr,$tree,$level,$selid,&$s=""){
		$prefix = str_pad("|",++$level+1,'-',STR_PAD_RIGHT);
		$_curid = 0;
		foreach($arr as $k2=>$v2){
			$_curid = $v2['id'];
			if($_curid==$selid || @in_array($_curid,$selid)){
				$s .= "<option value=$v2[id] selected='true'>$prefix$v2[name]</option>";	
			}else{
				$s .= "<option value=$v2[id]>$prefix$v2[name]</option>";	
			}
			if(@$tree[$_curid]){		
				$this->_drawSelectOptions($tree[$_curid],$tree,$level,$selid,&$s);				  
			}		  
		}
		return $s;
	}

	public function getInheritById($id,&$arr=array(),&$i=0) {		
		foreach ($this->arr as $k => $v) {
			if($v['id']===$id) {
				foreach (array_keys($v) as $k2 => $v2) {
					$arr[$i][$v2] = $v[$v2];
				}
				$i++;
				if($v['pid']!=0){ 
					$this->getInheritById($v['pid'],$arr,$i);
					break;
				}				
			}
		}				
		return $arr;	
	}

	public function getAllChildren($id,&$arr=array()) {		
		foreach ($this->arr as $k=>$v) {
			if($v['pid']==$id) {
				array_push($arr, $v['id']);
				$this->getAllChildren($v['id'],$arr);
			}			
		}
		return $arr;
	}

	public function drawTreeById($id,$subject='',$append='',$subjectclass='',$listclass='',$itemclass='') {
		$_parr = $this->_makeParentArr();	
		$_str = "";
		$has = FALSE;
		if(@$_parr[0]) {
			foreach(@$_parr[0] as $k=>$v){
				if ($v['id']==$id) {
					@$_parr[0] = array();				
					@$_parr[0][] = $v;
					$has = TRUE;
					break;
				}
			}		
		}
		if(@$_parr[0] && $has){	
			$_str = "<div>";		
			foreach(@$_parr[0] as $k=>$v){
				if ($subject == '') {
					$_str .= "<div class='$subjectclass'>".$v['name']."</div><div><div class='$listclass'>";
				}else{
					$_str .= "<div class='$subjectclass'>".preg_replace(array('/%id/','/%name/'), array($v['id'],$v['name']), $subject)."</div><div><div class='$listclass'>";	
				}				
				if(@$_parr[$v['id']]){
					$_str .= $this->_makeTreeRelation(@$_parr[$v['id']],$_parr,0,$itemclass,$append);
				}
			}
			$_str .= "</div></div></div>";	
		}		
		return $_str;
	}
	private function _makeTreeRelation($arr,$tree,$level,$itemclass='',$append='',&$s=""){
		$prefix = str_pad("|",++$level+1,'-',STR_PAD_RIGHT);
		foreach($arr as $k2=>$v2){	
			if($append != ''){
				$s .= "<div class='$itemclass'>$prefix".preg_replace(array('/%id/','/%name/'), array($v2['id'],$v2['name']), $append)."</div>";	
			}else{
				$s .= "<div class='$itemclass'>$prefix<span>$v2[name]</span></div>";	
			}		
			if(@$tree[$v2['id']]){		
				$this->_makeTreeRelation($tree[$v2['id']],$tree,$level,$itemclass,$append,&$s);				  
			}		  
		}
		return $s;
	}

	public function table($arr=array()) {
		$_parr = $this->_makeParentArr();
		$_tableClass = $_tableStyle = $_prefixStyle = $_th = $_tds = '';
		if(isset($arr['TableClass'])){
			$_tableClass = $arr['TableClass'];
		}	
		if(isset($arr['TableStyle'])){
			$_tableStyle = $arr['TableStyle'];
		}
		if(isset($arr['PrefixStyle'])){
			$_prefixStyle = $arr['PrefixStyle'];
		}
		if(isset($arr['Th'])){
			$_th = $arr['Th'];
		}
		if(isset($arr['Td'])){
			$_tds = $arr['Td'];
		}
		$_str = "<table style='".$_tableStyle."' class='".$_tableClass."'>";		
		$_str .= "<thead><tr>".$_th."</tr></thead>";
		$currid = 0;
		if(@$_parr[0]){
			foreach(@$_parr[0] as $k=>$v){				
				$_td = $this->_parseTds($v,$arr,$_tds);				
				if(empty($_td)) {
					foreach ($v as $k2=>$v2) {
						$_td .= '<td>'.$v2.'</td>';
					}
				}
				$currid = $v['id'];
				$_str .= "<tr>".$_td."</tr>";
				if(@$_parr[$currid]){
					$_str .= $this->_drawTrs(@$_parr[$currid],$_parr,0,$_tds,$_prefixStyle,$arr);
				}
			}
		}
		$_str .= "</table>";
		return $_str;
	}

	private function _drawTrs($arr,$tree,$level,$tds,$prefixstyle,$sarr,&$s=""){
		$prefix = "<span style='".$prefixstyle."'>".str_pad("|",++$level+1,'-',STR_PAD_RIGHT)."</span>";
		$_curid = 0;
		foreach($arr as $k2=>$v2){
			$_curid = $v2['id'];			
			$_td = $this->_parseTds($v2,$sarr,$tds,$prefix);			
			if(empty($_td)) {
				foreach ($v2 as $k3=>$v3) {
					if($k3=='name') {
						$_td .= '<td>'.$prefix.$v3.'</td>';
					}else{
						$_td .= '<td>'.$v3.'</td>';
					}				
				}
			}			
			$s .= "<tr>".$_td."</tr>";
			if(@$tree[$_curid]){		
				$this->_drawTrs($tree[$_curid],$tree,$level,$tds,$prefixstyle,$sarr,&$s);				  
			}		  
		}
		return $s;
	}

	private function _parseTds($arr,$sarr,$tds,$prefix='') {
		$s = '';
		$matches = $values = array();
		preg_match_all('/[%#]\w+/', $tds, $matches);
		if (isset($matches[0]) && count($matches[0])>0) {
			$matches = array_unique($matches[0]);			
			foreach ($matches as $f) {
				foreach ($arr as $k=>$v) {
					if($f=='%'.$k) {
						if(isset($sarr['Where'][$k])) {
							$t = '';
							if(isset($sarr['Where'][$k]['if']) && isset($sarr['Where'][$k]['value']) && isset($sarr['Where'][$k]['elsevalue'])) {
								$c = (preg_replace('/%(\w+)/', '\$v[\'$1\']', $sarr['Where'][$k]['if']));
								$c = "if(".$c."){\$t=\$sarr['Where']['".$k."']['value'];}else{\$t=\$sarr['Where']['".$k."']['elsevalue'];};";
								@eval($c);							
								$v = preg_replace('/%'.$k.'/', $v, $t);								
							}else if (isset($sarr['Where'][$k]['switch']) && isset($sarr['Where'][$k]['values']) && is_array($sarr['Where'][$k]['values']) && count($sarr['Where'][$k]['values'])>0) {
								foreach ($sarr['Where'][$k]['values'] as $field => $val) {
									if ($v==$field) {
										$t = $val;
									}
								}
								$v = preg_replace('/%'.$k.'/', $v, $t);	
							}										
						}
						if ($k=='name') {
							$v = $prefix.$v;
						}					
						array_push($values, $v);
					}else if($f=='#'.$k) {
						array_push($values, $v);
					}														
				}			
			}		
			foreach ($matches as $mk => $mv) {
				$matches[$mk] = '/'.$mv.'/';
			}
			$s = preg_replace($matches, $values, $tds);
		}
		return $s;
	}	
}