<?php
/**
 * Pagination分页抽象类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-11-2
 * @package      Geeleaf/helper
 * @abstract
 */
  
abstract class Pagination {
	public 	  $Page 	   = 0;	
	public    $Records 	   = 0;
	protected $RecordCount = 0;
	protected $PageCount   = 0;
	protected $RecordIndex = 0;	
	abstract public function get();	
	protected function _getRecordIndex() {
		$this->Page = intval($this->Page);
		return ($this->Page - 1) * $this->Records;
	}

	public function getRecordCount() {
		return $this->RecordCount;
	}

	public function getPageCount() {
		$pagecount = $this->getRecordCount();
		if($this->Records > 0) {
			$pagecount = ceil($this->RecordCount / $this->Records);
		}
		return intval($pagecount);
	}	
}