<?php
/**
 * MySQL分页类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-11-2
 * @package      Geeleaf/helper	 
 */
 
class PaginationMysql extends Pagination {
	public  $Page	 = 0;
	public  $Records = 5;
	private $table   = "";
	private $joins   = "";
	private $fields  = "";
	private $where   = "";
	private $order	 = "";
	private $orm	 = NULL;
	private static $instance = NULL;

	public function __construct($db='',$configarr=array()) {
		$_db = Config::load('database');
		if(empty($db)){		
			$this->orm = new GeeleafORM('',$configarr);
		}else{			
			$this->orm = new GeeleafORM($db,$configarr);
		}
	}

	public static function factory($table,$db='',$configarr=array()) {
		if(self::$instance==NULL) {
			self::$instance = new self($db,$configarr);
			self::$instance->orm->from($table);
		}		
		return self::$instance;
	}

	public function table($table){
		$this->table = $table;
		$this->orm->from($table);
	}

	public function join($tables) {
		$this->joins = $tables;
	}

	public function select($fields) {
		$this->fields = $fields;
	}

	public function order($str) {
		$this->order = $str;
	}

	public function where($where) {
		$this->where = $where;
	}

	public function getRecordCount() {
		return $this->RecordCount = $this->orm
								  		 ->join($this->joins)
								  		 ->fields($this->fields)
								  		 ->where($this->where)
								 		 ->count();
	}

	public function getPageCount() {
		return parent::getPageCount();
	}

	public function get() {
		$this->RecordIndex = $this->_getRecordIndex();		
		if($this->RecordIndex<0){
			return NULL;
		}
		return $this->orm
				    ->join($this->joins)
				    ->fields($this->fields)
				    ->where($this->where)
				    ->order($this->order)
				    ->limit($this->RecordIndex+1,$this->Records)
				    ->getMeta();
	}
}