<?php
/**
 * 分页风格类
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-11-3
 * @package      Geeleaf/helper
 * @example		 
 */
  
class PaginationStyle {
	public $Page = 1;
	public $RecordCount = '';	
	public $PageCount = 1;	
	private static $instance = NULL;
	private $link = '';

	public static function factory($page,$pagecount) {
		if (self::$instance==NULL) {
			self::$instance = new self();
		}
		self::$instance->Page = $page;
		self::$instance->PageCount = $pagecount;
		return self::$instance;
	}

	private function _pre() {
		return ($this->Page > 2) ? $this->Page-1 : 1;
	}

	private function _next() {
		return ($this->Page < $this->PageCount) ? $this->Page+1 : $this->PageCount;
	}

	public function setLink($link) {
		$this->link = $link;	
	}

	public function getOne($width=0,$height=0,$useRoot=FALSE) {
		$curpage   = intval($this->Page);
		$pcount    = intval($this->PageCount);		
		$tail 	   = '<span style="clear:left;"></span></span>';	
		$panel_wh  = '';
		$more 	   = '';
		$pages 	   = '';
		$more_tail = '';		
		$_prelink  = vsprintf($this->link, array($this->_pre()));
		$_nextlink = vsprintf($this->link, array($this->_next()));		
		if (empty($curpage) || empty($pcount)) {
			return NULL;
		}		
		if ($curpage==1 && $pcount==1){
			$pre_next  = '<span class="gee_pagination_one"><div class="pre" style="color:#989898;">上一页&nbsp;</div><div class="next" style="color:#989898;">&nbsp;下一页</div>';	
		}elseif($curpage>1 && $curpage<$pcount) {
			$pre_next  = '<span class="gee_pagination_one"><a class="gee_pagination_one_a" href="'.$_prelink.'"><div class="pre">上一页&nbsp;</div></a><a class="gee_pagination_one_a" href="'.$_nextlink.'"><div class="next">&nbsp;下一页</div></a>';
		}elseif($curpage<=1) {
			$pre_next  = '<span class="gee_pagination_one"><div class="pre" style="color:#989898;">上一页&nbsp;</div><a class="gee_pagination_one_a" href="'.$_nextlink.'"><div class="next">&nbsp;下一页</div></a>';
		}elseif ($curpage>=$pcount){
			$pre_next  = '<span class="gee_pagination_one"><a class="gee_pagination_one_a" href="'.$_prelink.'"><div class="pre">上一页&nbsp;</div></a><div class="next" style="color:#989898;">&nbsp;下一页</div>';	
		}	
		if ($pcount > 2) {	
			$_width  = intval($width);
			$_height = intval($height);		
			if(!empty($_width) && !empty($_height)) {				
				$panel_wh = " style='width:".$_width."px;height:".$_height."px;'";
			}			
			$more = '<div class="arrow_right" onclick="gee_pagination_one(this);"></div><div id="gee_pagination_one_panel"'.$panel_wh.' class="panel"><table>';
			for($i=1;$i<=$pcount;$i++) {
				if($i%6==1) {
					$pages .= '<tr>';
				}				
				if($curpage==$i) {
					$pages .= '<td style="color:#AEAEAE;font-weight:bold;">'.$i.'</td>';
				}else{
					$link = vsprintf($this->link, array($i));
					$pages .= '<td><a class="gee_pagination_one_a" href="'.$link.'">'.$i.'</a></td>';
				}
				if($i%6==0 || $i>=$pcount) {
					$pages .= '</tr>';
				}
			}			
			$more_tail = '</table><div style="text-align:right;padding:3px 4px 0 0;font-size:12px;"><span>'.$this->RecordCount.'</span>&nbsp;&nbsp;&nbsp;<span>'.$this->Page.'/'.$this->PageCount.'</span></div>';;
		}	
		return Html::innerCss('pageone/style.css',$useRoot).$pre_next.$more.$pages.$more_tail.$tail.Html::innerJs('pageone/func.js',$useRoot);	
	}

	public function getTwo($max=10,$usedcss=true) {	
		$max = intval($max);		
		$curpage   = intval($this->Page);
		$pcount    = intval($this->PageCount);
		if (empty($curpage) || empty($pcount)) {
			return NULL;
		}
		$_min = $curpage < floor(12*$max/20) ? 1 : $curpage-floor(10*$max/20);
		$_max = $curpage + floor(10*$max/20) - 1;
		$min_num = $_min > 0 ? $_min : 1;
		$max_num = $_max > 0 ? $_max : 1;		
		$prefix = "<p class='gee_pagination_two'>";
		$bar = "";	
		$suffix = "</p>";
		$_prelink  = vsprintf($this->link, array($this->_pre()));
		$_nextlink = vsprintf($this->link, array($this->_next()));
		if($curpage<=$pcount && $curpage>0){
			if($curpage > 1){
				$bar .= "<a class='gee_pagination_two_a' href='".$_prelink."'><span class='gee_pagination_two pagenum'><</span></a>";
			}
			for($i=$min_num; $i<=$max_num && $i<=$pcount; $i++){
				if($i==$curpage){
					$bar .= "<span class='gee_pagination_two currpage'>".$i."</span>";
				}else{
					$link = vsprintf($this->link, array($i));
					$bar .= "<a class='gee_pagination_two_a' href='".$link."'><span class='gee_pagination_two pagenum'>$i</span></a>";
				}
			}
			if($curpage < $pcount){
				$bar .= "<a class='gee_pagination_two_a' href='".$_nextlink."'><span class='gee_pagination_two pagenum'>></span></a>";
			}
		}		
		$sbar = $prefix.$bar.$suffix;
		if($usedcss) {
			$sbar = Html::innerCss('pagetwo/style.css').$sbar;
		}
		return $sbar;
	}
}