<?php
/**
 * 缩略图生成类.支持 jpg/gif/png
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-11-27
 * @package      Geeleaf/helper
 */

class Thumb {
	
	private static $ins = NULL;
	private $s_image = "";
	private $s_width = 0;
	private $s_height = 0;
	private $s_type = "";
	
	public function __construct($source) {
		$arr = @getimagesize($source);
		if($arr) {
			$this->s_width = $arr[0];
			$this->s_height = $arr[1];
			$this->s_type  = $arr['mime'];	
			$this->s_image = $source;
		}		
	}

	public static function factory($source) {
		if (!(self::$ins instanceof self)) {
			self::$ins = new self($source);
		}
		return self::$ins;
	}

	public function resize($width,$height,$filename=NULL) {
		if(!is_int($width) || !is_int($height) || ($width>0 && $height<=0) || ($height>0 && $width<=0)) {
			return FALSE;
		}
		$s_im = NULL;
		$new_im = NULL;
		$imagefunc = "imagejpeg";
		switch ($this->s_type) {
			case 'image/jpeg':
				$s_im = imagecreatefromjpeg($this->s_image);
				break;
			case 'image/gif':
				$s_im = imagecreatefromgif($this->s_image);
				$imagefunc = "imagegif";
				break;
			case 'image/png':
				$s_im = imagecreatefrompng($this->s_image);
				$imagefunc = "imagepng";
				break;
		}
		if (($width==$this->s_width && $height==$this->s_height) || $width<=0 && $height<=0) {
			$new_im = $s_im;
		}else{
			$new_im = imagecreatetruecolor($width, $height);
			imagecopyresampled($new_im,$s_im,0,0,0,0,$width,$height,$this->s_width,$this->s_height);
		}
		if($new_im!=NULL) {	
			header("Content-Type: ".$this->s_type);
			if ($imagefunc=='imagejpeg') {
				imagejpeg($new_im, $filename, 100);
			}else{
				$imagefunc($new_im, $filename);
			}				
			imagedestroy($new_im);  
	     	imagedestroy($s_im); 
	     	return TRUE;
		} 
		return FALSE;
	}
}