<?php
/**
 * 插件管理类.负责插件的调用/禁用等操作
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-11-24
 * @package      Geeleaf/plugin
 */
  
final class Plugin {
	private $hooks = array();
	private static $instance = NULL;	
	private function __construct() {}
	private function __clone() {}	

	public static function getInstance() {
		if(!(self::$instance instanceof self)) {
			self::$instance = new self();
		}
		return self::$instance;
	}	

	public function run($hook,$method,$argvs=array()) {
		$can_run = -1;
		$PluginObj = NULL;
		if(!(isset($this->hooks["'".$hook."'"]) && count($this->hooks["'".$hook."'"])>0)) {
			$this->_loadClass($hook);
		}	
		if(class_exists($hook)){
			$PluginObj = new $hook();			
			if(!isset($this->hooks["'".$hook."'"])) {
				$this->hooks["'".$hook."'"] = array(
					'Active' => TRUE
				);
				$can_run = 1;
			}else{
				if($this->hooks["'".$hook."'"]['Active']) {
					$can_run = 1;
				}else{
					$can_run = 0;
				}
				if($can_run==0 && method_exists($PluginObj,'disabledRun')) {
					return call_user_func_array(array($PluginObj,'disabledRun'),$argvs);
				}
			}
			$can_run = (method_exists($PluginObj,$method)&&$can_run==1) ? TRUE : FALSE;					
		}
		if($can_run==1 && is_array($argvs)) {
			return call_user_func_array(array($PluginObj,$method),$argvs);
		}
		return FALSE;		
	}	

	public function activate($hook) {		
		if(isset($this->hooks["'".$hook."'"]) && count($this->hooks["'".$hook."'"])>0) {
			$this->hooks["'".$hook."'"]['Active'] = TRUE;
		}else{
			$this->_loadClass($hook);	
			if(class_exists($hook)){			
				$this->hooks["'".$hook."'"] = array(
					'Active' => TRUE
				);					
			}
		}
	}	

	public function deactivate($hook) {
		if(isset($this->hooks["'".$hook."'"]) && count($this->hooks["'".$hook."'"])>0) {
			$this->hooks["'".$hook."'"]['Active'] = FALSE;
		}else{
			$this->_loadClass($hook);	
			if(class_exists($hook)){			
				$this->hooks["'".$hook."'"] = array(
					'Active' => FALSE
				);					
			}
		}
	}	

	private function _loadClass($hook) {
		if(!class_exists($hook)){
			spl_autoload_register('self::_loadPlugins');
		}
	}

	private static function _loadPlugins($plugin) {
		$plugindir = Config::load('global');
		$plugindir = @$plugindir['PluginDir'];
		if(empty($plugindir)) {
			throw new GeeLeafException(1018);
		}
		$plugindir = (substr($plugindir, -1,1)!=DIRECTORY_SEPARATOR) ? $plugindir.DIRECTORY_SEPARATOR : $plugindir;
		$_classfile = $plugindir.$plugin.'.class.php';
		is_readable($_classfile) && require $_classfile;
	}
}