<?php
/**
 * Cookie Session 驱动
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-16
 * @package      Geeleaf/session
 * @final
 */
  
final class CookieSessionDriver implements SessionInterface {	
	private $sessionConf = NULL;	
	private $cookie = NULL;
	public function __construct() {
		if($this->sessionConf===NULL){
			$this->sessionConf = Config::load('session');
			if(!(bool)$this->sessionConf){
				throw new GeeLeafException(1002);
			}
			$this->cookie = Cookie::getInstance();		
		}
		ob_start();
	}
	
	public function open($save_path, $session_name){		
		return TRUE;
	}
	
	public function close() {
		return TRUE;
	}
	
	public function read($id) {
		if($this->sessionConf['Encrypt']){
			return Geeleaf_func_crypt($this->cookie->get($this->sessionConf['Name'].$id),$this->sessionConf['EncryptSalt'],false);
		}
		return Cookie::get($this->sessionConf['Name'].$id);
	}
	
	public function write($id, $sess_data) {	
		if($this->sessionConf['Encrypt']){
			$this->cookie->set($this->sessionConf['Name'].$id,Geeleaf_func_crypt($sess_data,$this->sessionConf['EncryptSalt'],true),$this->sessionConf['Expire']);
		}else{
			Cookie::set($this->sessionConf['Name'].$id,$sess_data,$this->sessionConf['Expire']);
		}
		ob_end_flush();	
	}
	
	public function destroy($id) {
		 $this->cookie->delete($this->sessionConf['Name'].$id);
	}

	public function gc($maxlifetime) {	
		return TRUE;
	}
}