<?php
/**
 * Database Session 驱动
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-24
 * @package      Geeleaf/session
 * @final
 */

final class DatabaseSessionDriver implements SessionInterface {	
	private $sessionConf = NULL;
	private $sess  = NULL;	
	public function __construct() {
		if($this->sessionConf===NULL){
			
			$this->sess = GeeleafORM::factory('sessions');
			$this->sessionConf = Config::load('session');
			if(!(bool)$this->sessionConf){
				throw new GeeLeafException(1002);
			}				
			if (!(isset($this->sessionConf['Table'])&&$this->sessionConf['Table'])) {
				throw new GeeLeafException(1009);;
			}
			
			$this->sessionOrm = GeeleafORM::factory($this->sessionConf['Table']);
		}
	}
	
	public function open($save_path, $session_name){	
		return TRUE;
	}
	
	public function close() {
		return TRUE;
	}
	
	public function read($id) {
		$_result = $this->sess->fields('geeleaf_session_data')->where("geeleaf_session_id='".$id."' AND geeleaf_session_expire > ".time())->getMetaOne();
   		return (string)$_result['geeleaf_session_data'];
	}
	
	public function write($id, $sess_data) {
   		$this->sess->geeleaf_session_id = $id;
   		$this->sess->geeleaf_session_data = $sess_data;
   		$this->sess->geeleaf_session_expire = time() + $this->sessionConf['Expire'];
   		if(!(bool)$this->sess->insert()) {
   			return (bool)$this->sess->where("geeleaf_session_id='".$this->sess->geeleaf_session_id."'")->update();
   		}
	}
	
	public function destroy($id) {
		return (bool)$this->sess->where("geeleaf_session_id='".$id."'")->delete();
	}
	
	public function gc($maxlifetime) {		
		return (bool)$this->sess->where("geeleaf_session_expire < ".time()-$this->sessionConf['Expire'] )->delete();
	}
}