<?php
/**
 * Session 类.在使用Session类浏览器不能有任何输出
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-16
 * @package      Geeleaf/session
 * @final
 */
  
final class Session {
	
	private static $instance = NULL;
	private static $sessionDriverFlag = "";
	private static $sessionDriver = NULL;
	private static $sessionConf = NULL;

	public function __construct() {		
		if(is_null(self::$instance)){		
			self::$sessionConf = Config::load('session');
			if(!(bool)self::$sessionConf){
				throw new GeeLeafException(1002);
			}			
			if(isset(self::$sessionConf['Driver']) && self::$sessionConf['Driver']){
				self::$sessionDriverFlag = ucfirst(self::$sessionConf['Driver']);
			}			
			self::init();			
			register_shutdown_function(array($this,'close'));		
		}
	}

	public static function getInstance() {
		if(is_null(self::$instance)){
			self::$instance = new self();
		}
		return self::$instance;
	}

	private static function init() {
		$_DriverPrefix = self::$sessionDriverFlag;	
		$_UpperDriverPrefix	= strtoupper($_DriverPrefix);		
		$_SessExpire = self::$sessionConf['Expire'];
		$_SuccessSet = @ini_set('session.gc_maxlifetime',$_SessExpire);
		if($_SuccessSet==NULL){
			$_SessExpire = (int)ini_get('session.gc_maxlifetime');
		}
		
		if($_UpperDriverPrefix=='COOKIE'){
			$_CookieSet = Config::load('cookie');
			if(!(bool)$_CookieSet){
				throw new GeeLeafException(1003);
			}		
			session_set_cookie_params(
				$_SessExpire,
				$_CookieSet['Path'],
				$_CookieSet['Domain'],
				$_CookieSet['Secure'],
				$_CookieSet['HttpOnly']
			);	
		}
		if($_UpperDriverPrefix=="COOKIE" || $_UpperDriverPrefix=="DATABASE") {
			$_DriverPrefix .= "SessionDriver"; 
			self::$sessionDriver = new $_DriverPrefix;	
			session_set_save_handler(
				array(self::$sessionDriver, 'open'),
				array(self::$sessionDriver, 'close'),
				array(self::$sessionDriver, 'read'),
				array(self::$sessionDriver, 'write'),
				array(self::$sessionDriver, 'destroy'),
				array(self::$sessionDriver, 'gc')
			);
		}	
		if(headers_sent()){
			GeeleafLog::write('session_start()之前不能有任何浏览器的输出');
			throw new GeeLeafException(1004);
		}
		session_start();		
	}

	public function set($id,$data) {
		$_SESSION[$id] = $data;
	}

	public function get($id='') {
		$response = NULL;
		if (empty($id)) {
			$response = $_SESSION;
		}else{
			$response = isset($_SESSION[$id]) ? $_SESSION[$id] : NULL;
		}
		return $response;
	}

	public function delete($id) {
		unset($_SESSION[$id]);
	}

	public function close(){
		if(session_id()){
			session_write_close();
		}
	}
	
}