<?php
/**
 * 使用PHP原生语法的模板引擎
 * @author       rostar <rostar@126.com>
 * @copyright    Copyright (c) 2012
 * @version      1.0.0
 * @date         2011-10-27
 * @package      Geeleaf/view
 */
  
	class TemplateOne {
		public $Tfile = "";
		private $VarsArr = array();

		public function __construct($file="") {
			if(!empty($file)){
				$this->setTemplate($file);	
			}		
		}

		public function __set($key, $value)	{			
			$this->VarsArr[$key] = $value;
		}
		
		public function &__get($key) {
			if (isset($this->VarsArr[$key])){
				return $this->VarsArr[$key];
			}
		}

		public function setTemplate($file) {
			if(is_file($file)) {
				$this->Tfile = $file;
			}else{
				throw new GeeLeafException(1012);
			}
		}

		public function assign($name, $value=NULL) {
			if(is_array($name)){
				foreach($name as $k=>$v){
					$this->__set($k,$v);
				}
			}else{
				$this->__set($name,$value);
			}
			return $this;
		}

		public function render($print=true) {			
			if(empty($this->Tfile)) {
				return FALSE;
			}
			$output = $this->_importTmp($this->Tfile,$this->VarsArr);
			if($print){
				echo $output;return;
			}else{
				return $output;
			}
		}

		private function _importTmp($file, $arr) {			
			ob_start();
			if($arr){
				extract($arr,EXTR_SKIP);
			}
			require $file;			
			return ob_get_clean();
		}
	}