<?php 

class indexController extends Controller {
	//页面缓存文件
	private $pcache = '';
	//查询字符串.由post和get参数组成
	private $qrystr = '';	
	private $orm = null;	
	public function __construct() {
		global $GEEORM;
		$this->qrystr = $this->_makeQueryString(); 
		$this->pcache = GEELEAF_ROOT.'/cache/pages/'._getTheme().'_'.md5($_SERVER['REQUEST_URI']);
		$this->orm = $GEEORM;
	}	
	public function __destruct() {
		$this->orm->close();
	}	
	public function index() {
		//优先读取页面缓存	
		if (!$this->_hasCache()) {
			$t = GEECMS_THEMES._getTheme().'/index.php';
			if (is_readable($t)) {				
				$content = _printView($t, $this->_varsArr(), false);
				_writePageCache($this->pcache, $content);		
			}else{				
				if(!_run404()) $this->run404();
				exit;
			}
		}		
		_readPageCache($this->pcache, $this->_varsArr());				
	}	
	public function _guide($channel,$contentorpage='',$cpage='') {
		//禁止外部用_guide直接访问
		if(strpos($_SERVER['REQUEST_URI'], 'index/_guide')!==false){
			if(!_run404()) $this->run404();
			return false;
		}
		$useContent = false;
		$contentid = intval(str_replace('content_', '', $contentorpage));
		$page = intval(str_replace('page_', '', $contentorpage));
		$page = !empty($page) ? $page : $cpage;
		$useContent = (bool)$contentid;
		$urlfield = '';		
		$wcache = true; //是否写缓存	
		
		if(_sessionVar('LastChannel')==$channel) {
			//记录最近一次列表页码
			if(intval($page)>0) {
				Session::getInstance()->set('LastListPage', $page);
			}
		}else{
			Session::getInstance()->set('LastListPage', 1);
		}
		Session::getInstance()->set('LastChannel', $channel);
		//系统内部模板变量
		$SysVars = array();
		$SysVars['Page'] = intval($page) > 0 ? $page : 1;
		$SysVars['QueryString'] = $this->qrystr;
		$channelid = 0;		
		//没有缓存文件
		if (!$this->_hasCache()) {
			$tpl = '';			
			$tpls = $this->_getTemplateByChannel($channel);
			if($tpls) {
				if (!$useContent) {
					$tpl = $tpls['tpl']; //主模板
				}else{					
					$tpl = $tpls['ctpl']; //内容模板
				}
				$channelid = $tpls['id']; //栏目id
				$urlfield = !empty($tpls['urlfield']) ? $tpls['urlfield'] : $tpls['id'];
			}else{
				//直接访问主题_logic目录的文件
				$wcache = false;
				$tpl = DIRECTORY_SEPARATOR.'_logic'.DIRECTORY_SEPARATOR.$channel.'.php';
			}
			$tfile = GEECMS_THEMES._getTheme().$tpl;
			if (is_readable($tfile)) {
				$SysVars['ChannelId'] = $channelid;
				$SysVars['ContentId'] = $contentid;
				$SysVars['ContentPage'] = !empty($cpage) ? $cpage : $SysVars['Page']; //内容页码
				$SysVars['URLField'] = $urlfield;

				$content = _printView($tfile,array_merge($SysVars, $this->_varsArr()),!$wcache);
				if ($wcache) {					
					$s = "<?php return array('ChannelId'=>'$channelid','ContentId'=>'$contentid','ContentPage'=>'{$SysVars['ContentPage']}','URLField'=>'$urlfield'); ?>";
					_writePageCache($this->pcache, $content, $s);
				}
			}else{
				if(!_run404()) $this->run404();
				return false;
			}
		}		
		if ($wcache) {
			_readPageCache($this->pcache, $this->_varsArr($SysVars));
		}
	}	
	public function _getcaptcha() {
		$s = "ABCDEFGHJKLMNPQRSTUVWXYZabcdefghkmnpqrstuvwxyz2356789";
		$text = "";
		for ($i = 0; $i < 4; $i++) {
			$text .= $s{rand(0,52)};
		}
		$c = new Captcha(false);
		$c->Font      = '';
		$c->Width     = 70;
		$c->Height    = 32;
		$c->BgColor   = '#ffffff';
		$c->FontColor = '';
		$c->LineColor = '';
		$c->LineCount = 3;
		$c->Pixel     = 10;	
		$c->Text = $text;
		Session::getInstance()->set('Captcha', strtolower($text));
		$c->get();
	}	
	private function _getTemplateByChannel($idorurlfield) {
		global $GEEORM;
		$table = _getChannelTables();
		$c = $table[0];
		//主题的栏目-模板关联表的表名格式: gee[主题名]tpls
		$t = _getTablePrefix().'gee'._getTheme().'tpls';
		$idorurlfield = Geeleaf_func_m_escape($idorurlfield);
		$cond = "$c.id=$t.channel_id";
		if (is_numeric($idorurlfield)) {
			$cond .= " AND ($c.id=$idorurlfield OR $c.urlfield='$idorurlfield')";
		}else{
			$cond .= " AND $c.urlfield='$idorurlfield'";
		}		
		$sql = "SELECT $c.id,$c.urlfield,$t.tpl,$t.ctpl FROM $c,$t WHERE $cond";
		return $GEEORM->queryOne($sql);
	}	
	/**
	 * 将$_POST $_GET $_SESSION $_COOKIE和_getNoPageCache()的键值替换为模板变量
	 * 注意保证各个数组之间键名的唯一性,否则键名后面的值将覆盖前一个值
	 */
	private function _varsArr($appendarr=array()) {
		$_post  = (array)Client::getInstance()->post();
		$_get   = (array)Client::getInstance()->get();
		$_sess  = (array)Session::getInstance()->get();
		$_cooki = (array)Client::getInstance()->cookie();
		return array_merge($_post,$_get,$_sess,$_cooki,_getNoPageCache(),$appendarr);		
	}	
	private function _makeQueryString() {
		$s = '';
		$pgarr = array();
		$postarr = Client::getInstance()->post();
		$getarr = Client::getInstance()->get();				
		if(is_array($postarr) && is_array($getarr)) {
			$pgarr = array_merge($postarr, $pgarr);
		}else if (is_array($postarr)) {
			$pgarr = $postarr;
		}else if (is_array($getarr)) {
			$pgarr = $getarr;
		}
		foreach ($pgarr as $k=>$v) {
			$s .= $k.'='.$v.'&';
		}		
		$s = (string)substr($s, 0, strlen($s)-1);
		if (!empty($s)) {
			$s = '?'.$s;
		}
		return $s;
	}	
	private function _hasCache() {
		return is_readable($this->pcache);
	}
}	
?>